/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.TreeMap;
import org.garret.perst.Assert;
import org.garret.perst.CustomAllocator;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.StorageImpl;

public class BitmapCustomAllocator
extends Persistent
implements CustomAllocator {
    protected int quantum;
    protected int quantumBits;
    protected long base;
    protected long limit;
    protected Link pages;
    protected int extensionPages;
    transient int currPage;
    transient int currOffs;
    transient TreeMap reserved = new TreeMap();
    static final int BITMAP_PAGE_SIZE = 4084;
    static final int BITMAP_PAGE_BITS = 32672;

    public BitmapCustomAllocator(Storage storage, int n2, long l2, long l3, long l4) {
        super(storage);
        this.quantum = n2;
        this.base = l2;
        this.limit = l4;
        int n3 = 0;
        for (int i2 = n2; i2 != 1; i2 >>>= 1) {
            ++n3;
        }
        this.quantumBits = n3;
        Assert.that(1 << n3 == n2);
        this.extensionPages = (int)((l3 + (32672L << this.quantumBits) - 1L) / (32672L << this.quantumBits));
        this.pages = storage.createLink();
    }

    protected BitmapCustomAllocator() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public long allocate(long l2) {
        l2 = l2 + (long)this.quantum - 1L & (long)(~(this.quantum - 1));
        long l3 = l2 >> this.quantumBits;
        long l4 = 0L;
        int n2 = this.currPage;
        int n3 = this.pages.size();
        int n4 = this.currOffs;
        long l5 = 0L;
        block0: while (true) {
            int n5 = n2;
            while (true) {
                BitmapPage bitmapPage;
                if (n5 < n3) {
                    bitmapPage = (BitmapPage)this.pages.get(n5);
                } else {
                    if (n2 == 0) {
                        n2 = this.pages.size();
                        n3 = n2 + ((n5 = (int)(l2 / (long)(32672 * this.quantum))) > this.extensionPages ? n5 : this.extensionPages);
                        if ((long)n3 * 32672L * (long)this.quantum > this.limit) {
                            throw new StorageError(10);
                        }
                        this.pages.setSize(n3);
                        for (int i2 = n2; i2 < n3; ++i2) {
                            BitmapPage bitmapPage2 = new BitmapPage();
                            bitmapPage2.data = new byte[4084];
                            this.pages.set(i2, bitmapPage2);
                        }
                        l4 = l5;
                        continue block0;
                    }
                    l5 = l4;
                    l4 = 0L;
                    n3 = n2 + 1;
                    n2 = 0;
                    continue block0;
                }
                while (n4 < 4084) {
                    long l6;
                    int n6 = bitmapPage.data[n4] & 0xFF;
                    if (l4 + (long)StorageImpl.firstHoleSize[n6] >= l3) {
                        l6 = this.base + (((long)n5 * 4084L + (long)n4) * 8L - l4 << this.quantumBits);
                        long l7 = this.wasReserved(l6, l2);
                        if (l7 != 0L) {
                            long l8 = (l7 - this.base >>> this.quantumBits) + 7L;
                            n5 = (int)(l8 / 32672L);
                            n4 = (int)(l8 - (long)n5 * 32672L) >> 3;
                            l4 = 0L;
                            continue;
                        }
                        this.currPage = n5--;
                        this.currOffs = n4;
                        int n7 = n4;
                        bitmapPage.data[n7] = (byte)(bitmapPage.data[n7] | (byte)((1 << (int)(l3 - l4)) - 1));
                        bitmapPage.modify();
                        if (l4 != 0L) {
                            if (l4 > (long)(n4 * 8)) {
                                BitmapCustomAllocator.memset(bitmapPage, 0, 255, n4);
                                l4 -= (long)(n4 * 8);
                                bitmapPage = (BitmapPage)this.pages.get(n5);
                                n4 = 4096;
                            }
                            while (l4 > 32672L) {
                                BitmapCustomAllocator.memset(bitmapPage, 0, 255, 4084);
                                l4 -= 32672L;
                                bitmapPage = (BitmapPage)this.pages.get(--n5);
                            }
                            while ((l4 -= 8L) > 0L) {
                                bitmapPage.data[--n4] = -1;
                            }
                            int n8 = n4 - 1;
                            bitmapPage.data[n8] = (byte)(bitmapPage.data[n8] | (byte)(~((1 << -((int)l4)) - 1)));
                            bitmapPage.modify();
                        }
                        return l6;
                    }
                    if ((long)StorageImpl.maxHoleSize[n6] >= l3) {
                        byte by2 = StorageImpl.maxHoleOffset[n6];
                        l6 = this.base + (((long)n5 * 4084L + (long)n4) * 8L + (long)by2 << this.quantumBits);
                        long l9 = this.wasReserved(l6, l2);
                        if (l9 == 0L) {
                            this.currPage = n5;
                            this.currOffs = n4;
                            int n9 = n4;
                            bitmapPage.data[n9] = (byte)(bitmapPage.data[n9] | (byte)((1 << (int)l3) - 1 << by2));
                            bitmapPage.modify();
                            return l6;
                        }
                        long l10 = (l9 - this.base >>> this.quantumBits) + 7L;
                        n5 = (int)(l10 / 32672L);
                        n4 = (int)(l10 - (long)n5 * 32672L) >> 3;
                        l4 = 0L;
                        continue;
                    }
                    ++n4;
                    if (StorageImpl.lastHoleSize[n6] == 8) {
                        l4 += 8L;
                        continue;
                    }
                    l4 = StorageImpl.lastHoleSize[n6];
                }
                n4 = 0;
                ++n5;
            }
            break;
        }
    }

    public long reallocate(long l2, long l3, long l4) {
        StorageImpl storageImpl = (StorageImpl)this.getStorage();
        if ((l4 + (long)this.quantum - 1L & (long)(~(this.quantum - 1))) > (l3 + (long)this.quantum - 1L & (long)(~(this.quantum - 1)))) {
            long l5 = this.allocate(l4);
            this.free0(l2, l3);
            l2 = l5;
        }
        return l2;
    }

    public void free(long l2, long l3) {
        this.reserve(l2, l3);
        this.free0(l2, l3);
    }

    private long wasReserved(long l2, long l3) {
        Location location = new Location(l2, l3);
        Location location2 = (Location)this.reserved.get(location);
        if (location2 != null) {
            return Math.max(l2 + l3, location2.pos + location2.size);
        }
        return 0L;
    }

    private void reserve(long l2, long l3) {
        Location location = new Location(l2, l3);
        this.reserved.put(location, location);
    }

    private void free0(long l2, long l3) {
        long l4 = l2 - this.base >>> this.quantumBits;
        long l5 = l3 + (long)this.quantum - 1L >>> this.quantumBits;
        int n2 = (int)(l4 / 32672L);
        int n3 = (int)(l4 - (long)n2 * 32672L) >> 3;
        BitmapPage bitmapPage = (BitmapPage)this.pages.get(n2);
        int n4 = (int)l4 & 7;
        if (l5 > (long)(8 - n4)) {
            l5 -= (long)(8 - n4);
            int n5 = n3++;
            bitmapPage.data[n5] = (byte)(bitmapPage.data[n5] & (1 << n4) - 1);
            while (l5 + (long)(n3 * 8) > 32672L) {
                BitmapCustomAllocator.memset(bitmapPage, n3, 0, 4084 - n3);
                bitmapPage = (BitmapPage)this.pages.get(++n2);
                l5 -= (long)((4084 - n3) * 8);
                n3 = 0;
            }
            while ((l5 -= 8L) > 0L) {
                bitmapPage.data[n3++] = 0;
            }
            int n6 = n3;
            bitmapPage.data[n6] = (byte)(bitmapPage.data[n6] & (byte)(~((1 << (int)l5 + 8) - 1)));
        } else {
            int n7 = n3;
            bitmapPage.data[n7] = (byte)(bitmapPage.data[n7] & (byte)(~((1 << (int)l5) - 1 << n4)));
        }
        bitmapPage.modify();
    }

    static final void memset(BitmapPage bitmapPage, int n2, int n3, int n4) {
        byte[] byArray = bitmapPage.data;
        byte by2 = (byte)n3;
        while (--n4 >= 0) {
            byArray[n2++] = by2;
        }
        bitmapPage.modify();
    }

    public void commit() {
        this.reserved.clear();
    }

    static class Location
    implements Comparable {
        long pos;
        long size;

        Location(long l2, long l3) {
            this.pos = l2;
            this.size = l3;
        }

        public int compareTo(Object object) {
            Location location = (Location)object;
            return this.pos + this.size <= location.pos ? -1 : (location.pos + location.size <= this.pos ? 1 : 0);
        }
    }

    static class BitmapPage
    extends Persistent {
        byte[] data;

        BitmapPage() {
        }
    }
}

