/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Index;
import org.garret.perst.Key;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentIterator;
import org.garret.perst.PersistentResource;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.ClassDescriptor;
import org.garret.perst.impl.QueryImpl;
import org.garret.perst.impl.StorageImpl;

class AltBtree
extends PersistentResource
implements Index {
    int height;
    int type;
    int nElems;
    boolean unique;
    BtreePage root;
    transient int updateCounter;
    static final int op_done = 0;
    static final int op_overflow = 1;
    static final int op_underflow = 2;
    static final int op_not_found = 3;
    static final int op_duplicate = 4;
    static final int op_overwrite = 5;
    static final IPersistent[] emptySelection = new IPersistent[0];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$org$garret$perst$IPersistent;
    static /* synthetic */ Class class$java$lang$Comparable;

    AltBtree() {
    }

    static int checkType(Class clazz) {
        int n2 = ClassDescriptor.getTypeCode(clazz);
        if (n2 > 10 && n2 != 12) {
            throw new StorageError(8, clazz);
        }
        return n2;
    }

    AltBtree(Class clazz, boolean bl2) {
        this.unique = bl2;
        this.type = AltBtree.checkType(clazz);
    }

    AltBtree(int n2, boolean bl2) {
        this.type = n2;
        this.unique = bl2;
    }

    public Class[] getKeyTypes() {
        return new Class[]{this.getKeyType()};
    }

    public Class getKeyType() {
        return AltBtree.mapKeyType(this.type);
    }

    static Class mapKeyType(int n2) {
        switch (n2) {
            case 0: {
                return Boolean.TYPE;
            }
            case 1: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
            case 8: {
                return class$java$lang$String == null ? (class$java$lang$String = AltBtree.class$("java.lang.String")) : class$java$lang$String;
            }
            case 9: {
                return class$java$util$Date == null ? (class$java$util$Date = AltBtree.class$("java.util.Date")) : class$java$util$Date;
            }
            case 10: {
                return class$org$garret$perst$IPersistent == null ? (class$org$garret$perst$IPersistent = AltBtree.class$("org.garret.perst.IPersistent")) : class$org$garret$perst$IPersistent;
            }
            case 12: {
                return class$java$lang$Comparable == null ? (class$java$lang$Comparable = AltBtree.class$("java.lang.Comparable")) : class$java$lang$Comparable;
            }
        }
        return null;
    }

    Key checkKey(Key key) {
        if (key != null) {
            if (key.type != this.type) {
                throw new StorageError(9);
            }
            if (this.type == 10 && key.ival == 0 && key.oval != null) {
                IPersistent iPersistent = (IPersistent)key.oval;
                this.getStorage().makePersistent(iPersistent);
                key = new Key(iPersistent, key.inclusion != 0);
            }
            if (key.oval instanceof char[]) {
                key = new Key(new String((char[])key.oval), key.inclusion != 0);
            }
        }
        return key;
    }

    public IPersistent get(Key key) {
        key = this.checkKey(key);
        if (this.root != null) {
            ArrayList arrayList = new ArrayList();
            this.root.find(key, key, this.height, arrayList);
            if (arrayList.size() > 1) {
                throw new StorageError(4);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return (IPersistent)arrayList.get(0);
        }
        return null;
    }

    public IPersistent[] prefixSearch(String string) {
        if (8 != this.type) {
            throw new StorageError(9);
        }
        if (this.root != null) {
            ArrayList arrayList = new ArrayList();
            ((BtreePageOfString)this.root).prefixSearch(string, this.height, arrayList);
            if (arrayList.size() != 0) {
                return arrayList.toArray(new IPersistent[arrayList.size()]);
            }
        }
        return emptySelection;
    }

    public IPersistent[] get(Key key, Key key2) {
        if (this.root != null) {
            ArrayList arrayList = new ArrayList();
            this.root.find(this.checkKey(key), this.checkKey(key2), this.height, arrayList);
            if (arrayList.size() != 0) {
                return arrayList.toArray(new IPersistent[arrayList.size()]);
            }
        }
        return emptySelection;
    }

    public boolean put(Key key, IPersistent iPersistent) {
        return this.insert(key, iPersistent, false) == null;
    }

    public IPersistent set(Key key, IPersistent iPersistent) {
        return this.insert(key, iPersistent, true);
    }

    final void allocateRootPage(BtreeKey btreeKey) {
        Storage storage = this.getStorage();
        BtreePage btreePage = null;
        switch (this.type) {
            case 1: {
                btreePage = new BtreePageOfByte(storage);
                break;
            }
            case 3: {
                btreePage = new BtreePageOfShort(storage);
                break;
            }
            case 2: {
                btreePage = new BtreePageOfChar(storage);
                break;
            }
            case 0: {
                btreePage = new BtreePageOfBoolean(storage);
                break;
            }
            case 4: {
                btreePage = new BtreePageOfInt(storage);
                break;
            }
            case 5: 
            case 9: {
                btreePage = new BtreePageOfLong(storage);
                break;
            }
            case 6: {
                btreePage = new BtreePageOfFloat(storage);
                break;
            }
            case 7: {
                btreePage = new BtreePageOfDouble(storage);
                break;
            }
            case 10: {
                btreePage = new BtreePageOfObject(storage);
                break;
            }
            case 8: {
                btreePage = new BtreePageOfString(storage);
                break;
            }
            case 12: {
                btreePage = new BtreePageOfRaw(storage);
                break;
            }
            default: {
                Assert.failed("Invalid type");
            }
        }
        ((BtreePage)btreePage).insert(btreeKey, 0);
        btreePage.items.set(1, this.root);
        btreePage.nItems = 1;
        this.root = btreePage;
    }

    final IPersistent insert(Key key, IPersistent iPersistent, boolean bl2) {
        BtreeKey btreeKey = new BtreeKey(this.checkKey(key), iPersistent);
        if (this.root == null) {
            this.allocateRootPage(btreeKey);
            this.height = 1;
        } else {
            int n2 = this.root.insert(btreeKey, this.height, this.unique, bl2);
            if (n2 == 1) {
                this.allocateRootPage(btreeKey);
                ++this.height;
            } else if (n2 == 4 || n2 == 5) {
                return btreeKey.oldNode;
            }
        }
        ++this.updateCounter;
        ++this.nElems;
        this.modify();
        return null;
    }

    public void remove(Key key, IPersistent iPersistent) {
        this.remove(new BtreeKey(this.checkKey(key), iPersistent));
    }

    void remove(BtreeKey btreeKey) {
        if (!this.removeIfExists(btreeKey)) {
            throw new StorageError(5);
        }
    }

    boolean removeIfExists(BtreeKey btreeKey) {
        if (this.root == null) {
            return false;
        }
        int n2 = this.root.remove(btreeKey, this.height);
        if (n2 == 3) {
            return false;
        }
        --this.nElems;
        if (n2 == 2 && this.root.nItems == 0) {
            BtreePage btreePage = null;
            if (this.height != 1) {
                btreePage = (BtreePage)this.root.items.get(0);
            }
            this.root.deallocate();
            this.root = btreePage;
            --this.height;
        }
        ++this.updateCounter;
        this.modify();
        return true;
    }

    public IPersistent remove(Key key) {
        if (!this.unique) {
            throw new StorageError(4);
        }
        BtreeKey btreeKey = new BtreeKey(this.checkKey(key), null);
        this.remove(btreeKey);
        return btreeKey.oldNode;
    }

    public IPersistent get(String string) {
        return this.get(new Key(string, true));
    }

    public IPersistent[] getPrefix(String string) {
        return this.get(new Key(string, true), new Key(string + '\uffff', false));
    }

    public boolean put(String string, IPersistent iPersistent) {
        return this.put(new Key(string, true), iPersistent);
    }

    public IPersistent set(String string, IPersistent iPersistent) {
        return this.set(new Key(string, true), iPersistent);
    }

    public void remove(String string, IPersistent iPersistent) {
        this.remove(new Key(string, true), iPersistent);
    }

    public IPersistent remove(String string) {
        return this.remove(new Key(string, true));
    }

    public int size() {
        return this.nElems;
    }

    public void clear() {
        if (this.root != null) {
            this.root.purge(this.height);
            this.root = null;
            this.nElems = 0;
            this.height = 0;
            ++this.updateCounter;
            this.modify();
        }
    }

    public IPersistent[] toPersistentArray() {
        IPersistent[] iPersistentArray = new IPersistent[this.nElems];
        if (this.root != null) {
            this.root.traverseForward(this.height, iPersistentArray, 0);
        }
        return iPersistentArray;
    }

    public IPersistent[] toPersistentArray(IPersistent[] iPersistentArray) {
        if (iPersistentArray.length < this.nElems) {
            iPersistentArray = (IPersistent[])Array.newInstance(iPersistentArray.getClass().getComponentType(), this.nElems);
        }
        if (this.root != null) {
            this.root.traverseForward(this.height, iPersistentArray, 0);
        }
        if (iPersistentArray.length > this.nElems) {
            iPersistentArray[this.nElems] = null;
        }
        return iPersistentArray;
    }

    public void deallocate() {
        if (this.root != null) {
            this.root.purge(this.height);
        }
        super.deallocate();
    }

    public Iterator iterator() {
        return this.iterator(null, null, 0);
    }

    public Iterator entryIterator() {
        return this.entryIterator(null, null, 0);
    }

    public Iterator iterator(Key key, Key key2, int n2) {
        return new BtreeSelectionIterator(this.checkKey(key), this.checkKey(key2), n2);
    }

    public Iterator prefixIterator(String string) {
        return this.iterator(new Key(string), new Key(string + '\uffff', false), 0);
    }

    public Iterator entryIterator(Key key, Key key2, int n2) {
        return new BtreeSelectionEntryIterator(this.checkKey(key), this.checkKey(key2), n2);
    }

    public Iterator select(Class clazz, String string) {
        QueryImpl queryImpl = new QueryImpl(this.getStorage());
        return queryImpl.select(clazz, this.iterator(), string);
    }

    public Object getAt(int n2) {
        Iterator iterator;
        if (n2 < 0 || n2 >= this.nElems) {
            throw new IndexOutOfBoundsException("Position " + n2 + ", index size " + this.nElems);
        }
        if (n2 <= this.nElems / 2) {
            iterator = this.entryIterator(null, null, 0);
            while (--n2 >= 0) {
                iterator.next();
            }
        } else {
            iterator = this.entryIterator(null, null, 1);
            n2 -= this.nElems;
            while (++n2 < 0) {
                iterator.next();
            }
        }
        return ((Map.Entry)iterator.next()).getValue();
    }

    public Iterator entryIterator(int n2, int n3) {
        return new BtreeEntryStartFromIterator(n2, n3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BtreeEntryStartFromIterator
    extends BtreeSelectionEntryIterator {
        int start;

        BtreeEntryStartFromIterator(int n2, int n3) {
            super(null, null, n3);
            this.start = n2;
            this.reset();
        }

        void reset() {
            int n2;
            super.reset();
            int n3 = n2 = this.order == 0 ? this.start : AltBtree.this.nElems - this.start - 1;
            while (--n2 >= 0 && this.hasNext()) {
                this.next();
            }
        }
    }

    class BtreeSelectionEntryIterator
    extends BtreeSelectionIterator {
        BtreeSelectionEntryIterator(Key key, Key key2, int n2) {
            super(key, key2, n2);
        }

        protected Object getCurrent(BtreePage btreePage, int n2) {
            return new BtreeEntry(btreePage, n2);
        }
    }

    class BtreeSelectionIterator
    implements PersistentIterator {
        BtreePage[] pageStack;
        int[] posStack;
        BtreePage currPage;
        int currPos;
        int sp;
        int end;
        Key from;
        Key till;
        int order;
        int counter;
        Key nextKey;
        BtreeKey currKey;
        IPersistent nextObj;

        BtreeSelectionIterator(Key key, Key key2, int n2) {
            this.from = key;
            this.till = key2;
            this.order = n2;
            this.reset();
        }

        void reset() {
            this.sp = 0;
            this.counter = AltBtree.this.updateCounter;
            if (AltBtree.this.height == 0) {
                return;
            }
            BtreePage btreePage = AltBtree.this.root;
            int n2 = AltBtree.this.height;
            this.pageStack = new BtreePage[n2];
            this.posStack = new int[n2];
            if (this.order == 0) {
                if (this.from == null) {
                    while (--n2 > 0) {
                        this.posStack[this.sp] = 0;
                        this.pageStack[this.sp] = btreePage;
                        btreePage = (BtreePage)btreePage.items.get(0);
                        ++this.sp;
                    }
                    this.posStack[this.sp] = 0;
                    this.pageStack[this.sp] = btreePage;
                    this.end = btreePage.nItems;
                    ++this.sp;
                } else {
                    int n3;
                    int n4;
                    int n5;
                    while (--n2 > 0) {
                        this.pageStack[this.sp] = btreePage;
                        n5 = 0;
                        n4 = btreePage.nItems;
                        while (n5 < n4) {
                            n3 = n5 + n4 >> 1;
                            if (btreePage.compare(this.from, n3) >= this.from.inclusion) {
                                n5 = n3 + 1;
                                continue;
                            }
                            n4 = n3;
                        }
                        Assert.that(n4 == n5);
                        this.posStack[this.sp] = n4;
                        btreePage = (BtreePage)btreePage.items.get(n4);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = btreePage;
                    n5 = 0;
                    n4 = this.end = btreePage.nItems;
                    while (n5 < n4) {
                        n3 = n5 + n4 >> 1;
                        if (btreePage.compare(this.from, n3) >= this.from.inclusion) {
                            n5 = n3 + 1;
                            continue;
                        }
                        n4 = n3;
                    }
                    Assert.that(n4 == n5);
                    if (n4 == this.end) {
                        ++this.sp;
                        this.gotoNextItem(btreePage, n4 - 1);
                    } else {
                        this.posStack[this.sp++] = n4;
                    }
                }
                if (this.sp != 0 && this.till != null && -(btreePage = this.pageStack[this.sp - 1]).compare(this.till, this.posStack[this.sp - 1]) >= this.till.inclusion) {
                    this.sp = 0;
                }
            } else {
                if (this.till == null) {
                    while (--n2 > 0) {
                        this.pageStack[this.sp] = btreePage;
                        this.posStack[this.sp] = btreePage.nItems;
                        btreePage = (BtreePage)btreePage.items.get(btreePage.nItems);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = btreePage;
                    this.posStack[this.sp++] = btreePage.nItems - 1;
                } else {
                    int n6;
                    int n7;
                    int n8;
                    while (--n2 > 0) {
                        this.pageStack[this.sp] = btreePage;
                        n8 = 0;
                        n7 = btreePage.nItems;
                        while (n8 < n7) {
                            n6 = n8 + n7 >> 1;
                            if (btreePage.compare(this.till, n6) >= 1 - this.till.inclusion) {
                                n8 = n6 + 1;
                                continue;
                            }
                            n7 = n6;
                        }
                        Assert.that(n7 == n8);
                        this.posStack[this.sp] = n7;
                        btreePage = (BtreePage)btreePage.items.get(n7);
                        ++this.sp;
                    }
                    this.pageStack[this.sp] = btreePage;
                    n8 = 0;
                    n7 = btreePage.nItems;
                    while (n8 < n7) {
                        n6 = n8 + n7 >> 1;
                        if (btreePage.compare(this.till, n6) >= 1 - this.till.inclusion) {
                            n8 = n6 + 1;
                            continue;
                        }
                        n7 = n6;
                    }
                    Assert.that(n7 == n8);
                    if (n7 == 0) {
                        ++this.sp;
                        this.gotoNextItem(btreePage, n7);
                    } else {
                        this.posStack[this.sp++] = n7 - 1;
                    }
                }
                if (this.sp != 0 && this.from != null && (btreePage = this.pageStack[this.sp - 1]).compare(this.from, this.posStack[this.sp - 1]) >= this.from.inclusion) {
                    this.sp = 0;
                }
            }
        }

        public boolean hasNext() {
            if (this.counter != AltBtree.this.updateCounter) {
                if (((StorageImpl)AltBtree.this.getStorage()).concurrentIterator) {
                    this.refresh();
                } else {
                    throw new ConcurrentModificationException();
                }
            }
            return this.sp != 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.posStack[this.sp - 1];
            BtreePage btreePage = this.pageStack[this.sp - 1];
            this.currPos = n2;
            this.currPage = btreePage;
            Object object = this.getCurrent(btreePage, n2);
            if (((StorageImpl)AltBtree.this.getStorage()).concurrentIterator) {
                this.currKey = new BtreeKey(btreePage.getKey(n2), btreePage.items.getRaw(n2));
            }
            this.gotoNextItem(btreePage, n2);
            return object;
        }

        public int nextOid() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.posStack[this.sp - 1];
            BtreePage btreePage = this.pageStack[this.sp - 1];
            this.currPos = n2;
            this.currPage = btreePage;
            int n3 = btreePage.items.getRaw(n2).getOid();
            if (((StorageImpl)AltBtree.this.getStorage()).concurrentIterator) {
                this.currKey = new BtreeKey(btreePage.getKey(n2), btreePage.items.getRaw(n2));
            }
            this.gotoNextItem(btreePage, n2);
            return n3;
        }

        protected Object getCurrent(BtreePage btreePage, int n2) {
            return btreePage.items.get(n2);
        }

        protected final void gotoNextItem(BtreePage btreePage, int n2) {
            if (this.order == 0) {
                if (++n2 == this.end) {
                    while (--this.sp != 0) {
                        n2 = this.posStack[this.sp - 1];
                        btreePage = this.pageStack[this.sp - 1];
                        if (++n2 > btreePage.nItems) continue;
                        this.posStack[this.sp - 1] = n2;
                        do {
                            btreePage = (BtreePage)btreePage.items.get(n2);
                            this.end = btreePage.nItems;
                            this.pageStack[this.sp] = btreePage;
                            n2 = 0;
                            this.posStack[this.sp] = 0;
                        } while (++this.sp < this.pageStack.length);
                        break;
                    }
                } else {
                    this.posStack[this.sp - 1] = n2;
                }
                if (this.sp != 0 && this.till != null && -btreePage.compare(this.till, n2) >= this.till.inclusion) {
                    this.sp = 0;
                }
            } else {
                if (--n2 < 0) {
                    while (--this.sp != 0) {
                        n2 = this.posStack[this.sp - 1];
                        btreePage = this.pageStack[this.sp - 1];
                        if (--n2 < 0) continue;
                        this.posStack[this.sp - 1] = n2;
                        do {
                            this.pageStack[this.sp] = btreePage = (BtreePage)btreePage.items.get(n2);
                            n2 = btreePage.nItems;
                            this.posStack[this.sp] = n2--;
                        } while (++this.sp < this.pageStack.length);
                        this.posStack[this.sp - 1] = n2;
                        break;
                    }
                } else {
                    this.posStack[this.sp - 1] = n2;
                }
                if (this.sp != 0 && this.from != null && btreePage.compare(this.from, n2) >= this.from.inclusion) {
                    this.sp = 0;
                }
            }
            if (((StorageImpl)AltBtree.this.getStorage()).concurrentIterator && this.sp != 0) {
                this.nextKey = btreePage.getKey(n2);
                this.nextObj = btreePage.items.getRaw(n2);
            }
        }

        private void refresh() {
            if (this.sp != 0) {
                if (this.nextKey == null) {
                    this.reset();
                } else {
                    if (this.order == 0) {
                        this.from = this.nextKey;
                    } else {
                        this.till = this.nextKey;
                    }
                    IPersistent iPersistent = this.nextObj;
                    this.reset();
                    while (true) {
                        int n2 = this.posStack[this.sp - 1];
                        BtreePage btreePage = this.pageStack[this.sp - 1];
                        if (btreePage.items.getRaw(n2).equals(iPersistent)) break;
                        this.gotoNextItem(btreePage, n2);
                    }
                }
            }
            this.counter = AltBtree.this.updateCounter;
        }

        public void remove() {
            if (this.currPage == null) {
                throw new NoSuchElementException();
            }
            StorageImpl storageImpl = (StorageImpl)AltBtree.this.getStorage();
            if (!storageImpl.concurrentIterator) {
                if (this.counter != AltBtree.this.updateCounter) {
                    throw new ConcurrentModificationException();
                }
                this.currKey = new BtreeKey(this.currPage.getKey(this.currPos), this.currPage.items.getRaw(this.currPos));
                if (this.sp != 0) {
                    int n2 = this.posStack[this.sp - 1];
                    BtreePage btreePage = this.pageStack[this.sp - 1];
                    this.nextKey = btreePage.getKey(n2);
                    this.nextObj = btreePage.items.getRaw(n2);
                }
            }
            AltBtree.this.removeIfExists(this.currKey);
            this.refresh();
            this.currPage = null;
        }
    }

    static class BtreeEntry
    implements Map.Entry {
        private BtreePage pg;
        private int pos;

        public Object getKey() {
            return this.pg.getKeyValue(this.pos);
        }

        public Object getValue() {
            return this.pg.items.get(this.pos);
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? this.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        BtreeEntry(BtreePage btreePage, int n2) {
            this.pg = btreePage;
            this.pos = n2;
        }
    }

    static class BtreePageOfRaw
    extends BtreePage {
        Object data;
        static final int MAX_ITEMS = 100;

        Object getData() {
            return this.data;
        }

        Key getKey(int n2) {
            return new Key((Comparable)((Object[])this.data)[n2]);
        }

        Object getKeyValue(int n2) {
            return ((Object[])this.data)[n2];
        }

        void clearKeyValue(int n2) {
            ((Object[])this.data)[n2] = null;
        }

        BtreePage clonePage() {
            return new BtreePageOfRaw(this.getStorage());
        }

        int compare(Key key, int n2) {
            return ((Comparable)key.oval).compareTo(((Object[])this.data)[n2]);
        }

        void insert(BtreeKey btreeKey, int n2) {
            this.items.set(n2, btreeKey.node);
            ((Object[])this.data)[n2] = btreeKey.key.oval;
        }

        BtreePageOfRaw(Storage storage) {
            super(storage, 100);
            this.data = new Object[100];
        }

        BtreePageOfRaw() {
        }
    }

    static class BtreePageOfString
    extends BtreePage {
        String[] data;
        static final int MAX_ITEMS = 100;

        Object getData() {
            return this.data;
        }

        Key getKey(int n2) {
            return new Key(this.data[n2]);
        }

        Object getKeyValue(int n2) {
            return this.data[n2];
        }

        void clearKeyValue(int n2) {
            this.data[n2] = null;
        }

        BtreePage clonePage() {
            return new BtreePageOfString(this.getStorage());
        }

        int compare(Key key, int n2) {
            return ((String)key.oval).compareTo(this.data[n2]);
        }

        void insert(BtreeKey btreeKey, int n2) {
            this.items.set(n2, btreeKey.node);
            this.data[n2] = (String)btreeKey.key.oval;
        }

        void memset(int n2, int n3) {
            while (--n3 >= 0) {
                this.items.set(n2, null);
                this.data[n2] = null;
                ++n2;
            }
        }

        boolean prefixSearch(String string, int n2, ArrayList arrayList) {
            int n3;
            int n4 = 0;
            int n5 = n3 = this.nItems;
            --n2;
            while (n4 < n5) {
                int n6 = n4 + n5 >> 1;
                if (!string.startsWith(this.data[n6]) && string.compareTo(this.data[n6]) > 0) {
                    n4 = n6 + 1;
                    continue;
                }
                n5 = n6;
            }
            Assert.that(n5 == n4);
            if (n2 == 0) {
                while (n4 < n3) {
                    if (string.compareTo(this.data[n4]) < 0) {
                        return false;
                    }
                    arrayList.add(this.items.get(n4));
                    ++n4;
                }
            } else {
                do {
                    if (!((BtreePageOfString)this.items.get(n4)).prefixSearch(string, n2, arrayList)) {
                        return false;
                    }
                    if (n4 != n3) continue;
                    return true;
                } while (string.compareTo(this.data[n4++]) >= 0);
                return false;
            }
            return true;
        }

        BtreePageOfString(Storage storage) {
            super(storage, 100);
            this.data = new String[100];
        }

        BtreePageOfString() {
        }
    }

    static class BtreePageOfObject
    extends BtreePage {
        Link data;
        static final int MAX_ITEMS = 509;

        Object getData() {
            return this.data.toRawArray();
        }

        Key getKey(int n2) {
            return new Key(this.data.getRaw(n2));
        }

        Object getKeyValue(int n2) {
            return this.data.get(n2);
        }

        BtreePage clonePage() {
            return new BtreePageOfObject(this.getStorage());
        }

        int compare(Key key, int n2) {
            return key.ival - this.data.getRaw(n2).getOid();
        }

        void insert(BtreeKey btreeKey, int n2) {
            this.items.set(n2, btreeKey.node);
            this.data.set(n2, (IPersistent)btreeKey.key.oval);
        }

        BtreePageOfObject(Storage storage) {
            super(storage, 509);
            this.data = storage.createLink(509);
            this.data.setSize(509);
        }

        BtreePageOfObject() {
        }
    }

    static class BtreePageOfDouble
    extends BtreePage {
        double[] data;
        static final int MAX_ITEMS = 339;

        Object getData() {
            return this.data;
        }

        Key getKey(int n2) {
            return new Key(this.data[n2]);
        }

        Object getKeyValue(int n2) {
            return new Double(this.data[n2]);
        }

        BtreePage clonePage() {
            return new BtreePageOfDouble(this.getStorage());
        }

        int compare(Key key, int n2) {
            return key.dval < this.data[n2] ? -1 : (key.dval == this.data[n2] ? 0 : 1);
        }

        void insert(BtreeKey btreeKey, int n2) {
            this.items.set(n2, btreeKey.node);
            this.data[n2] = btreeKey.key.dval;
        }

        BtreePageOfDouble(Storage storage) {
            super(storage, 339);
            this.data = new double[339];
        }

        BtreePageOfDouble() {
        }
    }

    static class BtreePageOfFloat
    extends BtreePage {
        float[] data;
        static final int MAX_ITEMS = 509;

        Object getData() {
            return this.data;
        }

        Key getKey(int n2) {
            return new Key(this.data[n2]);
        }

        Object getKeyValue(int n2) {
            return new Float(this.data[n2]);
        }

        BtreePage clonePage() {
            return new BtreePageOfFloat(this.getStorage());
        }

        int compare(Key key, int n2) {
            return (float)key.dval < this.data[n2] ? -1 : ((float)key.dval == this.data[n2] ? 0 : 1);
        }

        void insert(BtreeKey btreeKey, int n2) {
            this.items.set(n2, btreeKey.node);
            this.data[n2] = (float)btreeKey.key.dval;
        }

        BtreePageOfFloat(Storage storage) {
            super(storage, 509);
            this.data = new float[509];
        }

        BtreePageOfFloat() {
        }
    }

    static class BtreePageOfLong
    extends BtreePage {
        long[] data;
        static final int MAX_ITEMS = 339;

        Object getData() {
            return this.data;
        }

        Key getKey(int n2) {
            return new Key(this.data[n2]);
        }

        Object getKeyValue(int n2) {
            return new Long(this.data[n2]);
        }

        BtreePage clonePage() {
            return new BtreePageOfLong(this.getStorage());
        }

        int compare(Key key, int n2) {
            return key.lval < this.data[n2] ? -1 : (key.lval == this.data[n2] ? 0 : 1);
        }

        void insert(BtreeKey btreeKey, int n2) {
            this.items.set(n2, btreeKey.node);
            this.data[n2] = btreeKey.key.lval;
        }

        BtreePageOfLong(Storage storage) {
            super(storage, 339);
            this.data = new long[339];
        }

        BtreePageOfLong() {
        }
    }

    static class BtreePageOfInt
    extends BtreePage {
        int[] data;
        static final int MAX_ITEMS = 509;

        Object getData() {
            return this.data;
        }

        Key getKey(int n2) {
            return new Key(this.data[n2]);
        }

        Object getKeyValue(int n2) {
            return new Integer(this.data[n2]);
        }

        BtreePage clonePage() {
            return new BtreePageOfInt(this.getStorage());
        }

        int compare(Key key, int n2) {
            return key.ival - this.data[n2];
        }

        void insert(BtreeKey btreeKey, int n2) {
            this.items.set(n2, btreeKey.node);
            this.data[n2] = btreeKey.key.ival;
        }

        BtreePageOfInt(Storage storage) {
            super(storage, 509);
            this.data = new int[509];
        }

        BtreePageOfInt() {
        }
    }

    static class BtreePageOfChar
    extends BtreePage {
        char[] data;
        static final int MAX_ITEMS = 679;

        Object getData() {
            return this.data;
        }

        Key getKey(int n2) {
            return new Key(this.data[n2]);
        }

        Object getKeyValue(int n2) {
            return new Character(this.data[n2]);
        }

        BtreePage clonePage() {
            return new BtreePageOfChar(this.getStorage());
        }

        int compare(Key key, int n2) {
            return (char)key.ival - this.data[n2];
        }

        void insert(BtreeKey btreeKey, int n2) {
            this.items.set(n2, btreeKey.node);
            this.data[n2] = (char)btreeKey.key.ival;
        }

        BtreePageOfChar(Storage storage) {
            super(storage, 679);
            this.data = new char[679];
        }

        BtreePageOfChar() {
        }
    }

    static class BtreePageOfShort
    extends BtreePage {
        short[] data;
        static final int MAX_ITEMS = 679;

        Object getData() {
            return this.data;
        }

        Key getKey(int n2) {
            return new Key(this.data[n2]);
        }

        Object getKeyValue(int n2) {
            return new Short(this.data[n2]);
        }

        BtreePage clonePage() {
            return new BtreePageOfShort(this.getStorage());
        }

        int compare(Key key, int n2) {
            return (short)key.ival - this.data[n2];
        }

        void insert(BtreeKey btreeKey, int n2) {
            this.items.set(n2, btreeKey.node);
            this.data[n2] = (short)btreeKey.key.ival;
        }

        BtreePageOfShort(Storage storage) {
            super(storage, 679);
            this.data = new short[679];
        }

        BtreePageOfShort() {
        }
    }

    static class BtreePageOfBoolean
    extends BtreePageOfByte {
        Key getKey(int n2) {
            return new Key(this.data[n2] != 0);
        }

        Object getKeyValue(int n2) {
            return this.data[n2] != 0;
        }

        BtreePage clonePage() {
            return new BtreePageOfBoolean(this.getStorage());
        }

        BtreePageOfBoolean() {
        }

        BtreePageOfBoolean(Storage storage) {
            super(storage);
        }
    }

    static class BtreePageOfByte
    extends BtreePage {
        byte[] data;
        static final int MAX_ITEMS = 815;

        Object getData() {
            return this.data;
        }

        Object getKeyValue(int n2) {
            return new Byte(this.data[n2]);
        }

        Key getKey(int n2) {
            return new Key(this.data[n2]);
        }

        BtreePage clonePage() {
            return new BtreePageOfByte(this.getStorage());
        }

        int compare(Key key, int n2) {
            return (byte)key.ival - this.data[n2];
        }

        void insert(BtreeKey btreeKey, int n2) {
            this.items.set(n2, btreeKey.node);
            this.data[n2] = (byte)btreeKey.key.ival;
        }

        BtreePageOfByte(Storage storage) {
            super(storage, 815);
            this.data = new byte[815];
        }

        BtreePageOfByte() {
        }
    }

    static abstract class BtreePage
    extends Persistent {
        int nItems;
        Link items;
        static final int BTREE_PAGE_SIZE = 4076;

        abstract Object getData();

        abstract Object getKeyValue(int var1);

        abstract Key getKey(int var1);

        abstract int compare(Key var1, int var2);

        abstract void insert(BtreeKey var1, int var2);

        abstract BtreePage clonePage();

        void clearKeyValue(int n2) {
        }

        boolean find(Key key, Key key2, int n2, ArrayList arrayList) {
            int n3;
            int n4 = 0;
            int n5 = n3 = this.nItems;
            --n2;
            if (key != null) {
                while (n4 < n5) {
                    int n6 = n4 + n5 >> 1;
                    if (this.compare(key, n6) >= key.inclusion) {
                        n4 = n6 + 1;
                        continue;
                    }
                    n5 = n6;
                }
                Assert.that(n5 == n4);
            }
            if (key2 != null) {
                if (n2 == 0) {
                    while (n4 < n3) {
                        if (-this.compare(key2, n4) >= key2.inclusion) {
                            return false;
                        }
                        arrayList.add(this.items.get(n4));
                        ++n4;
                    }
                    return true;
                }
                do {
                    if (!((BtreePage)this.items.get(n4)).find(key, key2, n2, arrayList)) {
                        return false;
                    }
                    if (n4 != n3) continue;
                    return true;
                } while (this.compare(key2, n4++) >= 0);
                return false;
            }
            if (n2 == 0) {
                while (n4 < n3) {
                    arrayList.add(this.items.get(n4));
                    ++n4;
                }
            } else {
                do {
                    if (((BtreePage)this.items.get(n4)).find(key, key2, n2, arrayList)) continue;
                    return false;
                } while (++n4 <= n3);
            }
            return true;
        }

        static void memcpyData(BtreePage btreePage, int n2, BtreePage btreePage2, int n3, int n4) {
            System.arraycopy(btreePage2.getData(), n3, btreePage.getData(), n2, n4);
        }

        static void memcpyItems(BtreePage btreePage, int n2, BtreePage btreePage2, int n3, int n4) {
            System.arraycopy(btreePage2.items.toRawArray(), n3, btreePage.items.toRawArray(), n2, n4);
        }

        static void memcpy(BtreePage btreePage, int n2, BtreePage btreePage2, int n3, int n4) {
            BtreePage.memcpyData(btreePage, n2, btreePage2, n3, n4);
            BtreePage.memcpyItems(btreePage, n2, btreePage2, n3, n4);
        }

        void memset(int n2, int n3) {
            while (--n3 >= 0) {
                this.items.set(n2++, null);
            }
        }

        int insert(BtreeKey btreeKey, int n2, boolean bl2, boolean bl3) {
            int n3;
            int n4;
            int n5;
            int n6 = 0;
            int n7 = n5 = this.nItems;
            int n8 = n4 = bl2 ? 1 : 0;
            while (n6 < n7) {
                n3 = n6 + n7 >> 1;
                if (this.compare(btreeKey.key, n3) >= n4) {
                    n6 = n3 + 1;
                    continue;
                }
                n7 = n3;
            }
            Assert.that(n6 == n7);
            if (--n2 != 0) {
                int n9 = ((BtreePage)this.items.get(n7)).insert(btreeKey, n2, bl2, bl3);
                Assert.that(n9 != 3);
                if (n9 != 1) {
                    return n9;
                }
                ++n5;
            } else if (n7 < n5 && this.compare(btreeKey.key, n7) == 0) {
                if (bl3) {
                    btreeKey.oldNode = this.items.get(n7);
                    this.modify();
                    this.items.set(n7, btreeKey.node);
                    return 5;
                }
                if (bl2) {
                    btreeKey.oldNode = this.items.get(n7);
                    return 4;
                }
            }
            n3 = this.items.size();
            this.modify();
            if (n5 < n3) {
                BtreePage.memcpy(this, n7 + 1, this, n7, n5 - n7);
                this.insert(btreeKey, n7);
                ++this.nItems;
                return 0;
            }
            BtreePage btreePage = this.clonePage();
            Assert.that(n5 == n3);
            int n10 = n3 / 2;
            if (n7 < n10) {
                BtreePage.memcpy(btreePage, 0, this, 0, n7);
                BtreePage.memcpy(btreePage, n7 + 1, this, n7, n10 - n7 - 1);
                BtreePage.memcpy(this, 0, this, n10 - 1, n3 - n10 + 1);
                btreePage.insert(btreeKey, n7);
            } else {
                BtreePage.memcpy(btreePage, 0, this, 0, n10);
                BtreePage.memcpy(this, 0, this, n10, n7 - n10);
                BtreePage.memcpy(this, n7 - n10 + 1, this, n7, n3 - n7);
                this.insert(btreeKey, n7 - n10);
            }
            this.memset(n3 - n10 + 1, n10 - 1);
            btreeKey.node = btreePage;
            btreeKey.key = btreePage.getKey(n10 - 1);
            if (n2 == 0) {
                this.nItems = n3 - n10 + 1;
                btreePage.nItems = n10;
            } else {
                btreePage.clearKeyValue(n10 - 1);
                this.nItems = n3 - n10;
                btreePage.nItems = n10 - 1;
            }
            return 1;
        }

        int handlePageUnderflow(int n2, BtreeKey btreeKey, int n3) {
            BtreePage btreePage = (BtreePage)this.items.get(n2);
            btreePage.modify();
            this.modify();
            int n4 = btreePage.nItems;
            if (n2 < this.nItems) {
                BtreePage btreePage2 = (BtreePage)this.items.get(n2 + 1);
                int n5 = btreePage2.nItems;
                Assert.that(n5 >= n4);
                if (n3 != 1) {
                    BtreePage.memcpyData(btreePage, n4, this, n2, 1);
                    ++n4;
                    ++n5;
                }
                if (n4 + n5 > this.items.size()) {
                    int n6 = n5 - (n4 + n5 >> 1);
                    btreePage2.modify();
                    BtreePage.memcpy(btreePage, n4, btreePage2, 0, n6);
                    BtreePage.memcpy(btreePage2, 0, btreePage2, n6, n5 - n6);
                    BtreePage.memcpyData(this, n2, btreePage, n4 + n6 - 1, 1);
                    if (n3 != 1) {
                        btreePage.clearKeyValue(n4 + n6 - 1);
                    }
                    btreePage2.memset(n5 - n6, n6);
                    btreePage2.nItems -= n6;
                    btreePage.nItems += n6;
                    return 0;
                }
                BtreePage.memcpy(btreePage, n4, btreePage2, 0, n5);
                btreePage2.deallocate();
                BtreePage.memcpyData(this, n2, this, n2 + 1, this.nItems - n2 - 1);
                BtreePage.memcpyItems(this, n2 + 1, this, n2 + 2, this.nItems - n2 - 1);
                this.items.set(this.nItems, null);
                btreePage.nItems += n5;
                --this.nItems;
                return this.nItems < this.items.size() >> 1 ? 2 : 0;
            }
            BtreePage btreePage3 = (BtreePage)this.items.get(n2 - 1);
            int n7 = btreePage3.nItems;
            Assert.that(n7 >= n4);
            if (n3 != 1) {
                ++n4;
                ++n7;
            }
            if (n4 + n7 > this.items.size()) {
                int n8 = n7 - (n4 + n7 >> 1);
                btreePage3.modify();
                BtreePage.memcpy(btreePage, n8, btreePage, 0, n4);
                BtreePage.memcpy(btreePage, 0, btreePage3, n7 - n8, n8);
                if (n3 != 1) {
                    BtreePage.memcpyData(btreePage, n8 - 1, this, n2 - 1, 1);
                }
                BtreePage.memcpyData(this, n2 - 1, btreePage3, n7 - n8 - 1, 1);
                if (n3 != 1) {
                    btreePage3.clearKeyValue(n7 - n8 - 1);
                }
                btreePage3.memset(n7 - n8, n8);
                btreePage3.nItems -= n8;
                btreePage.nItems += n8;
                return 0;
            }
            BtreePage.memcpy(btreePage, n7, btreePage, 0, n4);
            BtreePage.memcpy(btreePage, 0, btreePage3, 0, n7);
            if (n3 != 1) {
                BtreePage.memcpyData(btreePage, n7 - 1, this, n2 - 1, 1);
            }
            btreePage3.deallocate();
            this.items.set(n2 - 1, btreePage);
            this.items.set(this.nItems, null);
            btreePage.nItems += n7;
            --this.nItems;
            return this.nItems < this.items.size() >> 1 ? 2 : 0;
        }

        int remove(BtreeKey btreeKey, int n2) {
            int n3 = this.nItems;
            int n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                int n6 = n4 + n5 >> 1;
                if (this.compare(btreeKey.key, n6) > 0) {
                    n4 = n6 + 1;
                    continue;
                }
                n5 = n6;
            }
            if (--n2 == 0) {
                IPersistent iPersistent = btreeKey.node;
                while (n5 < n3 && this.compare(btreeKey.key, n5) == 0) {
                    if (iPersistent == null || this.items.containsElement(n5, iPersistent)) {
                        btreeKey.oldNode = this.items.get(n5);
                        this.modify();
                        BtreePage.memcpy(this, n5, this, n5 + 1, n3 - n5 - 1);
                        this.nItems = --n3;
                        this.memset(n3, 1);
                        return n3 < this.items.size() >> 1 ? 2 : 0;
                    }
                    ++n5;
                }
                return 3;
            }
            do {
                switch (((BtreePage)this.items.get(n5)).remove(btreeKey, n2)) {
                    case 2: {
                        return this.handlePageUnderflow(n5, btreeKey, n2);
                    }
                    case 0: {
                        return 0;
                    }
                }
            } while (++n5 <= n3);
            return 3;
        }

        void purge(int n2) {
            if (--n2 != 0) {
                int n3 = this.nItems;
                do {
                    ((BtreePage)this.items.get(n3)).purge(n2);
                } while (--n3 >= 0);
            }
            super.deallocate();
        }

        int traverseForward(int n2, IPersistent[] iPersistentArray, int n3) {
            int n4 = this.nItems;
            if (--n2 != 0) {
                for (int i2 = 0; i2 <= n4; ++i2) {
                    n3 = ((BtreePage)this.items.get(i2)).traverseForward(n2, iPersistentArray, n3);
                }
            } else {
                for (int i3 = 0; i3 < n4; ++i3) {
                    iPersistentArray[n3++] = this.items.get(i3);
                }
            }
            return n3;
        }

        BtreePage(Storage storage, int n2) {
            super(storage);
            this.items = storage.createLink(n2);
            this.items.setSize(n2);
        }

        BtreePage() {
        }
    }

    static class BtreeKey {
        Key key;
        IPersistent node;
        IPersistent oldNode;

        BtreeKey(Key key, IPersistent iPersistent) {
            this.key = key;
            this.node = iPersistent;
        }
    }
}

