/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import org.garret.perst.IPersistent;
import org.garret.perst.Link;
import org.garret.perst.StorageError;

public class Projection {
    private HashSet set = new HashSet();
    private Field field;

    public Projection(Class clazz, String string) {
        this.setProjectionField(clazz, string);
    }

    public Projection() {
    }

    public void setProjectionField(Class clazz, String string) {
        try {
            this.field = clazz.getDeclaredField(string);
            this.field.setAccessible(true);
        }
        catch (Exception exception) {
            throw new StorageError(5, exception);
        }
    }

    public void project(IPersistent[] iPersistentArray) {
        for (int i2 = 0; i2 < iPersistentArray.length; ++i2) {
            this.map(iPersistentArray[i2]);
        }
    }

    public void project(IPersistent iPersistent) {
        this.map(iPersistent);
    }

    public void project(Iterator iterator) {
        while (iterator.hasNext()) {
            this.map((IPersistent)iterator.next());
        }
    }

    public void join(Projection projection) {
        this.set.retainAll(projection.set);
    }

    public IPersistent[] toArray() {
        return this.set.toArray(new IPersistent[this.set.size()]);
    }

    public IPersistent[] toArray(IPersistent[] iPersistentArray) {
        return this.set.toArray(iPersistentArray);
    }

    public int size() {
        return this.set.size();
    }

    public Iterator iterator() {
        return this.set.iterator();
    }

    public void reset() {
        this.set.clear();
    }

    protected void add(IPersistent iPersistent) {
        if (iPersistent != null) {
            this.set.add(iPersistent);
        }
    }

    protected void map(IPersistent iPersistent) {
        if (this.field == null) {
            this.add(iPersistent);
        } else {
            try {
                Object object = this.field.get(iPersistent);
                if (object instanceof Link) {
                    IPersistent[] iPersistentArray = ((Link)object).toArray();
                    for (int i2 = 0; i2 < iPersistentArray.length; ++i2) {
                        this.add(iPersistentArray[i2]);
                    }
                } else if (object instanceof IPersistent[]) {
                    IPersistent[] iPersistentArray = (IPersistent[])object;
                    for (int i3 = 0; i3 < iPersistentArray.length; ++i3) {
                        this.add(iPersistentArray[i3]);
                    }
                } else {
                    this.add((IPersistent)object);
                }
            }
            catch (Exception exception) {
                throw new StorageError(17, exception);
            }
        }
    }
}

