/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;

public class CompressedFile
implements IFile {
    static final int SEGMENT_LENGTH = 131072;
    ZipFile file;
    ZipEntry[] entries;
    byte[] segment;
    ZipEntry currEntry;

    public void write(long l2, byte[] byArray) {
        throw new UnsupportedOperationException("ZipFile.write");
    }

    public int read(long l2, byte[] byArray) {
        try {
            int n2;
            int n3;
            int n4 = (int)(l2 / 131072L);
            ZipEntry zipEntry = this.entries[n4];
            int n5 = (int)zipEntry.getSize();
            if (zipEntry != this.currEntry) {
                int n6;
                InputStream inputStream = this.file.getInputStream(zipEntry);
                for (n6 = 0; n6 < n5 && (n3 = inputStream.read(this.segment, n6, n5 - n6)) >= 0; n6 += n3) {
                }
                if (n6 != n5) {
                    throw new StorageError(3);
                }
                this.currEntry = zipEntry;
            }
            if ((n2 = (int)(l2 - (long)n4 * 131072L)) < n5) {
                n3 = byArray.length < n5 - n2 ? byArray.length : n5 - n2;
                System.arraycopy(this.segment, n2, byArray, 0, n3);
                return n3;
            }
            return 0;
        }
        catch (IOException iOException) {
            throw new StorageError(3);
        }
    }

    public void sync() {
    }

    public boolean tryLock(boolean bl2) {
        return true;
    }

    public void lock(boolean bl2) {
    }

    public void unlock() {
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            throw new StorageError(3);
        }
    }

    public long length() {
        return (long)(this.entries.length - 1) * 131072L + this.entries[this.entries.length - 1].getSize();
    }

    public CompressedFile(String string) {
        try {
            this.file = new ZipFile(string);
            int n2 = this.file.size();
            this.entries = new ZipEntry[n2];
            Enumeration<? extends ZipEntry> enumeration = this.file.entries();
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                this.entries[n3] = enumeration.nextElement();
                ++n3;
            }
            this.segment = new byte[131072];
            this.currEntry = null;
        }
        catch (IOException iOException) {
            throw new StorageError(3);
        }
    }
}

