/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser.utils;

import com.j_spaces.tools.IRefreshable;
import com.j_spaces.tools.spacebrowser.SpaceBrowser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RefreshPanel
extends JPanel
implements Runnable {
    private FlowLayout buttonsFlowLayout = new FlowLayout();
    private JLabel refreshLabel = new JLabel();
    private JComboBox updateComboBox = new JComboBox();
    private JPanel buttonPanel = new JPanel();
    private int sleepInterval;
    private static final String DIALOG_RUNTIME_LABEL = "dialog.runtime.labels";
    private static final String DIALOG_RUNTIME_EDITBOX = "dialog.runtime.editbox";
    private static final String DIALOG_RUNTIME_TOOLTIP = "dialog.runtime.tooltip";
    private static final String DIALOG_RUNTIME_ICONS = "dialog.runtime.icons";
    private static final String DIALOG_RUNTIME_BUTTON = "dialog.runtime.buttons";
    private JButton stopButton = new JButton();
    private JButton startButton = new JButton();
    private JLabel statusLabel = new JLabel();
    private boolean isStop = true;
    private Thread m_runtimeThread;
    private ImageIcon stopIcon;
    private ImageIcon startIcon;
    private IRefreshable _refreshListener;

    public RefreshPanel(IRefreshable iRefreshable, boolean bl2) {
        this._refreshListener = iRefreshable;
        this.init();
        if (bl2) {
            this.startStatusRuntime();
        }
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 0));
        String[] stringArray = SpaceBrowser.getResources(DIALOG_RUNTIME_LABEL);
        String[] stringArray2 = SpaceBrowser.getResources(DIALOG_RUNTIME_EDITBOX);
        String[] stringArray3 = SpaceBrowser.getResources(DIALOG_RUNTIME_TOOLTIP);
        String[] stringArray4 = SpaceBrowser.getResources(DIALOG_RUNTIME_ICONS);
        String[] stringArray5 = SpaceBrowser.getResources(DIALOG_RUNTIME_BUTTON);
        this.refreshLabel.setText(" " + stringArray[1] + " ");
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            this.updateComboBox.addItem(stringArray2[i2]);
        }
        if (this.updateComboBox.getItemCount() > 0) {
            this.updateComboBox.setSelectedIndex(0);
        }
        this.updateComboBox.setPreferredSize(new Dimension(130, 20));
        this.updateComboBox.setMaximumSize(new Dimension(130, 20));
        this.stopIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray4[0]));
        this.startIcon = new ImageIcon(this.getClass().getResource("/image/browser/" + stringArray4[1]));
        this.statusLabel = new JLabel("Stopped  ", this.stopIcon, 4);
        this.startButton.setText(stringArray5[0]);
        this.stopButton.setText(stringArray5[1]);
        this.buttonPanel.setLayout(this.buttonsFlowLayout);
        this.buttonPanel.add((Component)this.startButton, null);
        this.buttonPanel.add((Component)this.stopButton, null);
        this.add(Box.createHorizontalStrut(1));
        this.add(this.refreshLabel);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.updateComboBox);
        this.add(Box.createHorizontalGlue());
        this.add(this.buttonPanel);
        this.add(Box.createHorizontalGlue());
        this.add(this.statusLabel);
        this.add(Box.createHorizontalStrut(1));
        this.sleepInterval = this.calculateSleepInterval();
        this.updateComboBox.setToolTipText(stringArray3[0]);
        this.updateComboBox.setPreferredSize(new Dimension(130, 20));
        this.updateComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    RefreshPanel.this.sleepInterval = RefreshPanel.this.calculateSleepInterval();
                }
            }
        });
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RefreshPanel.this.startStatusRuntime();
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RefreshPanel.this.stopStatusRuntime();
            }
        });
        this.stopButton.setEnabled(false);
    }

    public void run() {
        int n2 = 0;
        while (!this.isStop) {
            if (n2 >= 100) {
                n2 = 0;
            }
            this._refreshListener.refresh();
            try {
                Thread.sleep(this.sleepInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        this.startButton.setEnabled(true);
        this.statusLabel.setIcon(this.stopIcon);
        this.statusLabel.setText("Stopped  ");
    }

    private void startStatusRuntime() {
        this.isStop = false;
        this.stopButton.setText("Stop");
        this.startButton.setEnabled(false);
        this.statusLabel.setIcon(this.startIcon);
        this.statusLabel.setText("Started  ");
        this._refreshListener.start();
        this.m_runtimeThread = new Thread(this);
        this.m_runtimeThread.start();
        this.stopButton.setEnabled(true);
    }

    public void stopStatusRuntime() {
        this.isStop = true;
        if (!this.isStop) {
            this.statusLabel.setText("Stopping...");
        }
        this.stopButton.setEnabled(false);
        this._refreshListener.stop();
    }

    private int calculateSleepInterval() {
        int n2 = this.updateComboBox.getSelectedIndex();
        switch (n2) {
            case 0: {
                this.sleepInterval = 1000;
                break;
            }
            case 1: {
                this.sleepInterval = 3000;
                break;
            }
            case 2: {
                this.sleepInterval = 5000;
            }
        }
        return this.sleepInterval;
    }

    public boolean isStop() {
        return this.isStop;
    }

    public ImageIcon getStopIcon() {
        return this.stopIcon;
    }

    public ImageIcon getStartIcon() {
        return this.startIcon;
    }

    public void setStartButtonEnabled(boolean bl2) {
        this.startButton.setEnabled(bl2);
    }

    public int getSleepInterval() {
        return this.sleepInterval;
    }
}

