/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.tools.spacebrowser;

import com.j_spaces.obf.ci;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class BrowserLAFMenu
extends JMenu
implements ActionListener {
    private static final String lafMetal = "Metal";
    private static final String lafMac = "Mac";
    private static final String lafMotif = "Motif";
    private static final String lafWindows = "Windows";
    private static final String lafMetalClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String lafMacClassName = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String lafMotifClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String lafWindowsClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public JRadioButtonMenuItem lafMetalMenuItem;
    public JRadioButtonMenuItem lafMacMenuItem;
    public JRadioButtonMenuItem lafMotifMenuItem;
    public JRadioButtonMenuItem lafWindowsMenuItem;
    public Component owner;
    public Vector members;
    public String lafCurrentName = "javax.swing.plaf.metal.MetalLookAndFeel";

    public BrowserLAFMenu() {
        this(null, "Look & Feel", null);
    }

    public BrowserLAFMenu(Component component, String string) {
        this(component, string, null);
    }

    public BrowserLAFMenu(Component component, String string, Vector vector) {
        this.owner = component;
        this.members = vector;
        this.setText(string);
        this.lafMetalMenuItem = new JRadioButtonMenuItem(lafMetal);
        this.lafMetalMenuItem.setMnemonic('M');
        this.lafMetalMenuItem.setActionCommand(lafMetalClassName);
        this.lafMetalMenuItem.setEnabled(this.isAvailableLookAndFeel(lafMetalClassName));
        this.lafMetalMenuItem.setSelected(true);
        this.lafMacMenuItem = new JRadioButtonMenuItem(lafMac);
        this.lafMacMenuItem.setMnemonic('C');
        this.lafMacMenuItem.setActionCommand(lafMacClassName);
        this.lafMacMenuItem.setEnabled(this.isAvailableLookAndFeel(lafMacClassName));
        this.lafMotifMenuItem = new JRadioButtonMenuItem(lafMotif);
        this.lafMotifMenuItem.setMnemonic('O');
        this.lafMotifMenuItem.setActionCommand(lafMotifClassName);
        this.lafMotifMenuItem.setEnabled(this.isAvailableLookAndFeel(lafMotifClassName));
        this.lafWindowsMenuItem = new JRadioButtonMenuItem(lafWindows);
        this.lafWindowsMenuItem.setMnemonic('W');
        this.lafWindowsMenuItem.setActionCommand(lafWindowsClassName);
        this.lafWindowsMenuItem.setEnabled(this.isAvailableLookAndFeel(lafWindowsClassName));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.lafMetalMenuItem);
        buttonGroup.add(this.lafMacMenuItem);
        buttonGroup.add(this.lafMotifMenuItem);
        buttonGroup.add(this.lafWindowsMenuItem);
        this.add(this.lafMetalMenuItem);
        this.add(this.lafMacMenuItem);
        this.add(this.lafMotifMenuItem);
        this.add(this.lafWindowsMenuItem);
        this.lafMetalMenuItem.addActionListener(this);
        this.lafMacMenuItem.addActionListener(this);
        this.lafMotifMenuItem.addActionListener(this);
        this.lafWindowsMenuItem.addActionListener(this);
    }

    public boolean isAvailableLookAndFeel(String string) {
        try {
            Class clazz = ci.a(string);
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            return lookAndFeel.isSupportedLookAndFeel();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(this.lafCurrentName)) {
            return;
        }
        this.lafCurrentName = actionEvent.getActionCommand();
        try {
            UIManager.setLookAndFeel(this.lafCurrentName);
            if (this.owner != null) {
                SwingUtilities.updateComponentTreeUI(this.owner);
            }
            if (this.members != null) {
                for (int i2 = 0; i2 < this.members.size(); ++i2) {
                    Component component = (Component)this.members.elementAt(i2);
                    if (component == null) continue;
                    SwingUtilities.updateComponentTreeUI(component);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Failed loading LoolAndFeel: " + this.lafCurrentName);
            exception.printStackTrace();
        }
    }
}

