/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jmx.util;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class HtmlAdaptorFactory {
    public static final String PORT_KEY = "port";
    public static final String MAX_ACTIVE_CLIENT_COUNT_KEY = "maxActiveClientCount";
    private static Logger a = Logger.getLogger("com.gigaspaces.admin");

    private HtmlAdaptorFactory() {
    }

    public static HtmlAdaptorServer startHtmlAdaptor(MBeanServer mBeanServer, Properties properties) {
        HtmlAdaptorServer htmlAdaptorServer;
        block14: {
            htmlAdaptorServer = null;
            try {
                String string;
                boolean bl2;
                ObjectName objectName;
                block13: {
                    htmlAdaptorServer = new HtmlAdaptorServer();
                    objectName = new ObjectName(properties.getProperty("setup.jmx.adaptor.html.objectname", "Adaptor:type=HTML,port=8082"));
                    bl2 = Boolean.valueOf(properties.getProperty("setup.jmx.adaptor.html.authentication.enabled", "false"));
                    string = objectName.getKeyProperty(PORT_KEY);
                    try {
                        if (string != null && string.trim().length() > 0) {
                            htmlAdaptorServer.setPort(Integer.parseInt(string));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (a.isLoggable(Level.WARNING)) {
                            a.log(Level.WARNING, "Invalid port value for JMX HTML Adapter, must be integer.", numberFormatException);
                        }
                        string = "8082";
                    }
                    String string2 = objectName.getKeyProperty(MAX_ACTIVE_CLIENT_COUNT_KEY);
                    try {
                        if (string2 != null && string2.trim().length() > 0) {
                            htmlAdaptorServer.setMaxActiveClientCount(Integer.parseInt(string2));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!a.isLoggable(Level.WARNING)) break block13;
                        a.log(Level.WARNING, "Invalid maxActiveClientCount value for JMX HTML Adapter, must be integer.", numberFormatException);
                    }
                }
                if (bl2) {
                    String string3 = properties.getProperty("setup.jmx.adaptor.html.authentication.username");
                    String string4 = properties.getProperty("setup.jmx.adaptor.html.authentication.password");
                    if (string3 != null && string3.trim().length() > 0 && string4 != null && string4.trim().length() > 0) {
                        htmlAdaptorServer.addUserAuthenticationInfo(new AuthInfo(string3, string4));
                    } else {
                        throw new MBeanRegistrationException(new Exception("Check validity of authentication information."));
                    }
                }
                mBeanServer.registerMBean(htmlAdaptorServer, objectName);
                htmlAdaptorServer.start();
                if (a.isLoggable(Level.INFO)) {
                    a.info("HtmlAdaptorServer started on port: " + string);
                }
            }
            catch (Exception exception) {
                if (!a.isLoggable(Level.WARNING)) break block14;
                a.log(Level.WARNING, exception.toString(), exception);
            }
        }
        return htmlAdaptorServer;
    }
}

