/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.jms.GSQueueImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.GSTopicImpl;
import com.j_spaces.jms.MessagePool;
import com.j_spaces.jms.utils.ByteArray;
import com.j_spaces.jms.utils.ConversionHelper;
import com.j_spaces.jms.utils.StringsUtils;
import com.j_spaces.kernel.time.SystemTime;
import com.j_spaces.obf.ga;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import net.sf.retrotranslator.runtime.java.lang._Byte;
import net.sf.retrotranslator.runtime.java.lang._Double;
import net.sf.retrotranslator.runtime.java.lang._Float;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.runtime.java.lang._Long;
import net.sf.retrotranslator.runtime.java.lang._Short;

public class GSMessageImpl
implements Message,
Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    public static final String HASHMAP_CLASS_NAME;
    public static final String STRING_CLASS_NAME;
    public static final String INTEGER_CLASS_NAME;
    public static final String LONG_CLASS_NAME;
    public static final String DESTINATION_CLASS_NAME;
    public static final String BOOLEAN_CLASS_NAME;
    public static final String OBJECT_CLASS_NAME;
    public static final String BODY_STR_NAME = "message_body";
    public static final String PROPERTIES_STR_NAME = "message_client_properties";
    public static final int reservedNumOfValues = 17;
    public int m_totalNumOfValues = 17;
    public ExternalEntry m_externalEntry = null;
    private static final Logger _logger;
    public static final String[] m_ExtEntryFieldsNames;
    public static final String[] m_ExtEntryFieldsTypes;
    public transient Object[] m_ExtEntryValues = new Object[17];
    private Destination m_to;
    public String m_type = "Simple";
    public static final String CONTROL_MESSAGE = "ControlMessage";
    public static final String SIMPLE = "Simple";
    public static final String TEXT = "Text";
    public static final String OBJECT = "Object";
    public static final String MAP = "Map";
    public static final String STREAM = "Stream";
    public static final String BYTES = "Bytes";
    public static final String JMS_DELIVERY_MODE = "JMSDeliveryMode";
    public static final String JMS_DESTINATION = "JMSDestination";
    public static final String JMS_PRIORITY = "JMSPriority";
    public static final String JMS_MESSAGE_ID = "JMSMessageID";
    public static final String JMS_TIMESTAMP = "JMSTimestamp";
    public static final String JMS_TYPE = "JMSType";
    public static final String JMS_CORRELATION_ID = "JMSCorrelationID";
    public static final String JMS_EXPIRATION = "JMSExpiration";
    public static final String JMS_REPLY_TO = "JMSReplyTo";
    public static final String JMS_REDELIVERED = "JMSRedelivered";
    public static final String JMS_GSPRODUCER_KEY_PROP_NAME = "JMS_GSProducerKey";
    public static final String JMS_GSTTL_KEY_PROP_NAME = "JMS_GSTTLKey";
    public static final String JMSX_GROUPID = "JMSXGroupID";
    public static final String JMSX_GROUPSEQ = "JMSXGroupSeq";
    public static final String JMSX_USERID = "JMSXUserID";
    public static final String JMSX_APPID = "JMSXAppID";
    public static final String JMSX_RCV_TIMESTEMP = "JMSXRcvTimestamp";
    public static final int BODY_NUM = 0;
    public static final int JMS_DESTINATION_NUM = 1;
    public static final int JMS_DELIVERY_MODE_NUM = 2;
    public static final int JMS_EXPIRATION_NUM = 3;
    public static final int JMS_PRIORITY_NUM = 4;
    public static final int JMS_MESSAGE_ID_NUM = 5;
    public static final int JMS_TIMESTAMP_NUM = 6;
    public static final int JMS_CORRELATION_ID_NUM = 7;
    public static final int JMS_REPLY_TO_NUM = 8;
    public static final int JMS_TYPE_NUM = 9;
    public static final int JMS_REDELIVERED_NUM = 10;
    public static final int JMS_GSPRODUCER_KEY_PROP_NUM = 11;
    public static final int JMS_GSTTL_PROP_NUM = 12;
    public static final int JMSX_GROUPID_PROP_NUM = 13;
    public static final int JMSX_GROUPSEQ_PROP_NUM = 14;
    public static final int JMSX_USERID_PROP_NUM = 15;
    public static final int PROPERTIES_NUM = 16;
    public volatile transient String m_id = null;
    public int m_priority = 4;
    public long m_expiration = 0L;
    public long m_timestamp;
    public long m_timeToLive = 0L;
    public int m_deliveryMode = 2;
    public String m_destinationId = null;
    public volatile boolean m_toQueue;
    public String m_correlationIdStr = null;
    public byte[] m_correlationIdbytes = null;
    public boolean m_isCorrelationIDStr = true;
    public String m_replyToId = null;
    public volatile boolean m_replyToQueue;
    public Destination m_replyTo = null;
    private HashMap m_optionalHeader = null;
    private HashMap m_properties = null;
    public ByteArray m_body_bytes = null;
    public Serializable m_body_object = null;
    public HashMap m_body_map = null;
    public String m_body_text = null;
    public boolean m_bodyRO = false;
    public boolean m_propertiesRO = false;
    public volatile boolean m_deletedDest = false;
    public volatile boolean m_expired = false;
    public volatile boolean m_notWriteable = false;
    public volatile boolean m_undeliverable = false;
    public volatile boolean m_denied = false;
    public GSSessionImpl m_sess = null;
    private static final transient String prefix = "ID:";
    public static final byte _EOF = 2;
    public static final byte _BYTES = 3;
    public static final byte _STRING = 4;
    public static final byte _BOOLEAN = 5;
    public static final byte _CHAR = 6;
    public static final byte _BYTE = 7;
    public static final byte _SHORT = 8;
    public static final byte _INT = 9;
    public static final byte _LONG = 10;
    public static final byte _FLOAT = 11;
    public static final byte _DOUBLE = 12;
    public static final byte _NULL = 13;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$jms$Destination;

    public GSMessageImpl(GSSessionImpl gSSessionImpl, String string) throws JMSException {
        this.m_sess = gSSessionImpl;
        this.m_type = string;
        if (this.m_optionalHeader == null) {
            this.m_optionalHeader = new HashMap(20);
        }
        this.m_optionalHeader.put(JMS_TYPE, string);
        if (this.m_properties == null) {
            this.m_properties = new HashMap(20);
        }
    }

    public String getJMSMessageID() throws JMSException {
        return this.getOptionalHeader(JMS_MESSAGE_ID).toString();
    }

    public void setJMSMessageID(String string) throws JMSException {
        this.m_id = string;
        if (!string.startsWith(prefix)) {
            this.m_id = prefix + string;
        }
        this.setOptionalHeader(JMS_MESSAGE_ID, this.m_id);
    }

    public ExternalEntry getExternalEntry() {
        return this.m_externalEntry;
    }

    public long getJMSTimestamp() throws JMSException {
        Object object = this.getOptionalHeader(JMS_TIMESTAMP);
        if (object != null) {
            return ConversionHelper.getLong(object);
        }
        return -1L;
    }

    public void setJMSTimestamp(long l2) throws JMSException {
        this.m_timestamp = l2;
        this.setOptionalHeader(JMS_TIMESTAMP, _Long.valueOf(l2));
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.m_correlationIdbytes;
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        this.m_isCorrelationIDStr = false;
        this.m_correlationIdbytes = (byte[])byArray.clone();
        this.m_correlationIdStr = null;
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        this.m_isCorrelationIDStr = true;
        this.m_correlationIdbytes = null;
        this.m_correlationIdStr = string;
    }

    public String getJMSCorrelationID() throws JMSException {
        if (!this.m_isCorrelationIDStr) {
            throw new JMSException("JMSCorrelationID is an array");
        }
        return this.m_correlationIdStr;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.m_replyTo;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        this.m_replyTo = destination;
        if (destination instanceof GSTopicImpl) {
            this.m_replyToId = ((GSTopicImpl)destination).getTopicName();
            this.m_replyToQueue = false;
        } else if (destination instanceof GSQueueImpl) {
            this.m_replyToId = ((GSQueueImpl)destination).getQueueName();
            this.m_replyToQueue = true;
        }
    }

    public Destination getJMSDestination() throws JMSException {
        return (Destination)this.getOptionalHeader(JMS_DESTINATION);
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.m_to = destination;
        this.setOptionalHeader(JMS_DESTINATION, destination);
    }

    public int getJMSDeliveryMode() throws JMSException {
        Object object = this.getOptionalHeader(JMS_DELIVERY_MODE);
        try {
            if (object != null) {
                this.m_deliveryMode = ConversionHelper.getInt(object);
            }
        }
        catch (MessageFormatException messageFormatException) {
            JMSException jMSException = new JMSException("Exception in getJMSDeliveryMode(): Message Value conversion exception." + messageFormatException.getMessage());
            jMSException.setLinkedException(messageFormatException);
            throw jMSException;
        }
        return this.m_deliveryMode;
    }

    public void setJMSDeliveryMode(int n2) throws JMSException {
        if (n2 != 1 && n2 != 2) {
            throw new JMSException("Delivery Mode of " + n2 + " is not valid" + " (should be " + 1 + " integer for a Non-Persistent delivery, or " + 2 + " integer for a Persistent delivery).");
        }
        this.setOptionalHeader(JMS_DELIVERY_MODE, MessagePool.constIntValues[n2]);
        this.m_deliveryMode = n2;
    }

    public boolean getJMSRedelivered() throws JMSException {
        Object object = this.getOptionalHeader(JMS_REDELIVERED);
        if (object != null) {
            this.m_denied = ConversionHelper.getBoolean(object);
        }
        return this.m_denied;
    }

    public void setJMSRedelivered(boolean bl2) throws JMSException {
        this.m_denied = bl2;
        if (bl2) {
            this.setOptionalHeader(JMS_REDELIVERED, MessagePool.constBoolValues[1]);
        } else {
            this.setOptionalHeader(JMS_REDELIVERED, MessagePool.constBoolValues[0]);
        }
    }

    public String getJMSType() throws JMSException {
        Object object = this.getOptionalHeader(JMS_TYPE);
        if (object != null) {
            this.m_type = object.toString();
        }
        return this.m_type;
    }

    public void setJMSType(String string) throws JMSException {
        this.setOptionalHeader(JMS_TYPE, string);
        this.m_type = string;
    }

    public long getJMSExpiration() throws JMSException {
        Object object = this.getOptionalHeader(JMS_EXPIRATION);
        try {
            if (object != null) {
                this.m_expiration = ConversionHelper.getLong(object);
            }
        }
        catch (MessageFormatException messageFormatException) {
            JMSException jMSException = new JMSException("Exception in getJMSExpiration(): Message Value conversion exception.");
            jMSException.setLinkedException(messageFormatException);
            throw jMSException;
        }
        return this.m_expiration;
    }

    public void setJMSExpiration(long l2) throws JMSException {
        if (l2 < 0L) {
            throw new JMSException(l2 + " is an invalid JMSExpiration value");
        }
        this.m_expiration = this.m_timeToLive == 0L ? 0L : l2;
        this.setOptionalHeader(JMS_EXPIRATION, _Long.valueOf(this.m_expiration));
    }

    public int getJMSPriority() throws JMSException {
        Object object = this.getOptionalHeader(JMS_PRIORITY);
        try {
            if (object != null) {
                this.m_priority = ConversionHelper.getInt(object);
            }
        }
        catch (MessageFormatException messageFormatException) {
            JMSException jMSException = new JMSException("Exception in getJMSPriority(): Message Value conversion exception.");
            jMSException.setLinkedException(messageFormatException);
            throw jMSException;
        }
        return this.m_priority;
    }

    public void setJMSPriority(int n2) throws JMSException {
        if (0 > n2 || n2 > 9) {
            throw new JMSException("Priority of " + n2 + " is not valid" + " (should be an integer between 0 and 9).");
        }
        this.setOptionalHeader(JMS_PRIORITY, MessagePool.constIntValues[n2]);
        this.m_priority = n2;
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        return ConversionHelper.getBoolean(this.m_properties.get(string));
    }

    public byte getByteProperty(String string) throws JMSException {
        return ConversionHelper.getByte(this.m_properties.get(string));
    }

    public short getShortProperty(String string) throws JMSException {
        return ConversionHelper.getShort(this.m_properties.get(string));
    }

    public int getIntProperty(String string) throws JMSException {
        return ConversionHelper.getInt(this.m_properties.get(string));
    }

    public long getLongProperty(String string) throws JMSException {
        return ConversionHelper.getLong(this.m_properties.get(string));
    }

    public float getFloatProperty(String string) throws JMSException {
        return ConversionHelper.getFloat(this.m_properties.get(string));
    }

    public double getDoubleProperty(String string) throws JMSException {
        return ConversionHelper.getDouble(this.m_properties.get(string));
    }

    public String getStringProperty(String string) throws JMSException {
        return ConversionHelper.getString(this.m_properties.get(string));
    }

    public Object getObjectProperty(String string) throws JMSException {
        return this.m_properties.get(string);
    }

    public Object getObjProp(String string) {
        if (this.m_properties == null) {
            return null;
        }
        return this.m_properties.get(string);
    }

    public void setBooleanProperty(String string, boolean bl2) throws JMSException {
        Boolean bl3 = bl2 ? MessagePool.constBoolValues[1] : MessagePool.constBoolValues[0];
        this.checkProperty(string, bl3);
        this.m_properties.put(string, bl3);
    }

    public void setByteProperty(String string, byte by2) throws JMSException {
        Byte by3 = _Byte.valueOf(by2);
        this.checkProperty(string, by3);
        this.m_properties.put(string, by3);
    }

    public void setShortProperty(String string, short s2) throws JMSException {
        Short s3 = _Short.valueOf(s2);
        this.checkProperty(string, s3);
        this.m_properties.put(string, s3);
    }

    public void setIntProperty(String string, int n2) throws JMSException {
        Integer n3 = _Integer.valueOf(n2);
        this.checkProperty(string, n3);
        this.m_properties.put(string, n3);
    }

    public void setLongProperty(String string, long l2) throws JMSException {
        Long l3 = _Long.valueOf(l2);
        this.checkProperty(string, l3);
        this.m_properties.put(string, l3);
    }

    public void setFloatProperty(String string, float f2) throws JMSException {
        Float f3 = _Float.valueOf(f2);
        this.checkProperty(string, f3);
        this.m_properties.put(string, f3);
    }

    public void setDoubleProperty(String string, double d2) throws JMSException {
        Double d3 = _Double.valueOf(d2);
        this.checkProperty(string, d3);
        this.m_properties.put(string, d3);
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        this.checkProperty(string, string2);
        this.m_properties.put(string, string2);
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        this.checkProperty(string, object);
        if (!(object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String || object == null)) {
            throw new MessageFormatException("Invalid object type: Message.setObjectProperty() does not support objects of type " + object.getClass().getName());
        }
        this.m_properties.put(string, object);
    }

    public Object getOptionalHeader(String string) {
        return this.m_optionalHeader.get(string);
    }

    public void acknowledge() throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSMessageImpl.acknowledge()");
        }
        if (this.m_sess.isClosed()) {
            throw new IllegalStateException("Forbidden call on a closed session.");
        }
        if (this.m_sess == null || this.m_sess.getTransacted() || this.m_sess.getAcknowledgeMode() != 2) {
            return;
        }
        this.m_sess.acknowledge();
    }

    public void clearBody() throws JMSException {
        this.m_body_bytes = null;
        this.m_body_object = null;
        this.m_body_map = null;
        this.m_body_text = null;
        this.m_bodyRO = false;
    }

    public boolean isValid() {
        if (this.m_expiration == 0L) {
            return true;
        }
        return this.m_expiration - SystemTime.timeMillis() > 0L;
    }

    public boolean propertyExists(String string) {
        if (this.m_properties == null) {
            return false;
        }
        return this.m_properties.containsKey(string);
    }

    public Enumeration getPropertyNames() {
        if (this.m_properties == null) {
            this.m_properties = new HashMap();
        }
        return Collections.enumeration(this.m_properties.keySet());
    }

    public void clearProperties() {
        this.m_propertiesRO = false;
        if (this.m_properties == null) {
            return;
        }
        this.m_properties.clear();
    }

    public void setOptionalHeader(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("The name of a header must not be null.");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("The name of a header must not be an empty String.");
        }
        if (object == null) {
            return;
        }
        this.m_optionalHeader.put(string, object);
    }

    private void verifyPropertyName(String string) throws JMSException, MessageNotWriteableException {
        if (this.m_propertiesRO) {
            throw new MessageNotWriteableException("Can't set property as the message properties are READ-ONLY.");
        }
        if (string == null) {
            throw new JMSException("The name of a property must not be null.");
        }
        if (string.equals("")) {
            throw new JMSException("The name of a property must not be an empty String.");
        }
    }

    private void checkProperty(String string, Object object) throws JMSException, MessageNotWriteableException {
        int n2;
        this.verifyPropertyName(string);
        char[] cArray = string.toCharArray();
        if (cArray.length == 0) {
            throw new JMSException("zero-length name is not a valid property name");
        }
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            throw new JMSException("Property name " + string + " is not a valid " + "property name");
        }
        for (n2 = 1; n2 < cArray.length; ++n2) {
            if (Character.isJavaIdentifierPart(cArray[n2])) continue;
            throw new JMSException("Property name" + string + " is not a valid " + "property name");
        }
        if (string.startsWith("JMSX")) {
            n2 = 0;
            for (int i2 = 0; i2 < GSSessionImpl.JMSX_CLIENT_NAMES.length; ++i2) {
                Object[] objectArray = GSSessionImpl.JMSX_CLIENT_NAMES[i2];
                if (!objectArray[0].equals(string)) continue;
                if (object == null) {
                    throw new MessageFormatException("Property=" + string + " may not be null");
                }
                Class clazz = (Class)objectArray[1];
                if (!clazz.equals(object.getClass())) {
                    throw new MessageFormatException("Expected type " + clazz.getName() + " for property" + string + ", but got type " + object.getClass().getName());
                }
                if (string.equals(JMSX_GROUPSEQ) && (Integer)object <= 0) {
                    throw new JMSException("JMSXGroupSeq must have a value > 0");
                }
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                throw new JMSException("The property name '" + string + "' is not a valid java identifier." + "Property names with prefix 'JMSX' are" + " reserved for provider usage and cannot be set by clients.");
            }
        }
        if (string.startsWith("JMSX")) {
            if (string.equals(JMSX_GROUPID)) {
                if (!ga.b(object.getClass()).equalsIgnoreCase("int")) {
                    // empty if block
                }
                return;
            }
            if (string.equals(JMSX_GROUPSEQ)) {
                return;
            }
            throw new JMSException("The property name '" + string + "' is not a valid java identifier." + "Property names with prefix 'JMSX' are" + " reserved for provider usage.");
        }
        if (string.startsWith("JMS_GS")) {
            if (string.equals(JMS_GSPRODUCER_KEY_PROP_NAME)) {
                return;
            }
            throw new JMSException("The property name '" + string + "' is not a valid java identifier." + "Property names with prefix 'JMS_GS' are" + "reserved for JMS Message usage and cannot be set by clients.");
        }
        if (string.startsWith("JMS")) {
            throw new JMSException("The property name '" + string + "' is not a valid java identifier." + "Property names with prefix 'JMS' are" + " reserved for JMS Message usage and cannot be set by clients.");
        }
        if (!StringsUtils.isValidJavaIdentifier(string)) {
            throw new JMSException("The property name '" + string + "' is not a valid java identifier.");
        }
        if (GSSessionImpl.reservedSelectorIdentifiers.contains(string.toUpperCase())) {
            throw new JMSException("The property name '" + string + "' is reserved due to message selector syntax.");
        }
    }

    public final void convertBodyToBytes() throws IOException {
        if (this.m_body_bytes == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.writeBody(dataOutputStream);
            dataOutputStream.flush();
            this.m_body_bytes = new ByteArray(byteArrayOutputStream.toByteArray());
            dataOutputStream.close();
        }
    }

    public final void buildBodyFromBytes() throws IOException {
        if (this.m_body_bytes != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.m_body_bytes.getBuf(), this.m_body_bytes.getOffset(), this.m_body_bytes.getLength());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.readBody(dataInputStream);
            dataInputStream.close();
        }
    }

    public void setMapBody(HashMap hashMap) throws MessageNotWriteableException {
        this.checkWrite();
        this.m_body_map = hashMap;
    }

    public void setTextBody(String string) throws MessageNotWriteableException {
        this.checkWrite();
        this.m_body_text = string;
    }

    public void setStreamBody(ByteArray byteArray) throws MessageNotWriteableException {
        this.checkWrite();
        this.m_body_bytes = byteArray;
    }

    public void setBodyAsBytes(ByteArray byteArray) throws MessageNotWriteableException {
        this.checkWrite();
        this.m_body_bytes = byteArray;
    }

    public void setBodyAsBytes(byte[] byArray, int n2, int n3) {
        this.m_body_bytes = new ByteArray(byArray);
    }

    public HashMap getMapBody() {
        return this.m_body_map;
    }

    public String getTextBody() {
        return this.m_body_text;
    }

    public ByteArray getStreamBody() {
        return this.m_body_bytes;
    }

    public ByteArray getBodyAsBytes() throws IOException {
        if (this.m_body_bytes == null) {
            this.convertBodyToBytes();
        }
        return this.m_body_bytes;
    }

    public HashMap getOptionalHeaders() {
        return this.m_optionalHeader;
    }

    public HashMap getProperties() {
        return this.m_properties;
    }

    public String toString() {
        String string;
        block2: {
            string = null;
            try {
                string = "\n\n GSMessageImpl:    { \n   \t jmsDestination  : " + this.getJMSDestination() + "\n" + "   \t jmsDeliveryMode : " + this.m_optionalHeader.get(JMS_DELIVERY_MODE) + "\n" + "   \t TimeToLive   : " + this.m_timeToLive + "\n" + "   \t jmsExpiration   : " + this.m_optionalHeader.get(JMS_EXPIRATION) + "\n" + "   \t jmsPriority     : " + this.m_optionalHeader.get(JMS_PRIORITY) + "\n" + "   \t jmsMessageID    : " + this.m_optionalHeader.get(JMS_MESSAGE_ID) + "\n" + "   \t jmsTimeStamp    : " + this.getJMSTimestamp() + "\n" + "   \t jmsCorrelationIDBytes: " + this.m_correlationIdbytes + "\n" + "   \t jmsCorrelationIDStr: " + this.m_correlationIdStr + "\n" + "   \t jmsReplyTo      : " + this.getJMSReplyTo() + "\n" + "   \t jmsType         : " + this.m_type + "\n" + "   \t jmsProperties:  \n\t : " + this.getProperties() + "\n" + "   \t propertiesRO: \t" + this.m_propertiesRO + "\n" + "   \t bodyRO: " + this.m_bodyRO + "\n" + "\t\t }";
            }
            catch (JMSException jMSException) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, "Exception INSIDE: GSMessageImpl.toString() " + jMSException.toString(), jMSException);
            }
        }
        return string;
    }

    public boolean isBodyRO() {
        return this.m_bodyRO;
    }

    public final void checkWrite() throws MessageNotWriteableException {
        if (this.m_bodyRO) {
            throw new MessageNotWriteableException("Can't write a value as the message body is read-only.");
        }
    }

    public final void checkRead() throws MessageNotReadableException {
        if (!this.m_bodyRO) {
            throw new MessageNotReadableException("Can't read a value as the message body is write-only.");
        }
    }

    public void setBodyRO(boolean bl2) {
        this.m_bodyRO = bl2;
    }

    public boolean isPropertiesRO() {
        return this.m_propertiesRO;
    }

    public void setPropertiesRO(boolean bl2) {
        this.m_propertiesRO = bl2;
    }

    public void setMessageToBeSent(boolean bl2) {
        this.setPropertiesRO(!bl2);
    }

    public void prepare() throws Exception {
        this.m_denied = false;
        this.m_deletedDest = false;
        this.m_expired = false;
        this.m_notWriteable = false;
        this.m_undeliverable = false;
    }

    public int compareTo(Object object) {
        Long l2 = (Long)this.m_properties.get(JMSX_RCV_TIMESTEMP);
        Long l3 = (Long)((GSMessageImpl)object).getProperties().get(JMSX_RCV_TIMESTEMP);
        return l2.compareTo(l3);
    }

    public Destination getToDestination() {
        return this.m_to;
    }

    public void setToDestination(Destination destination) {
        this.m_to = destination;
    }

    public void writeBody(DataOutput dataOutput) throws IOException {
    }

    public void readBody(DataInput dataInput) throws IOException {
    }

    static {
        Class<?> clazz = class$java$util$HashMap;
        if (clazz == null) {
            clazz = class$java$util$HashMap = new HashMap[0].getClass().getComponentType();
        }
        HASHMAP_CLASS_NAME = clazz.getName();
        Class<?> clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        STRING_CLASS_NAME = clazz2.getName();
        Class<?> clazz3 = class$java$lang$Integer;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        INTEGER_CLASS_NAME = clazz3.getName();
        Class<?> clazz4 = class$java$lang$Long;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        LONG_CLASS_NAME = clazz4.getName();
        Class<?> clazz5 = class$javax$jms$Destination;
        if (clazz5 == null) {
            clazz5 = class$javax$jms$Destination = new Destination[0].getClass().getComponentType();
        }
        DESTINATION_CLASS_NAME = clazz5.getName();
        Class<?> clazz6 = class$java$lang$Boolean;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
        }
        BOOLEAN_CLASS_NAME = clazz6.getName();
        Class<?> clazz7 = class$java$lang$Object;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        OBJECT_CLASS_NAME = clazz7.getName();
        _logger = Logger.getLogger("com.gigaspaces.jms");
        m_ExtEntryFieldsNames = new String[]{BODY_STR_NAME, JMS_DESTINATION, JMS_DELIVERY_MODE, JMS_EXPIRATION, JMS_PRIORITY, JMS_MESSAGE_ID, JMS_TIMESTAMP, JMS_CORRELATION_ID, JMS_REPLY_TO, JMS_TYPE, JMS_REDELIVERED, JMS_GSPRODUCER_KEY_PROP_NAME, JMS_GSTTL_KEY_PROP_NAME, JMSX_GROUPID, JMSX_GROUPSEQ, JMSX_USERID, PROPERTIES_STR_NAME};
        m_ExtEntryFieldsTypes = new String[]{OBJECT_CLASS_NAME, DESTINATION_CLASS_NAME, INTEGER_CLASS_NAME, LONG_CLASS_NAME, INTEGER_CLASS_NAME, STRING_CLASS_NAME, LONG_CLASS_NAME, OBJECT_CLASS_NAME, DESTINATION_CLASS_NAME, STRING_CLASS_NAME, BOOLEAN_CLASS_NAME, STRING_CLASS_NAME, LONG_CLASS_NAME, STRING_CLASS_NAME, INTEGER_CLASS_NAME, STRING_CLASS_NAME, HASHMAP_CLASS_NAME};
    }
}

