/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.utils.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class GSBytesMessageImpl
extends GSMessageImpl
implements BytesMessage {
    private ByteArrayOutputStream bytesOut;
    private DataOutputStream dataOut;
    private DataInputStream dataIn;
    private transient long bodyLength = 0L;
    private boolean prepared;
    private int offset = 0;

    public GSBytesMessageImpl(GSSessionImpl gSSessionImpl, byte[] byArray) throws JMSException {
        super(gSSessionImpl, "Bytes");
        if (byArray != null) {
            this.setBodyAsBytes(new ByteArray(byArray));
        }
    }

    public GSBytesMessageImpl(GSSessionImpl gSSessionImpl) throws JMSException {
        this(gSSessionImpl, (byte[])null);
    }

    public void setBodyAsBytes(byte[] byArray, int n2, int n3) {
        super.setBodyAsBytes(byArray, n2, n3);
        this.dataOut = null;
        this.dataIn = null;
    }

    public ByteArray getBodyAsBytes() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.flush();
            byte[] byArray = this.bytesOut.toByteArray();
            super.setBodyAsBytes(byArray, 0, byArray.length);
            this.dataOut.close();
            this.dataOut = null;
        }
        return super.getBodyAsBytes();
    }

    public long getBodyLength() throws JMSException {
        this.initializeReading();
        return this.bodyLength;
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readBoolean();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readByte();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readShort();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readChar();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readInt();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readLong();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readFloat();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readDouble();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public String readUTF() throws JMSException {
        this.initializeReading();
        try {
            return this.dataIn.readUTF();
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public int readBytes(byte[] byArray) throws JMSException {
        return this.readBytes(byArray, byArray.length);
    }

    public int readBytes(byte[] byArray, int n2) throws JMSException {
        this.initializeReading();
        try {
            int n3;
            int n4;
            for (n3 = 0; n3 < n2 && (n4 = this.dataIn.read(byArray, n3, n2 - n3)) >= 0; n3 += n4) {
            }
            if (n3 == 0 && n2 > 0) {
                n3 = -1;
            }
            return n3;
        }
        catch (EOFException eOFException) {
            MessageEOFException messageEOFException = new MessageEOFException(eOFException.getMessage());
            messageEOFException.setLinkedException(eOFException);
            throw messageEOFException;
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Format error occured" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeBoolean(boolean bl2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeBoolean(bl2);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeByte(byte by2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeByte(by2);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeShort(short s2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeShort(s2);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeChar(char c2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeChar(c2);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeInt(int n2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeInt(n2);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeLong(long l2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeLong(l2);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeFloat(float f2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeFloat(f2);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeDouble(double d2) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeDouble(d2);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeUTF(String string) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeUTF(string);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(byArray);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeBytes(byte[] byArray, int n2, int n3) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            JMSException jMSException = new JMSException("Could not write data:" + iOException.getMessage());
            jMSException.setLinkedException(iOException);
            throw jMSException;
        }
    }

    public void writeObject(Object object) throws JMSException {
        if (object == null) {
            throw new NullPointerException();
        }
        this.initializeWriting();
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof String) {
            this.writeUTF(object.toString());
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else {
            throw new MessageFormatException("Cannot write non-primitive type:" + object.getClass());
        }
    }

    public void reset() throws JMSException {
        this.m_bodyRO = true;
        if (this.dataOut != null) {
            try {
                this.dataOut.flush();
                byte[] byArray = this.bytesOut.toByteArray();
                super.setBodyAsBytes(byArray, 0, byArray.length);
                this.dataOut.close();
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("reset failed: " + iOException.getMessage());
                jMSException.setLinkedException(iOException);
                throw jMSException;
            }
        }
        this.bytesOut = null;
        this.dataIn = null;
        this.dataOut = null;
    }

    private void initializeWriting() throws MessageNotWriteableException {
        this.checkWrite();
        if (this.dataOut == null) {
            this.bytesOut = new ByteArrayOutputStream();
            this.dataOut = new DataOutputStream(this.bytesOut);
        }
    }

    private void initializeReading() throws MessageNotReadableException {
        this.checkRead();
        try {
            ByteArray byteArray = super.getBodyAsBytes();
            if (this.dataIn == null && byteArray != null) {
                this.bodyLength = byteArray.getLength();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray.getBuf(), byteArray.getOffset(), byteArray.getLength());
                this.dataIn = new DataInputStream(byteArrayInputStream);
            }
        }
        catch (IOException iOException) {
            MessageNotReadableException messageNotReadableException = new MessageNotReadableException("getBodyAsBytes failed");
            messageNotReadableException.setLinkedException(iOException);
            throw messageNotReadableException;
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.dataOut = null;
        this.dataIn = null;
        this.bytesOut = null;
    }

    public String toString() {
        return '(' + super.toString() + " ,bytesOut= " + this.bytesOut + " ,dataIn= " + this.dataIn + " ,bytes message body= " + this.m_body_bytes + " ,dataOut= " + this.dataOut + ')';
    }
}

