/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc.driver;

import com.j_spaces.jdbc.driver.Blob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BlobOutputStream
extends OutputStream {
    private Blob a = null;
    private int b = 0;

    public BlobOutputStream(Blob blob, int n2) {
        this.a = blob;
        this.b = n2;
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2 = new byte[this.a.blob.length + n3];
        System.arraycopy(byArray, n2, byArray2, this.b, n3);
        this.a.blob = byArray2;
        this.updateSpace();
    }

    public void write(int n2) throws IOException {
        this.write(new byte[]{(byte)n2});
    }

    public void updateSpace() throws IOException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.a.conn.prepareStatement("UPDATE BY UID SET LOB=?");
            preparedStatement.setBlob(1, this.a);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }
}

