/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.JSpaceContainerImpl;
import com.j_spaces.core.JSpaceImpl;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.AbstractSpaceProxy;
import com.j_spaces.core.client.DCacheSpaceImpl;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.JSpaceProxyWrapper;
import com.j_spaces.core.client.LookupFinder;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.client.view.LocalSpaceView;
import com.j_spaces.core.client.view.View;
import com.j_spaces.core.exception.SpaceConfigurationException;
import com.j_spaces.core.service.Service;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.obf.em;
import com.j_spaces.obf.ey;
import com.j_spaces.obf.li;
import com.sun.jini.start.LifeCycle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.rmi.RMISecurityManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SpaceFinder {
    private static final String a = "GigaSpaces";
    public static String m_ContainerName;
    public static String m_SpaceName;
    private static Map b;
    private static boolean c;
    private static SecurityManager d;
    private static boolean e;
    private static final char f = ';';
    public static final SpaceFinder spaceFinder;
    static /* synthetic */ Class class$com$j_spaces$core$service$Service;

    public static SpaceURL verifyURL(String string) throws MalformedURLException {
        SpaceFinder.a(string);
        em.a();
        return SpaceURLParser.parseURL(string);
    }

    public static Object find(String[] stringArray) throws FinderException {
        return spaceFinder.internalFind(SpaceFinder.prepareUrl(stringArray, null), null);
    }

    public static Object find(String string, IJSpace iJSpace) throws FinderException {
        return spaceFinder.internalFind(SpaceFinder.prepareUrl(string, null), iJSpace);
    }

    public static Object find(String string, IJSpace iJSpace, LifeCycle lifeCycle) throws FinderException {
        SpaceURL[] spaceURLArray = SpaceFinder.prepareUrl(string, null);
        Properties properties = spaceURLArray[spaceURLArray.length - 1].getCustomProperties();
        return spaceFinder.internalFind(spaceURLArray, iJSpace, properties, lifeCycle);
    }

    public static Object find(String string, IJSpace iJSpace, Properties properties, LifeCycle lifeCycle) throws FinderException {
        SpaceURL[] spaceURLArray = SpaceFinder.prepareUrl(string, properties);
        Properties properties2 = spaceURLArray[spaceURLArray.length - 1].getCustomProperties();
        return spaceFinder.internalFind(spaceURLArray, iJSpace, properties2, lifeCycle);
    }

    public static SpaceURL[] prepareUrl(String[] stringArray, Properties properties) throws FinderException {
        if (stringArray.length <= 0) {
            throw new FinderException("Array of SpaceFinder URLs is " + stringArray.length);
        }
        SpaceURL[] spaceURLArray = new SpaceURL[stringArray.length];
        Properties properties2 = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                SpaceFinder.a(stringArray[i2]);
                em.a();
                spaceURLArray[i2] = SpaceURLParser.parseURL(stringArray[i2], properties);
                properties2 = spaceURLArray[i2].getCustomProperties();
                continue;
            }
            catch (Exception exception) {
                if (i2 != stringArray.length - 1) continue;
                throw new FinderException(exception.getMessage(), exception);
            }
        }
        properties = properties2;
        return spaceURLArray;
    }

    public Object internalFind(SpaceURL[] spaceURLArray, IJSpace iJSpace) throws FinderException {
        return this.internalFind(spaceURLArray, iJSpace, null, null);
    }

    public Object internalFind(SpaceURL[] spaceURLArray, IJSpace iJSpace, Properties properties) throws FinderException {
        return this.internalFind(spaceURLArray, iJSpace, properties, null);
    }

    public Object internalFind(SpaceURL[] spaceURLArray, IJSpace iJSpace, Properties properties, LifeCycle lifeCycle) throws FinderException {
        for (int i2 = 0; i2 < spaceURLArray.length; ++i2) {
            try {
                return this._find(spaceURLArray[i2], iJSpace, properties, lifeCycle);
            }
            catch (FinderException finderException) {
                if (i2 != spaceURLArray.length - 1) continue;
                throw finderException;
            }
        }
        return null;
    }

    public static Object find(SpaceURL spaceURL) throws FinderException {
        if (spaceURL == null) {
            throw new FinderException("SpaceURL value must be supplied to this method.");
        }
        return spaceFinder._find(spaceURL, null, spaceURL.getCustomProperties(), null);
    }

    public static Object find(String string) throws FinderException {
        SpaceURL[] spaceURLArray = SpaceFinder.prepareUrl(string, null);
        Properties properties = spaceURLArray[spaceURLArray.length - 1].getCustomProperties();
        return spaceFinder.internalFind(spaceURLArray, null, properties);
    }

    public static Object find(String string, Properties properties) throws FinderException {
        SpaceURL[] spaceURLArray = SpaceFinder.prepareUrl(string, properties);
        Properties properties2 = spaceURLArray[spaceURLArray.length - 1].getCustomProperties();
        return spaceFinder.internalFind(spaceURLArray, null, properties2);
    }

    public static SpaceURL[] prepareUrl(String string, Properties properties) throws FinderException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return SpaceFinder.prepareUrl(stringArray, properties);
    }

    private static void a(String string) {
        if (e) {
            return;
        }
        try {
            if (System.getProperty("java.security.policy") == null) {
                ey.a("policy/gigaspaces.policy");
            }
            if (string.indexOf("securityManager=false") != -1) {
                c = false;
            }
            if (c) {
                d = System.getSecurityManager();
                if (d == null || !(d instanceof RMISecurityManager)) {
                    System.setSecurityManager(new RMISecurityManager());
                }
                e = true;
            }
        }
        catch (RuntimeException runtimeException) {
            String string2 = runtimeException.getMessage();
            System.err.println("WARNING: Failed to find: " + string + ". Failed to set RMISecurityManager. \n" + string2);
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            System.err.println("WARNING: Failed to find: " + string + ". Failed to set RMISecurityManager. \n" + string3);
        }
    }

    public Object _find(SpaceURL spaceURL, IJSpace iJSpace, Properties properties, LifeCycle lifeCycle) throws FinderException {
        try {
            Object object = iJSpace == null ? (spaceURL.getProtocol().equals("java:") ? SpaceFinder.a(spaceURL, lifeCycle, properties) : SpaceFinder.a(spaceURL, properties)) : iJSpace;
            if (object instanceof IJSpace) {
                spaceURL.setPropertiesForSpaceProxy((IJSpace)object);
                object = this.initCacheProperties((IJSpace)object, properties, spaceURL);
            }
            IJSpace iJSpace2 = object;
            return iJSpace2;
        }
        catch (Exception exception) {
            if (exception instanceof FinderException) {
                throw (FinderException)exception;
            }
            throw new FinderException("Failed to find: " + spaceURL.getURL(), exception);
        }
        finally {
            if (c && d != null) {
                try {
                    System.setSecurityManager(d);
                }
                catch (RuntimeException runtimeException) {
                    String string = runtimeException.getMessage();
                    System.err.println("WARNING: Failed to set RMISecurityManager. \n" + string);
                }
                catch (Exception exception) {
                    String string = exception.getMessage();
                    System.err.println("WARNING: Failed to set RMISecurityManager. \n" + string);
                }
            }
        }
    }

    public Object _find(SpaceURL spaceURL, IJSpace iJSpace) throws FinderException {
        return this._find(spaceURL, iJSpace, null, null);
    }

    public Object initCacheProperties(IJSpace iJSpace, Properties properties, SpaceURL spaceURL) throws Exception {
        String string = spaceURL.getProperty("useLocalCache", Boolean.FALSE.toString());
        if (string.equalsIgnoreCase(Boolean.TRUE.toString())) {
            SpaceFinder.loadCacheConfig(spaceURL, iJSpace, properties);
            String string2 = spaceURL.getProperty("versioned");
            return SpaceFinder.a(spaceURL, iJSpace, string, string2);
        }
        return iJSpace;
    }

    private static IJSpaceContainer a(String string, String string2, String string3, SpaceURL spaceURL, Properties properties, LifeCycle lifeCycle) throws Exception {
        String string4 = li.a();
        File file = new File(string4);
        if (!file.isDirectory()) {
            throw new FinderException("ERROR: Defined home-directory: " + string4 + " doesn't exists.");
        }
        String string5 = string4 + File.separator + "config" + File.separator + string + "-config.xml";
        File file2 = new File(string5);
        if (!file2.canRead() && !JSpaceUtilities.isEmpty(string2)) {
            Logger logger = Logger.getLogger("com.gigaspaces.client");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Could not find the " + string + "-config.xml file: " + string5 + ".\n Loading the default container schema file from the ResourceBundle, for the container configuration.");
            }
            InputStream inputStream = ResourceLoader.findContainerSchema(string2);
            JProperties.setInputStream(inputStream, properties);
        } else {
            JProperties.setURL(string5);
        }
        JProperties.getProperties().setProperty("com.j_spaces.core.container.name", string);
        return new JSpaceContainerImpl(lifeCycle, string2, string3, spaceURL, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object a(SpaceURL spaceURL, LifeCycle lifeCycle, Properties properties) throws Exception {
        Object object;
        WeakReference weakReference;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string = spaceURL.getSpaceName();
        String string2 = spaceURL.getContainerName();
        String string3 = spaceURL.getProperty("schema");
        if (JSpaceUtilities.isEmpty(string3)) {
            string3 = spaceURL.getSchema();
        }
        JSpaceUtilities.setXMLImplSystemProps();
        String string4 = spaceURL.getProperty("create");
        if (string2 == null) {
            throw new FinderException("Using java:// protocol ContainerName should be defined in SpaceFinder URL");
        }
        if ((string4 != null && !string4.equalsIgnoreCase("false") || JSpaceUtilities.isEmpty(string) && JSpaceUtilities.isEmpty(string3)) && string3 == null) {
            string3 = "default";
        }
        boolean bl2 = true;
        WeakReference weakReference2 = (WeakReference)b.get(spaceURL);
        Object object7 = object6 = weakReference2 == null ? null : (IJSpaceContainer)weakReference2.get();
        if (object6 != null) {
            if (((JSpaceContainerImpl)object6).getContainerStatus() != 2) {
                bl2 = false;
            } else if (((JSpaceContainerImpl)object6).getContainerStatus() == 2) {
                b.remove(spaceURL);
            } else if (bl2) {
                object5 = b;
                synchronized (object5) {
                    object4 = b.entrySet().iterator();
                    while (object4.hasNext()) {
                        object3 = (Map.Entry)object4.next();
                        object2 = (SpaceURL)object3.getKey();
                        if (!((SpaceURL)object2).getContainerName().equals(string2) || (weakReference = (object = (WeakReference)object3.getValue()) == null ? null : (IJSpaceContainer)((Reference)object).get()) == null) continue;
                        if (((JSpaceContainerImpl)((Object)weakReference)).getContainerStatus() == 2) {
                            object4.remove();
                            continue;
                        }
                        throw new FinderException("Container <" + string2 + "> already exists.");
                    }
                }
            }
        }
        if (bl2) {
            object5 = b;
            synchronized (object5) {
                weakReference2 = (WeakReference)b.get(spaceURL);
                Object object8 = object6 = weakReference2 == null ? null : (IJSpaceContainer)weakReference2.get();
                if (object6 != null && ((JSpaceContainerImpl)object6).getContainerStatus() != 2) {
                    bl2 = false;
                }
                if (string4 != null && string4.equalsIgnoreCase("false")) {
                    bl2 = false;
                }
                if (bl2) {
                    object4 = SpaceFinder.a(string2, string3, string, spaceURL, properties, lifeCycle);
                    b.put(spaceURL, new WeakReference<Object>(object4));
                    object6 = object4;
                    if (string == null) {
                        return object4;
                    }
                }
            }
        } else if (string == null) {
            return object6;
        }
        if (spaceURL.getProperty("destroy") != null) {
            object5 = Logger.getLogger("com.gigaspaces.client");
            if (((Logger)object5).isLoggable(Level.INFO)) {
                ((Logger)object5).log(Level.INFO, "java:// protocol. Destroy <" + string + "> space in " + string2 + ">");
            }
            object6.destroySpace(string);
            return null;
        }
        if (string4 != null && string4.equalsIgnoreCase("false")) {
            object5 = b;
            synchronized (object5) {
                object4 = b.entrySet();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    IJSpaceContainer iJSpaceContainer;
                    object2 = (Map.Entry)object3.next();
                    object = (SpaceURL)object2.getKey();
                    if (!((SpaceURL)object).getContainerName().equals(string2)) continue;
                    weakReference = (WeakReference)object2.getValue();
                    IJSpaceContainer iJSpaceContainer2 = iJSpaceContainer = weakReference == null ? null : (IJSpaceContainer)weakReference.get();
                    if (iJSpaceContainer == null) continue;
                    object6 = iJSpaceContainer;
                }
                if (object6 != null) {
                    object2 = Logger.getLogger("com.gigaspaces.client");
                    if (((Logger)object2).isLoggable(Level.INFO)) {
                        ((Logger)object2).log(Level.INFO, "java:// protocol. Get <" + string + "> space from <" + string2 + "> container");
                    }
                    return object6.getClusteredSpace(string, true);
                }
                throw new NoSuchNameException("Space <" + string + "> could not be found using space url: " + spaceURL.getURL());
            }
        }
        if (string4 != null && !string4.equalsIgnoreCase("false")) {
            boolean bl3 = Boolean.valueOf(spaceURL.getProperty("useLocalCache", "false"));
            try {
                return object6.getSpace(string, true);
            }
            catch (NoSuchNameException noSuchNameException) {
                object3 = Logger.getLogger("com.gigaspaces.client");
                if (((Logger)object3).isLoggable(Level.INFO)) {
                    ((Logger)object3).log(Level.INFO, "java:// protocol. Create <" + string + "> space in <" + string2 + ">");
                }
                object2 = new JSpaceAttributes(string3, properties);
                ((JSpaceAttributes)object2).setPrivate(bl3);
                return object6.createSpace(string, (JSpaceAttributes)object2);
            }
        }
        object5 = Logger.getLogger("com.gigaspaces.client");
        if (((Logger)object5).isLoggable(Level.INFO)) {
            ((Logger)object5).log(Level.INFO, "java:// protocol. Get <" + string + "> space from <" + string2 + "> container");
        }
        return object6.getClusteredSpace(string, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object a(SpaceURL spaceURL, Properties properties) throws Exception {
        Object object = null;
        String string = spaceURL.getContainerName();
        String string2 = spaceURL.getSpaceName();
        String string3 = spaceURL.getHost();
        String string4 = spaceURL.getProperty("groups");
        long l2 = Long.parseLong(spaceURL.getProperty("timeout", "-1"));
        Class[] classArray = new Class[1];
        Class<?> clazz = class$com$j_spaces$core$service$Service;
        if (clazz == null) {
            clazz = class$com$j_spaces$core$service$Service = new Service[0].getClass().getComponentType();
        }
        classArray[0] = clazz;
        Class[] classArray2 = classArray;
        if (string2 != null && string2.equals("*")) {
            if (!spaceURL.getProtocol().equals("rmi:")) return LookupFinder.find(null, classArray2, spaceURL.getLookupAttributes(), string3, string4, l2, properties);
            throw new MalformedURLException("Wrong URL definition. When looking for a clustered space, use only a JINI protocol. Used URL: " + spaceURL);
        }
        if (spaceURL.getProtocol().equals("jini:")) {
            if (string.equals("*")) {
                return LookupFinder.find(null, classArray2, spaceURL.getLookupAttributes(), string3, string4, l2, properties);
            }
            if (string.equals("*")) return LookupFinder.find(null, classArray2, spaceURL.getLookupAttributes(), string3, string4, l2, properties);
            if (string2 == null) return LookupFinder.find(null, classArray2, spaceURL.getLookupAttributes(), string3, string4, l2, properties);
            return LookupFinder.find(null, classArray2, spaceURL.getLookupAttributes(), string3, string4, l2, properties);
        }
        Properties properties2 = new Properties();
        properties2.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        properties2.put("java.naming.provider.url", "rmi://" + spaceURL.getHost());
        InitialContext initialContext = new InitialContext(properties2);
        if (string2 == null) {
            return initialContext.lookup("GigaSpaces;" + string);
        }
        JSpaceProxyWrapper jSpaceProxyWrapper = (JSpaceProxyWrapper)initialContext.lookup("GigaSpaces;" + string + ';' + string2);
        return jSpaceProxyWrapper.proxy();
    }

    public static void loadCacheConfig(SpaceURL spaceURL, IJSpace iJSpace, Properties properties) throws FinderException, SAXException, ParserConfigurationException, IOException {
        InputStream inputStream;
        SpaceConfig spaceConfig;
        String string;
        block5: {
            String string2 = spaceURL.getSpaceName();
            string = string2 + "_DCache";
            if (string2.equals("*")) {
                throw new FinderException("Using distributed cache - space name should be defined in SpaceFinder URL");
            }
            spaceConfig = ((IRemoteJSpaceAdmin)iJSpace.getAdmin()).getConfig();
            spaceConfig.getDCacheProperties().setProperty("engine.local_cache_mode", Boolean.TRUE.toString());
            inputStream = null;
            try {
                inputStream = ResourceLoader.findConfigDCache(spaceConfig.getDCacheConfigName(), null, string2, null);
            }
            catch (SpaceConfigurationException spaceConfigurationException) {
                String string3 = spaceConfigurationException.getMessage();
                Logger logger = Logger.getLogger("com.gigaspaces.client");
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, "Failed to load DCache configuration.", string3);
            }
        }
        if (inputStream != null) {
            JProperties.setURL(string, null, inputStream, false, properties);
        } else {
            JProperties.setSpaceProperties(string, spaceConfig.getDCacheProperties());
        }
    }

    private static IJSpace a(SpaceURL spaceURL, IJSpace iJSpace, String string, String string2) throws Exception {
        AbstractSpaceProxy abstractSpaceProxy;
        String string3 = spaceURL.getContainerName();
        String string4 = spaceURL.getSpaceName();
        String string5 = string4 + "_DCache";
        JSpaceAttributes jSpaceAttributes = new JSpaceAttributes();
        jSpaceAttributes.setPrivate(true);
        JSpaceImpl jSpaceImpl = new JSpaceImpl(string3, string5, null, spaceURL, null, jSpaceAttributes);
        IJSpace iJSpace2 = jSpaceImpl.getSpaceProxy(true, null);
        String string6 = "useLocalCache=true";
        String string7 = "useLocalCache=false";
        String string8 = JSpaceUtilities.replaceInString(spaceURL.getURL(), string6, string7, true);
        View[] viewArray = (View[])spaceURL.getCustomProperties().get("views");
        String string9 = spaceURL.getProperty("views");
        if (string9 != null) {
            viewArray = SpaceFinder.a(string9, viewArray);
        }
        if ((viewArray == null || viewArray.length == 0) && string9 == null) {
            String string10 = spaceURL.getProperty("updateMode");
            if (string10 == null) {
                abstractSpaceProxy = new DCacheSpaceImpl(iJSpace2, iJSpace, string8, string2);
            } else {
                int n2 = Integer.parseInt(string10);
                abstractSpaceProxy = new DCacheSpaceImpl(iJSpace2, iJSpace, string8, n2, string2);
            }
            if (viewArray != null) {
                throw new UnsupportedOperationException("Views are currently supported only with useLocalCache");
            }
        } else {
            abstractSpaceProxy = new LocalSpaceView(iJSpace2, iJSpace, string8, string2, viewArray);
        }
        return abstractSpaceProxy;
    }

    private static View[] a(String string, View[] viewArray) {
        Object[] objectArray;
        if (string.startsWith("{")) {
            string = string.substring(1);
        }
        if (string.endsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<View> arrayList = new ArrayList<View>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            objectArray = string2.split(":");
            arrayList.add(new View(objectArray[0], (String)(objectArray.length > 1 ? objectArray[1] : null)));
        }
        int n2 = arrayList.size() + (viewArray == null ? 0 : viewArray.length);
        objectArray = new View[n2];
        arrayList.toArray(objectArray);
        if (viewArray != null) {
            System.arraycopy(viewArray, 0, objectArray, arrayList.size(), viewArray.length);
        }
        return objectArray;
    }

    public static void main(String[] stringArray) throws FinderException {
        Logger logger;
        Object object;
        if (stringArray.length <= 0) {
            SpaceURLParser.printUsage();
            System.exit(-1);
        }
        if ((object = SpaceFinder.find(stringArray[0])) != null && (logger = Logger.getLogger("com.gigaspaces.client")).isLoggable(Level.FINE)) {
            if (object instanceof IJSpace) {
                logger.log(Level.FINE, "Found space: " + object + "  URL: " + ((IJSpace)object).getURL());
            } else {
                logger.log(Level.FINE, "Found space: " + object);
            }
        }
    }

    static {
        b = Collections.synchronizedMap(new WeakHashMap());
        c = true;
        d = null;
        spaceFinder = new SpaceFinder();
    }
}

