/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.config;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;

public class Config {
    static final Logger logger = Logger.getLogger("net.jini.config");

    private Config() {
        throw new AssertionError((Object)"com.sun.jini.config.Config cannot be instantiated");
    }

    public static Object getNonNullEntry(Configuration config, String component, String name, Class type) throws ConfigurationException {
        return Config.getNonNullEntry(config, component, name, type, Configuration.NO_DEFAULT, Configuration.NO_DATA);
    }

    public static Object getNonNullEntry(Configuration config, String component, String name, Class type, Object defaultValue) throws ConfigurationException {
        return Config.getNonNullEntry(config, component, name, type, defaultValue, Configuration.NO_DATA);
    }

    public static Object getNonNullEntry(Configuration config, String component, String name, Class type, Object defaultValue, Object data) throws ConfigurationException {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue cannot be null");
        }
        Object result = config.getEntry(component, name, type, defaultValue, data);
        if (result == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0}, component {1}, name {2}: cannot be null", new Object[]{config, component, name});
            }
            throw new ConfigurationException("entry for component " + component + ", name " + name + " cannot be null");
        }
        return result;
    }

    private static boolean inRange(int value, int min, int max) {
        return min <= value && value <= max;
    }

    private static boolean inRange(long value, long min, long max) {
        return min <= value && value <= max;
    }

    private static boolean inRange(float value, float min, float max) {
        return min <= value && value <= max;
    }

    public static long getLongEntry(Configuration config, String component, String name, long defaultValue, long min, long max) throws ConfigurationException {
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        if (!Config.inRange(defaultValue, min, max)) {
            throw new IllegalArgumentException("defaultValue (" + defaultValue + ") must be between " + min + " and " + max);
        }
        long rslt = (Long)config.getEntry(component, name, Long.TYPE, (Object)new Long(defaultValue));
        if (!Config.inRange(rslt, min, max)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0}, component {1}, name {2}: entry is out of range, value: {3}, valid range: {4}:{5}", new Object[]{config, component, name, new Long(rslt), new Long(min), new Long(max)});
            }
            throw new ConfigurationException("entry for component " + component + ", name " + name + " must be between " + min + " and " + max + ", has a value of " + rslt);
        }
        return rslt;
    }

    public static int getIntEntry(Configuration config, String component, String name, int defaultValue, int min, int max) throws ConfigurationException {
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        if (!Config.inRange(defaultValue, min, max)) {
            throw new IllegalArgumentException("defaultValue (" + defaultValue + ") must be between " + min + " and " + max);
        }
        int rslt = (Integer)config.getEntry(component, name, Integer.TYPE, (Object)new Integer(defaultValue));
        if (!Config.inRange(rslt, min, max)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0}, component {1}, name {2}: entry is out of range, value: {3}, valid range: {4}:{5}", new Object[]{config, component, name, new Integer(rslt), new Integer(min), new Integer(max)});
            }
            throw new ConfigurationException("entry for component " + component + ", name " + name + " must be between " + min + " and " + max + ", has a value of " + rslt);
        }
        return rslt;
    }

    public static float getFloatEntry(Configuration config, String component, String name, float defaultValue, float min, float max) throws ConfigurationException {
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        if (!Config.inRange(defaultValue, min, max)) {
            throw new IllegalArgumentException("defaultValue (" + defaultValue + ") must be between " + min + " and " + max);
        }
        float rslt = ((Float)config.getEntry(component, name, Float.TYPE, (Object)new Float(defaultValue))).floatValue();
        if (!Config.inRange(rslt, min, max)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0}, component {1}, name {2}: entry is out of range, value: {3}, valid range: {4}:{5}", new Object[]{config, component, name, new Float(rslt), new Float(min), new Float(max)});
            }
            throw new ConfigurationException("entry for component " + component + ", name " + name + " must be between " + min + " and " + max + ", has a value of " + rslt);
        }
        return rslt;
    }
}

