/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.plugins.parser.m2.PomModuleDescriptorWriter;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.util.FileUtil;
import org.apache.tools.ant.BuildException;

public class IvyMakePom
extends IvyTask {
    private File pomFile = null;
    private File headerFile = null;
    private File ivyFile = null;
    private Collection mappings = new ArrayList();

    public File getPomFile() {
        return this.pomFile;
    }

    public void setPomFile(File file) {
        this.pomFile = file;
    }

    public File getIvyFile() {
        return this.ivyFile;
    }

    public void setIvyFile(File ivyFile) {
        this.ivyFile = ivyFile;
    }

    public File getHeaderFile() {
        return this.headerFile;
    }

    public void setHeaderFile(File headerFile) {
        this.headerFile = headerFile;
    }

    public Mapping createMapping() {
        Mapping mapping = new Mapping();
        this.mappings.add(mapping);
        return mapping;
    }

    public void doExecute() throws BuildException {
        try {
            if (this.ivyFile == null) {
                throw new BuildException("source ivy file is required for makepom task");
            }
            if (this.pomFile == null) {
                throw new BuildException("destination pom file is required for makepom task");
            }
            ModuleDescriptor md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.getSettings(), this.ivyFile.toURI().toURL(), false);
            PomModuleDescriptorWriter.write(md, this.headerFile == null ? null : FileUtil.readEntirely(this.getHeaderFile()), this.mappings.isEmpty() ? PomModuleDescriptorWriter.DEFAULT_MAPPING : new PomModuleDescriptorWriter.ConfigurationScopeMapping(this.getMappingsMap()), this.pomFile);
        }
        catch (MalformedURLException e) {
            throw new BuildException("unable to convert given ivy file to url: " + this.ivyFile + ": " + e, (Throwable)e);
        }
        catch (ParseException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file " + this.ivyFile + ": " + e, (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException("impossible convert given ivy file to pom file: " + e + " from=" + this.ivyFile + " to=" + this.pomFile, (Throwable)e);
        }
    }

    private Map getMappingsMap() {
        HashMap<String, String> mappingsMap = new HashMap<String, String>();
        Iterator iter = this.mappings.iterator();
        while (iter.hasNext()) {
            Mapping mapping = (Mapping)iter.next();
            mappingsMap.put(mapping.getConf(), mapping.getScope());
        }
        return mappingsMap;
    }

    public class Mapping {
        private String conf;
        private String scope;

        public String getConf() {
            return this.conf;
        }

        public void setConf(String conf) {
            this.conf = conf;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }
    }
}

