/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class GraphicalReference
extends GraphicalElement
implements InGroupable {
    private final Component comp;
    private final LivingParticipantBox livingParticipantBox1;
    private final LivingParticipantBox livingParticipantBox2;
    private final Url url;

    public GraphicalReference(double startingY, Component comp, LivingParticipantBox livingParticipantBox1, LivingParticipantBox livingParticipantBox2, Url url) {
        super(startingY);
        if (livingParticipantBox1 == null || livingParticipantBox2 == null) {
            throw new IllegalArgumentException();
        }
        this.url = url;
        this.comp = comp;
        this.livingParticipantBox1 = livingParticipantBox1;
        this.livingParticipantBox2 = livingParticipantBox2;
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        StringBounder stringBounder = ug.getStringBounder();
        double posX = this.getMinX(stringBounder);
        ug = ug.apply(new UTranslate(posX, this.getStartingY()));
        double preferredWidth = this.comp.getPreferredWidth(stringBounder);
        double w = this.getMaxX(stringBounder) - this.getMinX(stringBounder);
        double width = Math.max(preferredWidth, w);
        Dimension2DDouble dim = new Dimension2DDouble(width, this.comp.getPreferredHeight(stringBounder));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.comp.drawU(ug, new Area(dim), context);
        if (this.url != null) {
            ug.closeAction();
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.comp.getPreferredHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.comp.getPreferredWidth(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        return this.getMinX(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return Math.max(this.livingParticipantBox1.getMaxX(stringBounder), this.livingParticipantBox2.getMaxX(stringBounder));
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return Math.min(this.livingParticipantBox1.getMinX(stringBounder), this.livingParticipantBox2.getMinX(stringBounder));
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.toString();
    }
}

