/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.Balloon;
import net.sourceforge.plantuml.cute.CuteShape;
import net.sourceforge.plantuml.cute.MyDouble;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.cute.VarArgs;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;

public class Cheese
implements CuteShape {
    private final MyDouble radius;
    private final MyDouble startAngle;
    private final MyDouble endAngle;
    private final RotationZoom rotationZoom;

    public Cheese(VarArgs varArgs) {
        this.radius = varArgs.getAsMyDouble("radius");
        this.startAngle = varArgs.getAsMyDouble("start").toRadians();
        this.endAngle = varArgs.getAsMyDouble("end").toRadians();
        this.rotationZoom = RotationZoom.none();
    }

    public Cheese(MyDouble radius, MyDouble startAngle, MyDouble endAngle, RotationZoom rotation) {
        this.radius = radius;
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        this.rotationZoom = rotation;
    }

    @Override
    public void drawU(UGraphic ug) {
        Balloon insideB;
        Point2D ptA0;
        Balloon balloon = new Balloon(new Point2D.Double(), this.radius.getValue()).rotate(this.rotationZoom);
        double angle1 = this.rotationZoom.applyRotation(this.startAngle.getValue());
        double angle2 = this.rotationZoom.applyRotation(this.endAngle.getValue());
        Point2D ptA = balloon.getPointOnCircle(angle1);
        Point2D ptB = balloon.getPointOnCircle(angle2);
        UPath path = new UPath();
        if (this.radius.hasCurvation()) {
            ptA0 = balloon.getSegmentCenterToPointOnCircle(angle1).getFromAtoB(this.radius.getCurvation(0.0));
            path.moveTo(ptA0);
        } else {
            ptA0 = null;
            path.moveTo(balloon.getCenter());
        }
        if (this.startAngle.hasCurvation()) {
            Balloon insideA = balloon.getInsideTangentBalloon1(angle1, this.startAngle.getCurvation(0.0));
            Point2D ptA1 = balloon.getSegmentCenterToPointOnCircle(angle1).getFromAtoB(this.radius.getValue() - this.startAngle.getCurvation(0.0));
            Point2D ptA2 = balloon.getPointOnCirclePassingByThisPoint(insideA.getCenter());
            path.lineTo(ptA1);
            path.arcTo(ptA2, insideA.getRadius(), 0.0, 1.0);
        } else {
            Object insideA = null;
            path.lineTo(ptA);
        }
        if (this.endAngle.hasCurvation()) {
            insideB = balloon.getInsideTangentBalloon2(angle2, this.endAngle.getCurvation(0.0));
            Point2D ptB1 = balloon.getPointOnCirclePassingByThisPoint(insideB.getCenter());
            Point2D ptB2 = balloon.getSegmentCenterToPointOnCircle(angle2).getFromAtoB(this.radius.getValue() - this.endAngle.getCurvation(0.0));
            path.arcTo(ptB1, balloon.getRadius(), 0.0, 1.0);
            path.arcTo(ptB2, insideB.getRadius(), 0.0, 1.0);
        } else {
            insideB = null;
            path.arcTo(ptB, balloon.getRadius(), 0.0, 1.0);
        }
        if (this.radius.hasCurvation()) {
            Point2D ptB0 = balloon.getSegmentCenterToPointOnCircle(angle2).getFromAtoB(this.radius.getCurvation(0.0));
            path.lineTo(ptB0);
            path.arcTo(ptA0, this.radius.getCurvation(0.0), 0.0, 1.0);
        } else {
            path.lineTo(balloon.getCenter());
        }
        path.closePath();
        ug.draw(path);
    }

    @Override
    public CuteShape rotateZoom(RotationZoom other) {
        return new Cheese(this.radius, this.startAngle, this.endAngle, this.rotationZoom.compose(other));
    }
}

