/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.braille;

import net.sourceforge.plantuml.braille.BrailleGrid;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class BrailleDrawer
implements UDrawable {
    private final BrailleGrid grid;
    private final double step = 9.0;
    private final double spotSize = 5.0;

    public BrailleDrawer(BrailleGrid grid) {
        this.grid = grid;
    }

    @Override
    public void drawU(UGraphic ug) {
        int x;
        ug = ug.apply(new UChangeColor(new HtmlColorSetSimple().getColorIfValid("#F0F0F0")));
        for (x = this.grid.getMinX(); x <= this.grid.getMaxX(); ++x) {
            ug.apply(new UTranslate((double)x * 9.0 + 5.0 + 1.0, 0.0)).draw(new ULine(0.0, (double)(this.grid.getMaxY() - this.grid.getMinY()) * 9.0));
        }
        for (int y = this.grid.getMinY(); y <= this.grid.getMaxY(); ++y) {
            ug.apply(new UTranslate(0.0, (double)y * 9.0 + 5.0 + 1.0)).draw(new ULine((double)(this.grid.getMaxX() - this.grid.getMinX()) * 9.0, 0.0));
        }
        ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(HtmlColorUtils.BLACK));
        for (x = this.grid.getMinX(); x <= this.grid.getMaxX(); ++x) {
            for (int y = this.grid.getMinY(); y <= this.grid.getMaxY(); ++y) {
                if (!this.grid.getState(x, y)) continue;
                this.drawCircle(ug, x, y);
            }
        }
    }

    private void drawCircle(UGraphic ug, int x, int y) {
        double cx = (double)x * 9.0;
        double cy = (double)y * 9.0;
        ug.apply(new UTranslate(cx, cy)).draw(new UEllipse(5.0, 5.0));
    }
}

