/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.hand;

import java.util.Random;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.hand.UDotPathHand;
import net.sourceforge.plantuml.ugraphic.hand.UEllipseHand;
import net.sourceforge.plantuml.ugraphic.hand.ULineHand;
import net.sourceforge.plantuml.ugraphic.hand.UPathHand;
import net.sourceforge.plantuml.ugraphic.hand.UPolygonHand;
import net.sourceforge.plantuml.ugraphic.hand.URectangleHand;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

public class UGraphicHandwritten
implements UGraphic {
    private final UGraphic ug;
    private final Random rnd = new Random(424242L);

    public UGraphicHandwritten(UGraphic ug) {
        this.ug = ug;
        if (ug instanceof UGraphicSvg) {
            ((UGraphicSvg)ug).enlargeClip();
        }
    }

    @Override
    public StringBounder getStringBounder() {
        return this.ug.getStringBounder();
    }

    @Override
    public UParam getParam() {
        return this.ug.getParam();
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof ULine) {
            this.drawHand((ULine)shape);
        } else if (shape instanceof URectangle) {
            this.drawHand((URectangle)shape);
        } else if (shape instanceof UPolygon) {
            this.drawHand((UPolygon)shape);
        } else if (shape instanceof UEllipse) {
            this.drawHand((UEllipse)shape);
        } else if (shape instanceof DotPath) {
            this.drawHand((DotPath)shape);
        } else if (shape instanceof UPath) {
            this.drawHand((UPath)shape);
        } else {
            this.ug.draw(shape);
        }
    }

    private void drawHand(UPath shape) {
        UPathHand uline = new UPathHand(shape, this.rnd);
        this.ug.draw(uline.getHanddrawn());
    }

    private void drawHand(DotPath shape) {
        UDotPathHand uline = new UDotPathHand(shape, this.rnd);
        this.ug.draw(uline.getHanddrawn());
    }

    private void drawHand(UPolygon shape) {
        UPolygonHand hand = new UPolygonHand(shape, this.rnd);
        this.ug.draw(hand.getHanddrawn());
    }

    private void drawHand(URectangle shape) {
        URectangleHand hand = new URectangleHand(shape, this.rnd);
        this.ug.draw(hand.getHanddrawn());
    }

    private void drawHand(ULine shape) {
        ULineHand uline = new ULineHand(shape, this.rnd);
        this.ug.draw(uline.getHanddrawn());
    }

    private void drawHand(UEllipse shape) {
        UEllipseHand uline = new UEllipseHand(shape, this.rnd);
        this.ug.draw(uline.getHanddrawn());
    }

    @Override
    public UGraphic apply(UChange change) {
        return new UGraphicHandwritten(this.ug.apply(change));
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.ug.getColorMapper();
    }

    @Override
    public void startUrl(Url url) {
        this.ug.startUrl(url);
    }

    @Override
    public void closeAction() {
        this.ug.closeAction();
    }

    @Override
    public void flushUg() {
        this.ug.flushUg();
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        return this.ug.matchesProperty(propertyName);
    }
}

