/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileDiamondFoo1
extends AbstractFtile {
    private final HtmlColor backColor;
    private final HtmlColor borderColor;
    private final Swimlane swimlane;
    private final TextBlock label;
    private final TextBlock west;
    private final TextBlock east;
    private final TextBlock north;

    public FtileDiamondFoo1(ISkinParam skinParam, HtmlColor backColor, HtmlColor borderColor, Swimlane swimlane, TextBlock label) {
        this(skinParam, backColor, borderColor, swimlane, label, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamondFoo1 withNorth(TextBlock north) {
        return new FtileDiamondFoo1(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, north, this.west, this.east);
    }

    public FtileDiamondFoo1 withWest(TextBlock west) {
        return new FtileDiamondFoo1(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, west, this.east);
    }

    public FtileDiamondFoo1 withEast(TextBlock east) {
        return new FtileDiamondFoo1(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, this.west, east);
    }

    private FtileDiamondFoo1(ISkinParam skinParam, HtmlColor backColor, HtmlColor borderColor, Swimlane swimlane, TextBlock label, TextBlock north, TextBlock west, TextBlock east) {
        super(skinParam);
        this.backColor = backColor;
        this.swimlane = swimlane;
        this.borderColor = borderColor;
        this.label = label;
        this.west = west;
        this.east = east;
        this.north = north;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimLabel = this.label.calculateDimension(stringBounder);
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        ug = ug.apply(new UChangeColor(this.borderColor)).apply(this.getThickness()).apply(new UChangeBackColor(this.backColor));
        ug.draw(Diamond.asPolygonFoo1(this.skinParam().shadowing(null), dimTotal.getWidth(), dimTotal.getHeight()));
        this.north.drawU(ug.apply(new UTranslate(4.0 + dimTotal.getWidth() / 2.0, dimTotal.getHeight())));
        double lx = (dimTotal.getWidth() - dimLabel.getWidth()) / 2.0;
        double ly = (dimTotal.getHeight() - dimLabel.getHeight()) / 2.0;
        this.label.drawU(ug.apply(new UTranslate(lx, ly)));
        Dimension2D dimWeat = this.west.calculateDimension(stringBounder);
        this.west.drawU(ug.apply(new UTranslate(-dimWeat.getWidth(), -dimWeat.getHeight() + 12.0)));
        Dimension2D dimEast = this.east.calculateDimension(stringBounder);
        this.east.drawU(ug.apply(new UTranslate(dimTotal.getWidth(), -dimEast.getHeight() + 12.0)));
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dim = this.calculateDimensionInternal(stringBounder);
        return new FtileGeometry(dim, dim.getWidth() / 2.0, 0.0, dim.getHeight());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimLabel = this.label.calculateDimension(stringBounder);
        if (dimLabel.getWidth() == 0.0 || dimLabel.getHeight() == 0.0) {
            return new Dimension2DDouble(24.0, 24.0);
        }
        Dimension2D result = dimLabel;
        result = Dimension2DDouble.delta(result, 24.0, 24.0);
        return result;
    }
}

