/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class Opale
extends AbstractTextBlock
implements TextBlock {
    private static final int cornersize = 10;
    private final HtmlColor noteBackgroundColor;
    private final HtmlColor borderColor;
    private final int marginX1 = 6;
    private final int marginX2 = 15;
    private final int marginY = 5;
    private final double shadowing2;
    private Direction strategy;
    private Point2D pp1;
    private Point2D pp2;
    private final boolean withLink;
    private double roundCorner;
    private final TextBlock textBlock;
    private final double delta = 4.0;

    public Opale(double shadowing, HtmlColor borderColor, HtmlColor noteBackgroundColor, TextBlock textBlock, boolean withLink) {
        this.noteBackgroundColor = noteBackgroundColor;
        this.withLink = withLink;
        this.shadowing2 = shadowing;
        this.borderColor = borderColor;
        this.textBlock = textBlock;
    }

    public void setRoundCorner(double roundCorner) {
        this.roundCorner = roundCorner;
    }

    public void setOpale(Direction strategy, Point2D pp1, Point2D pp2) {
        this.strategy = strategy;
        this.pp1 = pp1;
        this.pp2 = pp2;
    }

    private final double getWidth(StringBounder stringBounder) {
        return this.textBlock.calculateDimension(stringBounder).getWidth() + 6.0 + 15.0;
    }

    private final double getHeight(StringBounder stringBounder) {
        Dimension2D size = this.textBlock.calculateDimension(stringBounder);
        return size.getHeight() + 10.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double height = this.getHeight(stringBounder);
        double width = this.getWidth(stringBounder);
        return new Dimension2DDouble(width, height);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UPath polygon;
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(new UChangeBackColor(this.noteBackgroundColor)).apply(new UChangeColor(this.borderColor));
        if (!this.withLink) {
            polygon = this.getPolygonNormal(stringBounder);
        } else if (this.strategy == Direction.LEFT) {
            polygon = this.getPolygonLeft(stringBounder, this.pp1, this.pp2);
        } else if (this.strategy == Direction.RIGHT) {
            polygon = this.getPolygonRight(stringBounder, this.pp1, this.pp2);
        } else if (this.strategy == Direction.UP) {
            polygon = this.getPolygonUp(stringBounder, this.pp1, this.pp2);
        } else if (this.strategy == Direction.DOWN) {
            polygon = this.getPolygonDown(stringBounder, this.pp1, this.pp2);
        } else {
            throw new IllegalArgumentException();
        }
        polygon.setDeltaShadow(this.shadowing2);
        ug.draw(polygon);
        ug.draw(Opale.getCorner(this.getWidth(stringBounder), this.roundCorner));
        this.textBlock.drawU(ug.apply(new UTranslate(6.0, 5.0)));
    }

    private UPath getPolygonNormal(StringBounder stringBounder) {
        return Opale.getPolygonNormal(this.getWidth(stringBounder), this.getHeight(stringBounder), this.roundCorner);
    }

    public static UPath getCorner(double width, double roundCorner) {
        UPath path = new UPath();
        path.moveTo(width - 10.0, 0.0);
        if (roundCorner == 0.0) {
            path.lineTo(width - 10.0, 10.0);
        } else {
            path.lineTo(width - 10.0, 10.0 - roundCorner / 4.0);
            path.arcTo(new Point2D.Double(width - 10.0 + roundCorner / 4.0, 10.0), roundCorner / 4.0, 0.0, 0.0);
        }
        path.lineTo(width, 10.0);
        path.lineTo(width - 10.0, 0.0);
        path.closePath();
        return path;
    }

    public static UPath getPolygonNormal(double width, double height, double roundCorner) {
        UPath polygon = new UPath();
        if (roundCorner == 0.0) {
            polygon.moveTo(0.0, 0.0);
            polygon.lineTo(0.0, height);
            polygon.lineTo(width, height);
            polygon.lineTo(width, 10.0);
            polygon.lineTo(width - 10.0, 0.0);
            polygon.lineTo(0.0, 0.0);
        } else {
            polygon.moveTo(0.0, roundCorner / 2.0);
            polygon.lineTo(0.0, height - roundCorner / 2.0);
            polygon.arcTo(new Point2D.Double(roundCorner / 2.0, height), roundCorner / 2.0, 0.0, 0.0);
            polygon.lineTo(width - roundCorner / 2.0, height);
            polygon.arcTo(new Point2D.Double(width, height - roundCorner / 2.0), roundCorner / 2.0, 0.0, 0.0);
            polygon.lineTo(width, 10.0);
            polygon.lineTo(width - 10.0, 0.0);
            polygon.lineTo(roundCorner / 2.0, 0.0);
            polygon.arcTo(new Point2D.Double(0.0, roundCorner / 2.0), roundCorner / 2.0, 0.0, 0.0);
        }
        polygon.closePath();
        return polygon;
    }

    private UPath getPolygonLeft(StringBounder stringBounder, Point2D pp1, Point2D pp2) {
        UPath polygon = new UPath();
        polygon.moveTo(0.0, this.roundCorner / 2.0);
        double y1 = pp1.getY() - 4.0;
        y1 = MathUtils.limitation(y1, 0.0, this.getHeight(stringBounder) - 8.0);
        polygon.lineTo(0.0, y1);
        polygon.lineTo(pp2.getX(), pp2.getY());
        polygon.lineTo(0.0, y1 + 8.0);
        polygon.lineTo(0.0, this.getHeight(stringBounder) - this.roundCorner / 2.0);
        polygon.arcTo(new Point2D.Double(this.roundCorner / 2.0, this.getHeight(stringBounder)), this.roundCorner / 2.0, 0.0, 0.0);
        polygon.lineTo(this.getWidth(stringBounder) - this.roundCorner / 2.0, this.getHeight(stringBounder));
        polygon.arcTo(new Point2D.Double(this.getWidth(stringBounder), this.getHeight(stringBounder) - this.roundCorner / 2.0), this.roundCorner / 2.0, 0.0, 0.0);
        polygon.lineTo(this.getWidth(stringBounder), 10.0);
        polygon.lineTo(this.getWidth(stringBounder) - 10.0, 0.0);
        polygon.lineTo(this.roundCorner / 2.0, 0.0);
        polygon.arcTo(new Point2D.Double(0.0, this.roundCorner / 2.0), this.roundCorner / 2.0, 0.0, 0.0);
        polygon.closePath();
        return polygon;
    }

    private UPath getPolygonRight(StringBounder stringBounder, Point2D pp1, Point2D pp2) {
        UPath polygon = new UPath();
        polygon.moveTo(0.0, this.roundCorner / 2.0);
        polygon.lineTo(0.0, this.getHeight(stringBounder) - this.roundCorner / 2.0);
        polygon.arcTo(new Point2D.Double(this.roundCorner / 2.0, this.getHeight(stringBounder)), this.roundCorner / 2.0, 0.0, 0.0);
        polygon.lineTo(this.getWidth(stringBounder) - this.roundCorner / 2.0, this.getHeight(stringBounder));
        polygon.arcTo(new Point2D.Double(this.getWidth(stringBounder), this.getHeight(stringBounder) - this.roundCorner / 2.0), this.roundCorner / 2.0, 0.0, 0.0);
        double y1 = pp1.getY() - 4.0;
        y1 = MathUtils.limitation(y1, 10.0, this.getHeight(stringBounder) - 8.0);
        polygon.lineTo(this.getWidth(stringBounder), y1 + 8.0);
        polygon.lineTo(pp2.getX(), pp2.getY());
        polygon.lineTo(this.getWidth(stringBounder), y1);
        polygon.lineTo(this.getWidth(stringBounder), 10.0);
        polygon.lineTo(this.getWidth(stringBounder) - 10.0, 0.0);
        polygon.lineTo(this.roundCorner / 2.0, 0.0);
        polygon.arcTo(new Point2D.Double(0.0, this.roundCorner / 2.0), this.roundCorner / 2.0, 0.0, 0.0);
        polygon.closePath();
        return polygon;
    }

    private UPath getPolygonUp(StringBounder stringBounder, Point2D pp1, Point2D pp2) {
        UPath polygon = new UPath();
        polygon.moveTo(0.0, this.roundCorner / 2.0);
        polygon.lineTo(0.0, this.getHeight(stringBounder) - this.roundCorner / 2.0);
        polygon.arcTo(new Point2D.Double(this.roundCorner / 2.0, this.getHeight(stringBounder)), this.roundCorner / 2.0, 0.0, 0.0);
        polygon.lineTo(this.getWidth(stringBounder) - this.roundCorner / 2.0, this.getHeight(stringBounder));
        polygon.arcTo(new Point2D.Double(this.getWidth(stringBounder), this.getHeight(stringBounder) - this.roundCorner / 2.0), this.roundCorner / 2.0, 0.0, 0.0);
        polygon.lineTo(this.getWidth(stringBounder), 10.0);
        polygon.lineTo(this.getWidth(stringBounder) - 10.0, 0.0);
        double x1 = pp1.getX() - 4.0;
        x1 = MathUtils.limitation(x1, 0.0, this.getWidth(stringBounder) - 10.0);
        polygon.lineTo(x1 + 8.0, 0.0);
        polygon.lineTo(pp2.getX(), pp2.getY());
        polygon.lineTo(x1, 0.0);
        polygon.lineTo(this.roundCorner / 2.0, 0.0);
        polygon.arcTo(new Point2D.Double(0.0, this.roundCorner / 2.0), this.roundCorner / 2.0, 0.0, 0.0);
        polygon.closePath();
        return polygon;
    }

    private UPath getPolygonDown(StringBounder stringBounder, Point2D pp1, Point2D pp2) {
        UPath polygon = new UPath();
        polygon.moveTo(0.0, this.roundCorner / 2.0);
        polygon.lineTo(0.0, this.getHeight(stringBounder) - this.roundCorner / 2.0);
        polygon.arcTo(new Point2D.Double(this.roundCorner / 2.0, this.getHeight(stringBounder)), this.roundCorner / 2.0, 0.0, 0.0);
        double x1 = pp1.getX() - 4.0;
        x1 = MathUtils.limitation(x1, 0.0, this.getWidth(stringBounder));
        polygon.lineTo(x1, this.getHeight(stringBounder));
        polygon.lineTo(pp2.getX(), pp2.getY());
        polygon.lineTo(x1 + 8.0, this.getHeight(stringBounder));
        polygon.lineTo(this.getWidth(stringBounder) - this.roundCorner / 2.0, this.getHeight(stringBounder));
        polygon.arcTo(new Point2D.Double(this.getWidth(stringBounder), this.getHeight(stringBounder) - this.roundCorner / 2.0), this.roundCorner / 2.0, 0.0, 0.0);
        polygon.lineTo(this.getWidth(stringBounder), 10.0);
        polygon.lineTo(this.getWidth(stringBounder) - 10.0, 0.0);
        polygon.lineTo(this.roundCorner / 2.0, 0.0);
        polygon.arcTo(new Point2D.Double(0.0, this.roundCorner / 2.0), this.roundCorner / 2.0, 0.0, 0.0);
        polygon.closePath();
        return polygon;
    }

    public final int getMarginX1() {
        return 6;
    }
}

