/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.Positionner2;
import net.sourceforge.plantuml.salt.element.ElementPyramid;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.salt.factory.ScrollStrategy;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementPyramidScrolled
extends ElementPyramid {
    private final double v1 = 15.0;
    private final double v2 = 12.0;
    private final ScrollStrategy scrollStrategy;

    public ElementPyramidScrolled(Positionner2 positionner, ISkinSimple spriteContainer, ScrollStrategy scrollStrategy) {
        super(positionner, TableStrategy.DRAW_OUTSIDE, null, spriteContainer);
        this.scrollStrategy = scrollStrategy;
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        Dimension2D result = super.getPreferredDimension(stringBounder, x, y);
        if (this.scrollStrategy == ScrollStrategy.HORIZONTAL_ONLY) {
            return Dimension2DDouble.delta(result, 0.0, 30.0);
        }
        if (this.scrollStrategy == ScrollStrategy.VERTICAL_ONLY) {
            return Dimension2DDouble.delta(result, 30.0, 0.0);
        }
        return Dimension2DDouble.delta(result, 30.0);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        super.drawU(ug, zIndex, dimToUse);
        Dimension2D dim = super.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        if (this.scrollStrategy == ScrollStrategy.BOTH || this.scrollStrategy == ScrollStrategy.VERTICAL_ONLY) {
            this.drawV(ug.apply(new UTranslate(dim.getWidth() + 4.0, 0.0)), 15.0, dim.getHeight());
        }
        if (this.scrollStrategy == ScrollStrategy.BOTH || this.scrollStrategy == ScrollStrategy.HORIZONTAL_ONLY) {
            this.drawH(ug.apply(new UTranslate(0.0, dim.getHeight() + 4.0)), dim.getWidth(), 15.0);
        }
    }

    private UPath getTr0() {
        UPath poly = new UPath();
        poly.moveTo(3.0, 0.0);
        poly.lineTo(6.0, 5.0);
        poly.lineTo(0.0, 5.0);
        poly.lineTo(3.0, 0.0);
        poly.closePath();
        return poly;
    }

    private UPath getTr180() {
        UPath poly = new UPath();
        poly.moveTo(3.0, 5.0);
        poly.lineTo(6.0, 0.0);
        poly.lineTo(0.0, 0.0);
        poly.lineTo(3.0, 5.0);
        poly.closePath();
        return poly;
    }

    private UPath getTr90() {
        UPath poly = new UPath();
        poly.moveTo(0.0, 3.0);
        poly.lineTo(5.0, 6.0);
        poly.lineTo(5.0, 0.0);
        poly.lineTo(0.0, 3.0);
        poly.closePath();
        return poly;
    }

    private UPath getTr270() {
        UPath poly = new UPath();
        poly.moveTo(5.0, 3.0);
        poly.lineTo(0.0, 6.0);
        poly.lineTo(0.0, 0.0);
        poly.lineTo(5.0, 3.0);
        poly.closePath();
        return poly;
    }

    private void drawV(UGraphic ug, double width, double height) {
        ug.draw(new URectangle(width, height));
        ug.apply(new UTranslate(0.0, 12.0)).draw(new ULine(width, 0.0));
        ug.apply(new UTranslate(0.0, height - 12.0)).draw(new ULine(width, 0.0));
        ug.apply(new UTranslate(4.0, 4.0)).apply(new UChangeBackColor(HtmlColorUtils.BLACK)).draw(this.getTr0());
        ug.apply(new UTranslate(4.0, height - 12.0 + 4.0)).apply(new UChangeBackColor(HtmlColorUtils.BLACK)).draw(this.getTr180());
    }

    private void drawH(UGraphic ug, double width, double height) {
        ug.draw(new URectangle(width, height));
        ug.apply(new UTranslate(12.0, 0.0)).draw(new ULine(0.0, height));
        ug.apply(new UTranslate(width - 12.0, 0.0)).draw(new ULine(0.0, height));
        ug.apply(new UTranslate(4.0, 4.0)).apply(new UChangeBackColor(HtmlColorUtils.BLACK)).draw(this.getTr90());
        ug.apply(new UTranslate(width - 12.0 + 4.0, 4.0)).apply(new UChangeBackColor(HtmlColorUtils.BLACK)).draw(this.getTr270());
    }
}

