/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileOverpassing;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class FtileDiamondInside3
extends AbstractFtile
implements FtileOverpassing {
    private final HtmlColor backColor;
    private final HtmlColor borderColor;
    private final Swimlane swimlane;
    private final TextBlock label;
    private final TextBlock west;
    private final TextBlock east;
    private final TextBlock north;
    private final TextBlock south;

    public FtileDiamondInside3(ISkinParam skinParam, HtmlColor backColor, HtmlColor borderColor, Swimlane swimlane, TextBlock label) {
        this(skinParam, backColor, borderColor, swimlane, label, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamondInside3 withNorth(TextBlock north) {
        return new FtileDiamondInside3(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, north, this.south, this.west, this.east);
    }

    public FtileDiamondInside3 withWest(TextBlock west) {
        return new FtileDiamondInside3(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, this.south, west, this.east);
    }

    public FtileDiamondInside3 withEast(TextBlock east) {
        return new FtileDiamondInside3(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, this.south, this.west, east);
    }

    public FtileDiamondInside3 withSouth(TextBlock south) {
        return new FtileDiamondInside3(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, south, this.west, this.east);
    }

    private FtileDiamondInside3(ISkinParam skinParam, HtmlColor backColor, HtmlColor borderColor, Swimlane swimlane, TextBlock label, TextBlock north, TextBlock south, TextBlock west, TextBlock east) {
        super(skinParam);
        this.backColor = backColor;
        this.swimlane = swimlane;
        this.borderColor = borderColor;
        this.label = label;
        this.west = west;
        this.east = east;
        this.north = north;
        this.south = south;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimLabel = this.label.calculateDimension(stringBounder);
        FtileGeometry dimTotal = this.calculateDimensionAlone(stringBounder);
        ug = ug.apply(new UChangeColor(this.borderColor)).apply(this.getThickness()).apply(new UChangeBackColor(this.backColor));
        double shadowing = this.skinParam().shadowing(null) ? 3.0 : 0.0;
        ug.draw(Diamond.asPolygon(shadowing, ((Dimension2D)dimTotal).getWidth(), ((Dimension2D)dimTotal).getHeight()));
        this.north.drawU(ug.apply(new UTranslate(4.0 + ((Dimension2D)dimTotal).getWidth() / 2.0, ((Dimension2D)dimTotal).getHeight())));
        this.south.drawU(ug.apply(new UTranslate(4.0 + ((Dimension2D)dimTotal).getWidth() / 2.0, ((Dimension2D)dimTotal).getHeight())));
        double lx = (((Dimension2D)dimTotal).getWidth() - dimLabel.getWidth()) / 2.0;
        double ly = (((Dimension2D)dimTotal).getHeight() - dimLabel.getHeight()) / 2.0;
        this.label.drawU(ug.apply(new UTranslate(lx, ly)));
        Dimension2D dimWeat = this.west.calculateDimension(stringBounder);
        this.west.drawU(ug.apply(new UTranslate(-dimWeat.getWidth(), -dimWeat.getHeight() + ((Dimension2D)dimTotal).getHeight() / 2.0)));
        Dimension2D dimEast = this.east.calculateDimension(stringBounder);
        this.east.drawU(ug.apply(new UTranslate(((Dimension2D)dimTotal).getWidth(), -dimEast.getHeight() + ((Dimension2D)dimTotal).getHeight() / 2.0)));
    }

    private FtileGeometry calculateDimensionAlone(StringBounder stringBounder) {
        Dimension2D dimLabel = this.label.calculateDimension(stringBounder);
        Dimension2D dim = dimLabel.getWidth() == 0.0 || dimLabel.getHeight() == 0.0 ? new Dimension2DDouble(24.0, 24.0) : Dimension2DDouble.delta(Dimension2DDouble.atLeast(dimLabel, 24.0, 24.0), 24.0, 0.0);
        return new FtileGeometry(dim, dim.getWidth() / 2.0, 0.0, dim.getHeight());
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry diamond = this.calculateDimensionAlone(stringBounder);
        Dimension2D north = this.north.calculateDimension(stringBounder);
        double height = ((Dimension2D)diamond).getHeight() + north.getHeight();
        double left = ((Dimension2D)diamond).getWidth() / 2.0;
        double width = ((Dimension2D)diamond).getWidth();
        return new FtileGeometry(width, height, left, 0.0, ((Dimension2D)diamond).getHeight());
    }

    @Override
    public FtileGeometry getOverpassDimension(StringBounder stringBounder) {
        FtileGeometry total = this.calculateDimension(stringBounder);
        Dimension2D north = this.north.calculateDimension(stringBounder);
        Dimension2D east = this.east.calculateDimension(stringBounder);
        Dimension2D west = this.west.calculateDimension(stringBounder);
        double height = ((Dimension2D)total).getHeight();
        double left = ((Dimension2D)total).getWidth() / 2.0;
        double supp = MathUtils.max(north.getWidth(), east.getWidth(), west.getWidth());
        double width = ((Dimension2D)total).getWidth() + supp;
        return new FtileGeometry(width, height, left, 0.0, ((Dimension2D)total).getHeight());
    }
}

