/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.comp;

import net.sourceforge.plantuml.graphic.UGraphicDelegator;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.comp.CompressionMode;
import net.sourceforge.plantuml.ugraphic.comp.CompressionTransform;

public class UGraphicCompressOnXorY
extends UGraphicDelegator {
    private final CompressionMode mode;
    private final CompressionTransform compressionTransform;
    private final UTranslate translate;

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new UGraphicCompressOnXorY(this.mode, this.getUg(), this.compressionTransform, this.translate.compose((UTranslate)change));
        }
        if (change instanceof UStroke || change instanceof UChangeBackColor || change instanceof UChangeColor) {
            return new UGraphicCompressOnXorY(this.mode, this.getUg().apply(change), this.compressionTransform, this.translate);
        }
        throw new UnsupportedOperationException();
    }

    public UGraphicCompressOnXorY(CompressionMode mode, UGraphic ug, CompressionTransform compressionTransform) {
        this(mode, ug, compressionTransform, new UTranslate());
    }

    private UGraphicCompressOnXorY(CompressionMode mode, UGraphic ug, CompressionTransform compressionTransform, UTranslate translate) {
        super(ug);
        this.mode = mode;
        this.compressionTransform = compressionTransform;
        this.translate = translate;
    }

    @Override
    public void draw(UShape shape) {
        URectangle rect;
        double x = this.translate.getDx();
        double y = this.translate.getDy();
        if (shape instanceof URectangle && (rect = (URectangle)shape).isIgnoreForCompression()) {
            if (this.mode == CompressionMode.ON_X) {
                double x2 = this.ct(x + rect.getWidth());
                shape = rect.withWidth(x2 - this.ct(x));
            } else {
                double y2 = this.ct(y + rect.getHeight());
                shape = rect.withHeight(y2 - this.ct(y));
            }
        }
        if (shape instanceof ULine) {
            this.drawLine(x, y, (ULine)shape);
        } else if (this.mode == CompressionMode.ON_X) {
            this.getUg().apply(new UTranslate(this.ct(x), y)).draw(shape);
        } else {
            this.getUg().apply(new UTranslate(x, this.ct(y))).draw(shape);
        }
    }

    private void drawLine(double x, double y, ULine shape) {
        if (this.mode == CompressionMode.ON_X) {
            this.drawLine(this.ct(x), y, this.ct(x + shape.getDX()), y + shape.getDY());
        } else {
            this.drawLine(x, this.ct(y), x + shape.getDX(), this.ct(y + shape.getDY()));
        }
    }

    private double ct(double v) {
        return this.compressionTransform.transform(v);
    }

    private void drawLine(double x1, double y1, double x2, double y2) {
        if (y1 > y2) {
            this.drawLine(x2, y2, x1, y1);
            return;
        }
        assert (y1 <= y2);
        this.getUg().apply(new UTranslate(x1, y1)).draw(new ULine(x2 - x1, y2 - y1));
    }
}

