/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LivingSpaces {
    private final Map<Participant, LivingSpace> all = new LinkedHashMap<Participant, LivingSpace>();

    public Collection<LivingSpace> values() {
        return this.all.values();
    }

    public void addConstraints(StringBounder stringBounder) {
        LivingSpace previous = null;
        for (LivingSpace current : this.all.values()) {
            if (previous != null) {
                Real point1 = previous.getPosD(stringBounder);
                Real point2 = current.getPosB();
                point2.ensureBiggerThan(point1.addFixed(10.0));
            }
            previous = current;
        }
    }

    public LivingSpace previous(LivingSpace element) {
        LivingSpace previous = null;
        for (LivingSpace current : this.all.values()) {
            if (current == element) {
                return previous;
            }
            previous = current;
        }
        return null;
    }

    public LivingSpace next(LivingSpace element) {
        Iterator<LivingSpace> it = this.all.values().iterator();
        while (it.hasNext()) {
            LivingSpace current = it.next();
            if (current != element || !it.hasNext()) continue;
            return it.next();
        }
        return null;
    }

    public Collection<Participant> participants() {
        return this.all.keySet();
    }

    public void put(Participant participant, LivingSpace livingSpace) {
        this.all.put(participant, livingSpace);
    }

    public LivingSpace get(Participant participant) {
        return this.all.get(participant);
    }

    public void drawHeads(UGraphic ug, Context2D context, VerticalAlignment verticalAlignment) {
        StringBounder stringBounder = ug.getStringBounder();
        double headHeight = this.getHeadHeight(stringBounder);
        for (LivingSpace livingSpace : this.values()) {
            double x = livingSpace.getPosB().getCurrentValue();
            double y = 0.0;
            if (verticalAlignment == VerticalAlignment.BOTTOM) {
                Dimension2D dimHead = livingSpace.getHeadPreferredDimension(stringBounder);
                y = headHeight - dimHead.getHeight();
            }
            livingSpace.drawHead(ug.apply(new UTranslate(x, y)), context, verticalAlignment, HorizontalAlignment.LEFT);
        }
    }

    public double getHeadHeight(StringBounder stringBounder) {
        double headHeight = 0.0;
        for (LivingSpace livingSpace : this.values()) {
            Dimension2D headDim = livingSpace.getHeadPreferredDimension(stringBounder);
            headHeight = Math.max(headHeight, headDim.getHeight());
        }
        return headHeight;
    }

    public void drawLifeLines(UGraphic ug, double height, Context2D context) {
        boolean i = false;
        for (LivingSpace livingSpace : this.values()) {
            double x = livingSpace.getPosC(ug.getStringBounder()).getCurrentValue();
            livingSpace.drawLineAndLiveBoxes(ug.apply(new UTranslate(x, 0.0)), height, context);
        }
    }

    public void delayOn(double y, double height) {
        for (LivingSpace livingSpace : this.values()) {
            livingSpace.delayOn(y, height);
        }
    }

    public int size() {
        return this.all.size();
    }
}

