/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseActiveLine
extends AbstractComponent {
    private final SymbolContext symbolContext;
    private final boolean closeUp;
    private final boolean closeDown;

    public ComponentRoseActiveLine(Style style, SymbolContext symbolContext, boolean closeUp, boolean closeDown, IHtmlColorSet set) {
        super(style);
        if (SkinParam.USE_STYLES()) {
            symbolContext = style.getSymbolContext(set);
        }
        this.symbolContext = symbolContext;
        this.closeUp = closeUp;
        this.closeDown = closeDown;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        StringBounder stringBounder = ug.getStringBounder();
        int x = (int)(dimensionToUse.getWidth() - this.getPreferredWidth(stringBounder)) / 2;
        URectangle rect = new URectangle(this.getPreferredWidth(stringBounder), dimensionToUse.getHeight());
        if (this.symbolContext.isShadowing()) {
            rect.setDeltaShadow(1.0);
        }
        ug = ug.apply(new UChangeColor(this.symbolContext.getForeColor()));
        if (this.closeUp && this.closeDown) {
            ug.apply(new UChangeBackColor(this.symbolContext.getBackColor())).apply(new UTranslate(x, 0.0)).draw(rect);
            return;
        }
        ug.apply(new UChangeBackColor(this.symbolContext.getBackColor())).apply(new UChangeColor(this.symbolContext.getBackColor())).apply(new UTranslate(x, 0.0)).draw(rect);
        ULine vline = new ULine(0.0, dimensionToUse.getHeight());
        ug.apply(new UTranslate(x, 0.0)).draw(vline);
        ug.apply(new UTranslate((double)x + this.getPreferredWidth(stringBounder), 0.0)).draw(vline);
        ULine hline = new ULine(this.getPreferredWidth(stringBounder), 0.0);
        if (this.closeUp) {
            ug.apply(new UTranslate(x, 0.0)).draw(hline);
        }
        if (this.closeDown) {
            ug.apply(new UTranslate(x, dimensionToUse.getHeight())).draw(hline);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 10.0;
    }
}

