/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityCircleCross
extends Extremity {
    private final double px;
    private final double py;
    private final Point2D dest;
    private final double radius = 7.0;

    @Override
    public Point2D somePoint() {
        return this.dest;
    }

    public ExtremityCircleCross(Point2D p1) {
        this.px = p1.getX() - 7.0;
        this.py = p1.getY() - 7.0;
        this.dest = new Point2D.Double(p1.getX(), p1.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UChangeBackColor(HtmlColorUtils.WHITE));
        ug.apply(new UStroke(1.5)).apply(new UTranslate(this.dest.getX() - 7.0, this.dest.getY() - 7.0)).draw(new UEllipse(14.0, 14.0));
        ExtremityCircleCross.drawLine(ug, 0.0, 0.0, this.getPointOnCircle(0.7853981633974483), this.getPointOnCircle(3.9269908169872414));
        ExtremityCircleCross.drawLine(ug, 0.0, 0.0, this.getPointOnCircle(-0.7853981633974483), this.getPointOnCircle(2.356194490192345));
    }

    private Point2D getPointOnCircle(double angle) {
        double x = this.px + 7.0 + 7.0 * Math.cos(angle);
        double y = this.py + 7.0 + 7.0 * Math.sin(angle);
        return new Point2D.Double(x, y);
    }

    private static void drawLine(UGraphic ug, double x, double y, Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

