/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.CommandCreoleImg;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;

public class CommandCreoleSprite
implements Command {
    private final Pattern2 pattern;
    private final IHtmlColorSet colorSet;

    private CommandCreoleSprite(IHtmlColorSet colorSet, String p) {
        this.pattern = MyPattern.cmpile(p);
        this.colorSet = colorSet;
    }

    public static Command create(IHtmlColorSet colorSet) {
        return new CommandCreoleSprite(colorSet, "^(?i)(\\<\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>)");
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String src = m.group(2);
        double scale = CommandCreoleImg.getScale(m.group(3), 1.0);
        String colorName = CommandCreoleImg.getColor(m.group(3));
        HtmlColor color = null;
        if (colorName != null) {
            color = this.colorSet.getColorIfValid(colorName);
        }
        stripe.addSprite(src, scale, color);
        return line.substring(m.group(1).length());
    }
}

