/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

public class CompositeDiagramShape
extends DiagramComponent {
    private static final boolean DEBUG = false;
    private ArrayList<DiagramShape> shapes = new ArrayList();

    public static void main(String[] args) {
    }

    public static DiagramComponent createFromBoundaryCells(TextGrid grid, CellSet boundaryCells, int cellWidth, int cellHeight) {
        return CompositeDiagramShape.createOpenFromBoundaryCells(grid, boundaryCells, cellWidth, cellHeight, false);
    }

    public static DiagramComponent createOpenFromBoundaryCells(TextGrid grid, CellSet boundaryCells, int cellWidth, int cellHeight, boolean allRound) {
        if (boundaryCells.getType(grid) != 1) {
            throw new IllegalArgumentException("This shape is closed and cannot be handled by this method");
        }
        if (boundaryCells.size() == 0) {
            return null;
        }
        CompositeDiagramShape compositeShape = new CompositeDiagramShape();
        TextGrid workGrid = new TextGrid(grid.getWidth(), grid.getHeight());
        grid.copyCellsTo(boundaryCells, workGrid);
        CellSet visitedCells = new CellSet();
        ArrayList<DiagramShape> shapes = new ArrayList<DiagramShape>(100);
        for (TextGrid.Cell cell : boundaryCells) {
            if (!workGrid.isLinesEnd(cell)) continue;
            CellSet nextCells = workGrid.followCell(cell);
            shapes.addAll(CompositeDiagramShape.growEdgesFromCell(workGrid, cellWidth, cellHeight, allRound, nextCells.getFirst(), cell, visitedCells));
            break;
        }
        boolean dashedShapeExists = false;
        for (DiagramShape shape : shapes) {
            if (!shape.isStrokeDashed()) continue;
            dashedShapeExists = true;
        }
        for (DiagramShape shape : shapes) {
            if (dashedShapeExists) {
                shape.setStrokeDashed(true);
            }
            compositeShape.addToShapes(shape);
        }
        return compositeShape;
    }

    private static List<DiagramShape> growEdgesFromCell(TextGrid workGrid, int cellWidth, int cellHeight, boolean allRound, TextGrid.Cell cell, TextGrid.Cell previousCell, CellSet visitedCells) {
        ArrayList<DiagramShape> result = new ArrayList<DiagramShape>(50);
        visitedCells.add(previousCell);
        DiagramShape shape = new DiagramShape();
        shape.addToPoints(CompositeDiagramShape.makePointForCell(previousCell, workGrid, cellWidth, cellHeight, allRound));
        if (workGrid.cellContainsDashedLineChar(previousCell)) {
            shape.setStrokeDashed(true);
        }
        boolean finished = false;
        while (!finished) {
            CellSet nextCells;
            visitedCells.add(cell);
            if (workGrid.isPointCell(cell)) {
                shape.addToPoints(CompositeDiagramShape.makePointForCell(cell, workGrid, cellWidth, cellHeight, allRound));
            }
            if (workGrid.cellContainsDashedLineChar(cell)) {
                shape.setStrokeDashed(true);
            }
            if (workGrid.isLinesEnd(cell)) {
                finished = true;
            }
            if ((nextCells = workGrid.followCell(cell, previousCell)).size() == 1) {
                previousCell = cell;
                cell = nextCells.getFirst();
                continue;
            }
            if (nextCells.size() <= 1) continue;
            finished = true;
            for (TextGrid.Cell nextCell : nextCells) {
                result.addAll(CompositeDiagramShape.growEdgesFromCell(workGrid, cellWidth, cellHeight, allRound, nextCell, cell, visitedCells));
            }
        }
        result.add(shape);
        return result;
    }

    public DiagramComponent connectLines() {
        CompositeDiagramShape result = new CompositeDiagramShape();
        ArrayList<DiagramShape> lines = new ArrayList<DiagramShape>();
        for (DiagramShape shape : this.shapes) {
            if (shape.getPoints().size() != 2) continue;
            lines.add(shape);
        }
        Iterator<DiagramShape> it = lines.iterator();
        while (it.hasNext()) {
            DiagramShape line1 = it.next();
            Iterator it2 = lines.iterator();
            while (it2.hasNext()) {
                DiagramShape line2 = it.next();
                ShapePoint commonPoint = null;
                ShapePoint line1UncommonPoint = null;
                ShapePoint line2UncommonPoint = null;
                if (line1.getPoint(0).equals(line2.getPoint(0))) {
                    commonPoint = line1.getPoint(0);
                    line1UncommonPoint = line1.getPoint(1);
                    line2UncommonPoint = line2.getPoint(1);
                }
                if (line1.getPoint(0).equals(line2.getPoint(1))) {
                    commonPoint = line1.getPoint(0);
                    line1UncommonPoint = line1.getPoint(1);
                    line2UncommonPoint = line2.getPoint(0);
                }
                if (line1.getPoint(1).equals(line2.getPoint(0))) {
                    commonPoint = line1.getPoint(1);
                    line1UncommonPoint = line1.getPoint(0);
                    line2UncommonPoint = line2.getPoint(1);
                }
                if (line1.getPoint(1).equals(line2.getPoint(1))) {
                    commonPoint = line1.getPoint(1);
                    line1UncommonPoint = line1.getPoint(0);
                    line2UncommonPoint = line2.getPoint(0);
                }
                if (commonPoint == null) continue;
            }
        }
        return result;
    }

    public void connectEndsToAnchors(TextGrid grid, Diagram diagram) {
        for (DiagramShape shape : this.shapes) {
            if (shape.isClosed()) continue;
            shape.connectEndsToAnchors(grid, diagram);
        }
    }

    private static DiagramShape makeLine(TextGrid grid, TextGrid.Cell start, TextGrid.Cell end, int cellWidth, int cellHeight) {
        int type;
        DiagramShape line = new DiagramShape();
        if (grid.isHorizontalLine(start)) {
            if (start.isWestOf(end)) {
                line.addToPoints(new ShapePoint(Diagram.getCellMinX(start, cellWidth), Diagram.getCellMidY(start, cellHeight)));
            } else {
                line.addToPoints(new ShapePoint(Diagram.getCellMaxX(start, cellWidth), Diagram.getCellMidY(start, cellHeight)));
            }
        } else if (grid.isVerticalLine(start)) {
            if (start.isNorthOf(end)) {
                line.addToPoints(new ShapePoint(Diagram.getCellMidX(start, cellWidth), Diagram.getCellMinY(start, cellHeight)));
            } else {
                line.addToPoints(new ShapePoint(Diagram.getCellMidX(start, cellWidth), Diagram.getCellMaxY(start, cellHeight)));
            }
        } else {
            type = grid.isRoundCorner(start) ? 1 : 0;
            line.addToPoints(new ShapePoint(Diagram.getCellMidX(start, cellWidth), Diagram.getCellMidY(start, cellHeight), type));
        }
        if (grid.isHorizontalLine(end)) {
            if (start.isWestOf(start)) {
                line.addToPoints(new ShapePoint(Diagram.getCellMinX(end, cellWidth), Diagram.getCellMidY(end, cellHeight)));
            } else {
                line.addToPoints(new ShapePoint(Diagram.getCellMaxX(end, cellWidth), Diagram.getCellMidY(end, cellHeight)));
            }
        } else if (grid.isVerticalLine(end)) {
            if (start.isNorthOf(start)) {
                line.addToPoints(new ShapePoint(Diagram.getCellMidX(end, cellWidth), Diagram.getCellMinY(end, cellHeight)));
            } else {
                line.addToPoints(new ShapePoint(Diagram.getCellMidX(end, cellWidth), Diagram.getCellMaxY(end, cellHeight)));
            }
        } else {
            type = grid.isRoundCorner(end) ? 1 : 0;
            line.addToPoints(new ShapePoint(Diagram.getCellMidX(end, cellWidth), Diagram.getCellMidY(end, cellHeight), type));
        }
        return line;
    }

    public void addToShapes(DiagramShape shape) {
        this.shapes.add(shape);
    }

    private Iterator getShapesIterator() {
        return this.shapes.iterator();
    }

    public void scale(float factor) {
        Iterator it = this.getShapesIterator();
        while (it.hasNext()) {
            DiagramShape shape = (DiagramShape)it.next();
            shape.scale(factor);
        }
    }

    public ArrayList getShapes() {
        return this.shapes;
    }
}

