/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleLoader;

public class CommandStyleImport
extends SingleLineCommand2<UmlDiagram> {
    public CommandStyleImport() {
        super(CommandStyleImport.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandStyleImport.class.getName(), RegexLeaf.start(), new RegexLeaf("\\<style"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\w+"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("="), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("[%q%g]?"), new RegexLeaf("PATH", "([^%q%g]*)"), new RegexLeaf("[%q%g]?"), new RegexLeaf("\\>"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(UmlDiagram diagram, LineLocation location, RegexResult arg) {
        String path = arg.get("PATH", 0);
        try {
            File f = FileSystem.getInstance().getFile(path);
            BlocLines lines = null;
            if (f.exists()) {
                lines = BlocLines.load(f, location);
            } else {
                InputStream internalIs = StyleLoader.class.getResourceAsStream("/skin/" + path);
                if (internalIs != null) {
                    lines = BlocLines.load(internalIs, location);
                }
            }
            if (lines == null) {
                return CommandExecutionResult.error("File does not exist: " + path);
            }
            StyleBuilder styleBuilder = diagram.getSkinParam().getCurrentStyleBuilder();
            for (Style modifiedStyle : StyleLoader.getDeclaredStyles(lines, styleBuilder)) {
                diagram.getSkinParam().muteStyle(modifiedStyle);
            }
        }
        catch (IOException e) {
            return CommandExecutionResult.error("File does not exist: " + path);
        }
        return CommandExecutionResult.ok();
    }
}

