/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import net.sourceforge.plantuml.SvgString;
import net.sourceforge.plantuml.math.ConverterSvg;
import net.sourceforge.plantuml.math.ScientificEquation;
import net.sourceforge.plantuml.math.TeXIconBuilder;

public class LatexBuilder
implements ScientificEquation {
    private final String tex;
    private Dimension2D dimension;

    public LatexBuilder(String tex) {
        this.tex = tex;
    }

    @Override
    public Dimension2D getDimension() {
        return this.dimension;
    }

    private Icon buildIcon(Color foregroundColor) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return new TeXIconBuilder(this.tex, foregroundColor).getIcon();
    }

    @Override
    public SvgString getSvg(double scale, Color foregroundColor, Color backgroundColor) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InstantiationException, IOException {
        Icon icon = this.buildIcon(foregroundColor);
        ConverterSvg converterSvg = new ConverterSvg(icon);
        String svg = converterSvg.getSvg(scale, true, backgroundColor);
        this.dimension = converterSvg.getDimension();
        return new SvgString(svg, scale);
    }

    @Override
    public BufferedImage getImage(double scale, Color foregroundColor, Color backgroundColor) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Icon icon = this.buildIcon(foregroundColor);
        BufferedImage image = new BufferedImage((int)((double)icon.getIconWidth() * scale), (int)((double)icon.getIconHeight() * scale), 2);
        Graphics2D g2 = image.createGraphics();
        g2.scale(scale, scale);
        if (backgroundColor != null) {
            g2.setColor(backgroundColor);
            g2.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        }
        icon.paintIcon(null, g2, 0, 0);
        return image;
    }

    @Override
    public String getSource() {
        return this.tex;
    }
}

