/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolArtifact
extends USymbol {
    USymbolArtifact() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.ARTIFACT;
    }

    private void drawArtifact(UGraphic ug, double widthTotal, double heightTotal, boolean shadowing, double roundCorner) {
        URectangle form = new URectangle(widthTotal, heightTotal, roundCorner, roundCorner);
        if (shadowing) {
            form.setDeltaShadow(4.0);
        }
        ug.draw(form);
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        double heightSymbol = 14.0;
        polygon.addPoint(0.0, 14.0);
        double widthSymbol = 12.0;
        polygon.addPoint(12.0, 14.0);
        int cornersize = 6;
        polygon.addPoint(12.0, 6.0);
        polygon.addPoint(6.0, 0.0);
        polygon.addPoint(0.0, 0.0);
        double xSymbol = widthTotal - 12.0 - 5.0;
        double ySymbol = 5.0;
        ug.apply(new UTranslate(xSymbol, 5.0)).draw(polygon);
        ug.apply(new UTranslate(xSymbol + 12.0 - 6.0, 5.0)).draw(new ULine(0.0, 6.0));
        ug.apply(new UTranslate(xSymbol + 12.0, 11.0)).draw(new ULine(-6.0, 0.0));
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 20.0, 13.0, 10.0);
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, USymbolArtifact.this.getRectangleStencil(dim), new UStroke());
                ug = symbolContext.apply(ug);
                USymbolArtifact.this.drawArtifact(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolArtifact.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolArtifact.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolArtifact.this.drawArtifact(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner());
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 2.0)));
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }
}

