/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import net.sourceforge.plantuml.dedication.TurningBytes;

public class DecoderInputStream
extends InputStream {
    private final TurningBytes message;
    private final TurningBytes sha;
    private final Random rnd;
    private final InputStream source;

    public DecoderInputStream(InputStream source, String s) {
        this.source = source;
        try {
            byte[] text = s.getBytes("UTF-8");
            byte[] key = DecoderInputStream.getSignatureSha512(text);
            this.rnd = new Random(this.getSeed(key));
            this.message = new TurningBytes(text);
            this.sha = new TurningBytes(key);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    private static byte[] getSignatureSha512(byte[] bytes) {
        try {
            MessageDigest msgDigest = MessageDigest.getInstance("SHA-512");
            msgDigest.update(bytes);
            return msgDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    private long getSeed(byte[] bytes) {
        long result = 17L;
        for (byte b : bytes) {
            result = result * 37L + (long)b;
        }
        return result;
    }

    private byte getNextByte() {
        return (byte)(this.rnd.nextInt() ^ this.message.nextByte() ^ this.sha.nextByte());
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public int read() throws IOException {
        int b = this.source.read();
        if (b == -1) {
            return -1;
        }
        b = (b ^ this.getNextByte()) & 0xFF;
        return b;
    }
}

