/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.plantuml.AFile;
import net.sourceforge.plantuml.AParentFolder;
import net.sourceforge.plantuml.AParentFolderRegular;

public class AFileRegular
implements AFile {
    private final File file;

    public String toString() {
        return "AFileRegular::" + this.file;
    }

    public AFileRegular(File file) {
        this.file = file;
    }

    @Override
    public InputStream open() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public boolean isOk() {
        return this.file.exists() && !this.file.isDirectory();
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AFileRegular)) {
            return false;
        }
        return this.file.equals(((AFileRegular)obj).file);
    }

    @Override
    public AParentFolder getParentFile() {
        return new AParentFolderRegular(this.file.getParentFile());
    }

    @Override
    public File getUnderlyingFile() {
        return this.file;
    }

    @Override
    public File getSystemFolder() throws IOException {
        return this.file.getParentFile().getCanonicalFile();
    }
}

