/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.timingdiagram.Clocks;
import net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.PlayerBinary;
import net.sourceforge.plantuml.timingdiagram.PlayerClock;
import net.sourceforge.plantuml.timingdiagram.TickInPlayer;
import net.sourceforge.plantuml.timingdiagram.TimeArrow;
import net.sourceforge.plantuml.timingdiagram.TimeMessage;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingFormat;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.TimingStyle;
import net.sourceforge.plantuml.timingdiagram.TitleStrategy;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimingDiagram
extends UmlDiagram
implements Clocks {
    private final Map<String, Player> players = new LinkedHashMap<String, Player>();
    private final Map<String, PlayerClock> clocks = new HashMap<String, PlayerClock>();
    private final List<TimeMessage> messages = new ArrayList<TimeMessage>();
    private final TimingRuler ruler = new TimingRuler(this.getSkinParam());
    private TimeTick now;
    private Player lastPlayer;
    private boolean drawTimeAxis = true;
    public static final double marginX1 = 5.0;
    private final double marginX2 = 5.0;

    private TitleStrategy getTitleStrategy() {
        return TitleStrategy.IN_FRAME;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Timing Diagram)");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.TIMING;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        double dpiFactor = 1.0;
        double margin = 10.0;
        ImageBuilder imageBuilder = new ImageBuilder(this.getSkinParam(), 1.0, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getWarningOrError(), 10.0, 10.0, this.getAnimation());
        TextBlockBackcolored result = this.getTextBlock();
        ISkinParam skinParam = this.getSkinParam();
        result = new AnnotatedWorker(this, skinParam, fileFormatOption.getDefaultStringBounder()).addAdd(result);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                TimingDiagram.this.drawInternal(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                UTranslate lastTranslate = TimingDiagram.this.getUTranslateForPlayer(null, stringBounder);
                double withBeforeRuler = TimingDiagram.this.getWithBeforeRuler(stringBounder);
                double totalWith = withBeforeRuler + TimingDiagram.this.ruler.getWidth() + 5.0 + 5.0;
                return new Dimension2DDouble(totalWith, lastTranslate.getDy() + TimingDiagram.this.ruler.getHeight(stringBounder));
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HtmlColor getBackcolor() {
                return null;
            }
        };
    }

    private void drawInternal(UGraphic ug) {
        this.ruler.ensureNotEmpty();
        StringBounder stringBounder = ug.getStringBounder();
        UTranslate lastTranslate = this.getUTranslateForPlayer(null, stringBounder);
        double withBeforeRuler = this.getWithBeforeRuler(stringBounder);
        double totalWith = withBeforeRuler + this.ruler.getWidth() + 5.0 + 5.0;
        ULine border = new ULine(0.0, lastTranslate.getDy());
        UStroke borderStroke = new UStroke(1.7);
        ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(borderStroke).draw(border);
        ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(borderStroke).apply(new UTranslate(totalWith, 0.0)).draw(border);
        ug = ug.apply(new UTranslate(5.0, 0.0));
        this.ruler.draw0(ug.apply(new UTranslate(withBeforeRuler, 0.0)), this.getUTranslateForPlayer(null, stringBounder).getDy());
        for (Player player : this.players.values()) {
            UGraphic playerUg = ug.apply(this.getUTranslateForPlayer(player, stringBounder));
            player.drawFrameTitle(playerUg);
            player.drawContent(playerUg.apply(new UTranslate(withBeforeRuler, 0.0)));
            player.drawLeftHeader(playerUg);
            playerUg.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(borderStroke).apply(new UTranslate(-5.0, 0.0)).draw(new ULine(totalWith, 0.0));
        }
        ug = ug.apply(new UTranslate(withBeforeRuler, 0.0));
        if (this.drawTimeAxis) {
            this.ruler.drawTimeAxis(ug.apply(lastTranslate));
        }
        for (TimeMessage timeMessage : this.messages) {
            this.drawMessages(ug, timeMessage);
        }
    }

    private double getWithBeforeRuler(StringBounder stringBounder) {
        double width = 0.0;
        for (Player player : this.players.values()) {
            width = Math.max(width, player.getWidthHeader(stringBounder));
        }
        return width;
    }

    private double getFirstColumnWidth(StringBounder stringBounder) {
        double width = 0.0;
        for (Player player : this.players.values()) {
            width = Math.max(width, player.getFirstColumnWidth(stringBounder));
        }
        return width;
    }

    private void drawMessages(UGraphic ug, TimeMessage message) {
        Player player1 = message.getPlayer1();
        Player player2 = message.getPlayer2();
        UTranslate translate1 = this.getUTranslateForPlayer(player1, ug.getStringBounder());
        UTranslate translate2 = this.getUTranslateForPlayer(player2, ug.getStringBounder());
        IntricatedPoint pt1 = player1.getTimeProjection(ug.getStringBounder(), message.getTick1());
        IntricatedPoint pt2 = player2.getTimeProjection(ug.getStringBounder(), message.getTick2());
        if (pt1 == null || pt2 == null) {
            return;
        }
        TimeArrow timeArrow = TimeArrow.create(pt1.translated(translate1), pt2.translated(translate2), message.getLabel(), this.getSkinParam(), message);
        timeArrow.drawU(ug);
    }

    public UTranslate getUTranslateForPlayer(Player candidat, StringBounder stringBounder) {
        double y = 0.0;
        for (Player player : this.players.values()) {
            if (candidat == player) {
                return new UTranslate(0.0, y);
            }
            y += player.getHeight(stringBounder);
        }
        if (candidat == null) {
            return new UTranslate(0.0, y);
        }
        throw new IllegalArgumentException();
    }

    public CommandExecutionResult createRobustConcise(String code, String full, TimingStyle type) {
        Player player = type.createPlayer(this.getTitleStrategy(), full, this.getSkinParam(), this.ruler);
        this.players.put(code, player);
        this.lastPlayer = player;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult createClock(String code, String full, int period, int pulse) {
        PlayerClock player = new PlayerClock(this.getTitleStrategy(), this.getSkinParam(), this.ruler, period, pulse);
        this.players.put(code, player);
        this.clocks.put(code, player);
        TimeTick tick = new TimeTick(new BigDecimal(period), TimingFormat.DECIMAL);
        this.ruler.addTime(tick);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult createBinary(String code, String full) {
        PlayerBinary player = new PlayerBinary(this.getTitleStrategy(), code, this.getSkinParam(), this.ruler);
        this.players.put(code, player);
        return CommandExecutionResult.ok();
    }

    public TimeMessage createTimeMessage(Player player1, TimeTick time1, Player player2, TimeTick time2, String label) {
        TimeMessage message = new TimeMessage(new TickInPlayer(player1, time1), new TickInPlayer(player2, time2), label);
        this.messages.add(message);
        return message;
    }

    public void addTime(TimeTick time) {
        this.now = time;
        this.ruler.addTime(time);
    }

    public void updateNow(TimeTick time) {
        this.now = time;
    }

    public Player getPlayer(String code) {
        return this.players.get(code);
    }

    @Override
    public TimeTick getNow() {
        return this.now;
    }

    @Override
    public TimeTick getClockValue(String clockName, int nb) {
        PlayerClock clock = this.clocks.get(clockName);
        if (clock == null) {
            return null;
        }
        return new TimeTick(new BigDecimal(nb * clock.getPeriod()), TimingFormat.DECIMAL);
    }

    public void setLastPlayer(Player player) {
        this.lastPlayer = player;
    }

    public Player getLastPlayer() {
        return this.lastPlayer;
    }

    public void scaleInPixels(long tick, long pixel) {
        this.ruler.scaleInPixels(tick, pixel);
    }

    public CommandExecutionResult hideTimeAxis() {
        this.drawTimeAxis = false;
        return CommandExecutionResult.ok();
    }
}

