/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.plantuml.Dimension2DDouble;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AsciiMathOld {
    private static final String ASCIIMATH_PARSER_JS_LOCATION = "/net/sourceforge/plantuml/math/";
    private static String JAVASCRIPT_CODE;
    private final Node mathML;
    private Dimension2D dim;

    public AsciiMathOld(String form) throws IOException, ScriptException, ParserConfigurationException, NoSuchMethodException {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
        engine.eval(JAVASCRIPT_CODE);
        Invocable inv = (Invocable)((Object)engine);
        Document dom = this.createDocument();
        this.mathML = (Node)inv.invokeFunction("plantuml", dom, form);
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        return document;
    }

    public String getSvg() throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Class<?> clConverter = Class.forName("net.sourceforge.jeuclid.converter.Converter");
        Method getInstance = clConverter.getMethod("getInstance", new Class[0]);
        Object conv = getInstance.invoke(null, new Object[0]);
        Method convert = clConverter.getMethod("convert", Node.class, OutputStream.class, String.class, Class.forName("net.sourceforge.jeuclid.LayoutContext"));
        this.dim = (Dimension2D)convert.invoke(conv, this.mathML, baos, "image/svg+xml", this.getLayout());
        return new String(baos.toByteArray());
    }

    public BufferedImage getImage() throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        Class<?> clConverter = Class.forName("net.sourceforge.jeuclid.converter.Converter");
        Method getInstance = clConverter.getMethod("getInstance", new Class[0]);
        Object conv = getInstance.invoke(null, new Object[0]);
        Method render = clConverter.getMethod("render", Node.class, Class.forName("net.sourceforge.jeuclid.LayoutContext"));
        BufferedImage result = (BufferedImage)render.invoke(conv, this.mathML, this.getLayout());
        this.dim = new Dimension2DDouble(result.getWidth(), result.getHeight());
        return result;
    }

    private Object getLayout() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, IllegalArgumentException, NoSuchFieldException, SecurityException {
        Class<?> clLayoutContextIml = Class.forName("net.sourceforge.jeuclid.context.LayoutContextImpl");
        Class<?> clParameter = Class.forName("net.sourceforge.jeuclid.context.Parameter");
        Method getDefaultLayoutContext = clLayoutContextIml.getMethod("getDefaultLayoutContext", new Class[0]);
        Object layoutContext = getDefaultLayoutContext.invoke(null, new Object[0]);
        Method setParameter = clLayoutContextIml.getMethod("setParameter", clParameter, Object.class);
        setParameter.invoke(layoutContext, clParameter.getDeclaredField("SCRIPTSIZEMULTIPLIER").get(null), Float.valueOf(2.0f));
        return layoutContext;
    }

    public Dimension2D getDimension() {
        return this.dim;
    }

    static {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(AsciiMathOld.class.getResourceAsStream("/net/sourceforge/plantuml/math/AsciiMathParser.js"), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String s = null;
            while ((s = br.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
            br.close();
            JAVASCRIPT_CODE = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

