/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.DayOfWeek;
import net.sourceforge.plantuml.project3.GCalendar;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.InstantDay;
import net.sourceforge.plantuml.project3.LoadPlanable;
import net.sourceforge.plantuml.project3.ResourceDraw;
import net.sourceforge.plantuml.project3.Subject;

public class Resource
implements Subject {
    private final String name;
    private ResourceDraw draw;
    private final Set<Instant> closed = new TreeSet<Instant>();
    private final Set<Instant> forcedOn = new TreeSet<Instant>();
    private final GCalendar calendar;
    private final Collection<DayOfWeek> closedDayOfWeek = EnumSet.noneOf(DayOfWeek.class);

    public Resource(String name, LoadPlanable loadPlanable, GCalendar calendar) {
        this.name = name;
        this.calendar = calendar;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        Resource other = (Resource)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ResourceDraw getResourceDraw() {
        return this.draw;
    }

    public void setTaskDraw(ResourceDraw draw) {
        this.draw = draw;
    }

    public boolean isClosedAt(Instant instant) {
        DayAsDate d;
        if (this.forcedOn.contains(instant)) {
            return false;
        }
        if (this.closedDayOfWeek.size() > 0 && this.calendar != null && this.closedDayOfWeek.contains((d = this.calendar.toDayAsDate((InstantDay)instant)).getDayOfWeek())) {
            return true;
        }
        return this.closed.contains(instant);
    }

    public void addCloseDay(Instant instant) {
        this.closed.add(instant);
    }

    public void addForceOnDay(Instant instant) {
        this.forcedOn.add(instant);
    }

    public void addCloseDay(DayOfWeek dayOfWeek) {
        this.closedDayOfWeek.add(dayOfWeek);
    }
}

