/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class TextBlockGeneric
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock textBlock;
    private final HtmlColor background;
    private final HtmlColor border;

    public TextBlockGeneric(TextBlock textBlock, HtmlColor background, HtmlColor border) {
        this.textBlock = textBlock;
        this.border = border;
        this.background = background;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return dim;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UChangeBackColor(this.background));
        ug = ug.apply(new UChangeColor(this.border));
        Dimension2D dim = this.calculateDimension(ug.getStringBounder());
        ug.apply(new UStroke(2.0, 2.0, 1.0)).draw(new URectangle(dim.getWidth(), dim.getHeight()));
        this.textBlock.drawU(ug);
    }
}

