/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.cute.ApolloniusSolver2;
import net.sourceforge.plantuml.cute.Balloon;
import net.sourceforge.plantuml.cute.Segment;
import net.sourceforge.plantuml.cute.Tension;
import net.sourceforge.plantuml.cute.TriangleCorner;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;

public class BetweenCorners {
    private final TriangleCorner corner1;
    private final TriangleCorner corner2;
    private final Tension tension;
    private Balloon inside1;
    private Balloon inside2;
    private Balloon contact;
    private Balloon apo;
    private Point2D apopt1;
    private Point2D apopt2;

    public BetweenCorners(TriangleCorner corner1, TriangleCorner corner2, Tension tension) {
        this.corner1 = corner1;
        this.corner2 = corner2;
        this.tension = tension;
        if (corner1.hasCurvation()) {
            this.inside1 = corner1.getBalloonInside();
        }
        if (corner2.hasCurvation()) {
            this.inside2 = corner2.getBalloonInside();
        }
        if (!tension.isNone()) {
            this.contact = new Balloon(this.getTensionPoint(), this.getLength() / 1000.0);
        }
        if (this.inside1 != null && this.inside2 != null && this.contact != null) {
            this.apo = ApolloniusSolver2.solveApollonius(this.inside1, this.inside2, this.contact, 1, 1, 1);
            this.apopt1 = this.apo.getPointOnCirclePassingByThisPoint(this.inside1.getCenter());
            this.apopt2 = this.apo.getPointOnCirclePassingByThisPoint(this.inside2.getCenter());
        }
    }

    public Point2D getPointJ() {
        if (!this.getCorner1().hasCurvation()) {
            return this.getCorner1().getO();
        }
        if (this.tension.isNone()) {
            return this.getCorner1().getOnSegmentA(this.getCorner1().getCurvation());
        }
        throw new UnsupportedOperationException();
    }

    public Point2D getPointK() {
        if (!this.getCorner1().hasCurvation()) {
            return this.getCorner1().getO();
        }
        if (this.tension.isNone()) {
            return this.getCorner1().getOnSegmentB(this.getCorner1().getCurvation());
        }
        throw new UnsupportedOperationException();
    }

    private double getBalloonRadius() {
        return this.getCorner1().getBalloonInside().getRadius();
    }

    public void initPath(UPath path) {
        if (this.apo != null) {
            path.moveTo(this.apopt2);
        } else {
            path.moveTo(this.getPointK());
        }
    }

    public void addToPath(UPath path, int swepFlag) {
        if (this.apo != null) {
            path.arcTo(this.apopt1, this.getCorner1().getBalloonInside().getRadius(), 0.0, 1.0);
            path.arcTo(this.apopt2, this.apo.getRadius(), 0.0, 1.0);
        } else {
            path.lineTo(this.getPointJ());
            if (this.getCorner1().hasCurvation()) {
                path.arcTo(this.getPointK(), this.getBalloonRadius(), 0.0, swepFlag);
            }
        }
    }

    public void debugMe(UGraphic ug) {
        if (!this.getCorner2().hasCurvation()) {
            return;
        }
        if (this.tension.isNone()) {
            return;
        }
        this.inside1.drawU(ug);
        this.inside2.drawU(ug);
        this.contact.drawU(ug);
        new Balloon(this.apopt1, 5.0).drawU(ug);
        new Balloon(this.apopt2, 5.0).drawU(ug);
        this.apo.drawU(ug);
    }

    private double getRadiusFuzzy1() {
        double a = this.getLength() / 2.0;
        double b = this.getTension().getValue();
        double radius = (a * a + b * b) / 2.0 / b;
        return radius;
    }

    private Segment getSegment() {
        return new Segment(this.getCorner1().getO(), this.getCorner2().getO());
    }

    private Point2D getTensionPoint() {
        return this.getSegment().getOrthoPoint(this.getTension().getValue());
    }

    private Segment getSegmentCross() {
        return new Segment(this.getCorner1().getCornerOrBalloonCenter(), this.getCorner2().getCornerOrBalloonCenter());
    }

    public Tension getTension() {
        return this.tension;
    }

    public TriangleCorner getCorner1() {
        return this.corner1;
    }

    public TriangleCorner getCorner2() {
        return this.corner2;
    }

    public double getLength() {
        return this.getSegment().getLength();
    }
}

