/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityDoubleLine
extends Extremity {
    private final Point2D contact;
    private final double angle;
    private final double lineHeight = 4.0;

    @Override
    public Point2D somePoint() {
        return this.contact;
    }

    public ExtremityDoubleLine(Point2D p1, double angle) {
        this.contact = new Point2D.Double(p1.getX(), p1.getY());
        this.angle = this.manageround(angle + 1.5707963267948966);
    }

    @Override
    public void drawU(UGraphic ug) {
        int xWing = 4;
        AffineTransform rotate = AffineTransform.getRotateInstance(this.angle);
        Point2D.Double firstLineTop = new Point2D.Double(-4.0, -4.0);
        Point2D.Double firstLineBottom = new Point2D.Double(-4.0, 4.0);
        Point2D.Double secondLineTop = new Point2D.Double(-7.0, -4.0);
        Point2D.Double secondLineBottom = new Point2D.Double(-7.0, 4.0);
        Point2D.Double middle = new Point2D.Double(0.0, 0.0);
        Point2D.Double base = new Point2D.Double(-8.0, 0.0);
        rotate.transform(middle, middle);
        rotate.transform(base, base);
        rotate.transform(firstLineTop, firstLineTop);
        rotate.transform(firstLineBottom, firstLineBottom);
        rotate.transform(secondLineTop, secondLineTop);
        rotate.transform(secondLineBottom, secondLineBottom);
        ExtremityDoubleLine.drawLine(ug, this.contact.getX(), this.contact.getY(), firstLineTop, firstLineBottom);
        ExtremityDoubleLine.drawLine(ug, this.contact.getX(), this.contact.getY(), secondLineTop, secondLineBottom);
        ExtremityDoubleLine.drawLine(ug, this.contact.getX(), this.contact.getY(), base, middle);
    }

    private static void drawLine(UGraphic ug, double x, double y, Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

