from __future__ import print_function, division, absolute_import

# Copyright (c) 2016 Red Hat, Inc.
#
# This software is licensed to you under the GNU General Public License,
# version 2 (GPLv2). There is NO WARRANTY for this software, express or
# implied, including the implied warranties of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. You should have received a copy of GPLv2
# along with this software; if not, see
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt.
#
# Red Hat trademarks are not licensed under GPLv2. No permission is
# granted to use or replicate Red Hat trademarks that are incorporated
# in this software or its documentation.
from mock import mock

from rhsmlib.dbus.facts.base import AllFacts

from test.rhsmlib_test.base import DBusServerStubProvider


class TestFactsDBusObject(DBusServerStubProvider):
    dbus_class = AllFacts
    dbus_class_kwargs = {}

    def setUp(self) -> None:
        get_virt_info_patch = mock.patch(
            "rhsmlib.facts.virt.VirtWhatCollector.get_virt_info",
            name="get_virt_info",
        )
        self.patches["get_virt_info"] = get_virt_info_patch.start()
        self.addCleanup(get_virt_info_patch.stop)

        self.patches["get_virt_info"].return_value = {"virt.is_guest": "Unknown"}

        super().setUp()

    def test_GetFacts(self):
        expected = "uname.machine"
        result = self.obj.GetFacts.__wrapped__(self.obj)
        self.assertIn(expected, result)
