#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xC1, 0x52, 0x91, 0xEE, 0xF0, 0xDF, 0xCB, 0x9C, 0x9A, 0xFA, 
	0xC4, 0x41, 0x27, 0x23, 0xEA, 0xD2, 0x93, 0xF2, 0x93, 0x6A, 
	0x54, 0xBF, 0xB1, 0xB6, 0xF3, 0x0F, 0x27, 0xF4, 0xD5, 0x68, 
	0x1F, 0x5A, 0xCF, 0xA0, 0x53, 0xC5, 0x40, 0x4E, 0xD8, 0x54, 
	0x5D, 0xC4, 0xE5, 0x16, 0x60, 0x5B, 0xEF, 0xB5, 0x36, 0x2D, 
	0x10, 0xB2, 0xE1, 0xC9, 0x14, 0xDE, 0xC3, 0x25, 0x3C, 0xD9, 
	0x04, 0x65, 0x71, 0x2E, 0xC7, 0x7E, 0x38, 0x6A, 0xC6, 0x1F, 
	0x7A, 0xF5, 0xC0, 0x9B, 0xD7, 0x42, 0xF9, 0x1D, 0xC1, 0xB2, 
	0xD9, 0x0D, 0x34, 0xF0, 0xF5, 0xD4, 0x5F, 0x66, 0x8B, 0x58, 
	0x7F, 0x91, 0xA5, 0x0B, 0xA2, 0x61, 0x1F, 0xD6, 0x71, 0xE9, 
	0x30, 0xE4, 0xB8, 0xCF, 0x8B, 0xED, 0x59, 0x32, 0x41, 0x85, 
	0xF5, 0xA9, 0x70, 0x5F, 0x7F, 0x47, 0x11, 0xDF, 0x92, 0xA4, 
	0xD4, 0x07, 0x72, 0x78, 0x75, 0xCE, 0x7B, 0xD7, 0xAB, 0x75, 
	0xAF, 0x9C, 0xC9, 0xE1, 0x94, 0xFF, 0xE3, 0x60, 0x9C, 0x8A, 
	0x4C, 0xC1, 0xF8, 0xEC, 0xEA, 0x7A, 0x90, 0x84, 0xD9, 0x31, 
	0x24, 0xE1, 0x6C, 0xAB, 0xF5, 0x3B, 0x91, 0x45, 0x59, 0x32, 
	0xE4, 0x43, 0x52, 0xD1, 0x4E, 0x9E, 0xC3, 0xC3, 0xD1, 0xEA, 
	0xCB, 0x60, 0x05, 0x9E, 0x75, 0xAD, 0x92, 0xD7, 0xBD, 0xA8, 
	0x05, 0x49, 0xC0, 0xAA, 0x5D, 0xE5, 0x02, 0x7D, 0xF9, 0x6C, 
	0x69, 0x21, 0xC9, 0x57, 0x7E, 0xE4, 0x09, 0x84, 0xA5, 0x0C, 
	0xF8, 0x86, 0xB9, 0x93, 0x7B, 0x67, 0x18, 0x43, 0x9C, 0xB7, 
	0x8B, 0xE3, 0xD2, 0xCD, 0x90, 0x45, 0x83, 0xD7, 0xA9, 0x77, 
	0x6C, 0xD8, 0x2A, 0x0D, 0x7B, 0xB6, 0xBB, 0xEE, 0xAA, 0xFE, 
	0xCE, 0x18, 0x41, 0x67, 0x81, 0x0A, 0xB4, 0x77, 0x36, 0xFE, 
	0x5A, 0x0E, 0x4F, 0x14, 0x9F, 0x40, 0x20, 0x92, 0xE4, 0x40, 
	0x9A, 0x41, 0x3A, 0x42, 0xCE, 0x2B
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
