/*
    Generated by sbus code generator

    Copyright (C) 2017 Red Hat

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <errno.h>
#include <talloc.h>
#include <dbus/dbus.h>

#include "sbus/sbus_sync.h"
#include "sbus/sbus_sync_private.h"
#include "sbus/sbus_message.h"
#include "sbus/interface/sbus_iterator_readers.h"
#include "sbus/interface_dbus/sbus_dbus_client_sync.h"
#include "responder/ifp/ifp_iface/sbus_ifp_arguments.h"
#include "responder/ifp/ifp_iface/sbus_ifp_client_properties.h"

static errno_t
sbus_method_in__out_
    (struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method)
{
    TALLOC_CTX *tmp_ctx;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }


    ret = sbus_sync_call_method(tmp_ctx, conn, NULL, NULL,
                                bus, path, iface, method, NULL, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in__out_ao
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char *** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_ao *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_ao);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }


    ret = sbus_sync_call_method(tmp_ctx, conn, NULL, NULL,
                                bus, path, iface, method, NULL, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_ao, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in__out_as
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char *** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_as *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_as);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }


    ret = sbus_sync_call_method(tmp_ctx, conn, NULL, NULL,
                                bus, path, iface, method, NULL, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_as, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in__out_b
    (struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     bool* _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_b *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_b);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }


    ret = sbus_sync_call_method(tmp_ctx, conn, NULL, NULL,
                                bus, path, iface, method, NULL, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_b, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = out->arg0;

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in__out_o
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char ** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_o *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_o);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }


    ret = sbus_sync_call_method(tmp_ctx, conn, NULL, NULL,
                                bus, path, iface, method, NULL, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_o, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_s_out_ao
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     const char *** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_s in;
    struct _sbus_ifp_invoker_args_ao *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_ao);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    in.arg0 = arg0;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_ifp_invoker_write_s,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_ao, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_s_out_as
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     const char *** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_s in;
    struct _sbus_ifp_invoker_args_as *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_as);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    in.arg0 = arg0;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_ifp_invoker_write_s,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_as, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_s_out_o
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     const char ** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_s in;
    struct _sbus_ifp_invoker_args_o *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_o);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    in.arg0 = arg0;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_ifp_invoker_write_s,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_o, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_s_out_s
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     const char ** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_s in;
    struct _sbus_ifp_invoker_args_s *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_s);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    in.arg0 = arg0;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_ifp_invoker_write_s,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_s, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_sas_out_raw
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     const char ** arg1,
     DBusMessage **_reply)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_sas in;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    in.arg0 = arg0;
    in.arg1 = arg1;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_ifp_invoker_write_sas,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    /* Bounded reference cannot be unreferenced with dbus_message_unref.
     * For that reason we do not allow NULL memory context as it would
     * result in leaking the message memory. */
    if (mem_ctx == NULL) {
        ret = EINVAL;
        goto done;
    }

    ret = sbus_message_bound_ref(mem_ctx, reply);
    if (ret != EOK) {
        DEBUG(SSSDBG_CRIT_FAILURE, "Unable to bound message [%d]: %s\n",
              ret, sss_strerror(ret));
        goto done;
    }

    *_reply = reply;

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_ss_out_o
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     const char * arg1,
     const char ** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_ss in;
    struct _sbus_ifp_invoker_args_o *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_o);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    in.arg0 = arg0;
    in.arg1 = arg1;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_ifp_invoker_write_ss,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_o, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_ssu_out_ao
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     const char * arg1,
     uint32_t arg2,
     const char *** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_ssu in;
    struct _sbus_ifp_invoker_args_ao *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_ao);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    in.arg0 = arg0;
    in.arg1 = arg1;
    in.arg2 = arg2;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_ifp_invoker_write_ssu,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_ao, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_su_out_ao
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     const char * arg0,
     uint32_t arg1,
     const char *** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_su in;
    struct _sbus_ifp_invoker_args_ao *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_ao);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    in.arg0 = arg0;
    in.arg1 = arg1;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_ifp_invoker_write_su,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_ao, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_method_in_u_out_o
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *method,
     uint32_t arg0,
     const char ** _arg0)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_u in;
    struct _sbus_ifp_invoker_args_o *out;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_o);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    in.arg0 = arg0;

    ret = sbus_sync_call_method(tmp_ctx, conn, NULL,
                                (sbus_invoker_writer_fn)_sbus_ifp_invoker_write_u,
                                bus, path, iface, method, &in, &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_read_output(out, reply, (sbus_invoker_reader_fn)_sbus_ifp_invoker_read_o, out);
    if (ret != EOK) {
        goto done;
    }

    *_arg0 = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

errno_t
sbus_call_ifp_FindBackendByName
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name,
     const char ** _arg_backend)
{
     return sbus_method_in_s_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "FindBackendByName", arg_name,
          _arg_backend);
}

errno_t
sbus_call_ifp_FindDomainByName
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name,
     const char ** _arg_domain)
{
     return sbus_method_in_s_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "FindDomainByName", arg_name,
          _arg_domain);
}

errno_t
sbus_call_ifp_FindMonitor
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _arg_monitor)
{
     return sbus_method_in__out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "FindMonitor",
          _arg_monitor);
}

errno_t
sbus_call_ifp_FindResponderByName
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name,
     const char ** _arg_responder)
{
     return sbus_method_in_s_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "FindResponderByName", arg_name,
          _arg_responder);
}

errno_t
sbus_call_ifp_GetUserAttr
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_user,
     const char ** arg_attr,
     DBusMessage **_reply)
{
     return sbus_method_in_sas_out_raw(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "GetUserAttr", arg_user, arg_attr,
          _reply);
}

errno_t
sbus_call_ifp_GetUserGroups
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_user,
     const char *** _arg_values)
{
     return sbus_method_in_s_out_as(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "GetUserGroups", arg_user,
          _arg_values);
}

errno_t
sbus_call_ifp_ListBackends
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _arg_backends)
{
     return sbus_method_in__out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "ListBackends",
          _arg_backends);
}

errno_t
sbus_call_ifp_ListComponents
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _arg_components)
{
     return sbus_method_in__out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "ListComponents",
          _arg_components);
}

errno_t
sbus_call_ifp_ListDomains
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _arg_domain)
{
     return sbus_method_in__out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "ListDomains",
          _arg_domain);
}

errno_t
sbus_call_ifp_ListResponders
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _arg_responders)
{
     return sbus_method_in__out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "ListResponders",
          _arg_responders);
}

errno_t
sbus_call_ifp_Ping
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_ping,
     const char ** _arg_pong)
{
     return sbus_method_in_s_out_s(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe", "Ping", arg_ping,
          _arg_pong);
}

errno_t
sbus_call_ifp_cache_List
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _arg_result)
{
     return sbus_method_in__out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Cache", "List",
          _arg_result);
}

errno_t
sbus_call_ifp_cache_ListByDomain
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_domain_name,
     const char *** _arg_result)
{
     return sbus_method_in_s_out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Cache", "ListByDomain", arg_domain_name,
          _arg_result);
}

errno_t
sbus_call_ifp_cache_object_Remove
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     bool* _arg_result)
{
     return sbus_method_in__out_b(conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Cache.Object", "Remove",
          _arg_result);
}

errno_t
sbus_call_ifp_cache_object_Store
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     bool* _arg_result)
{
     return sbus_method_in__out_b(conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Cache.Object", "Store",
          _arg_result);
}

errno_t
sbus_call_ifp_domain_ActiveServer
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_service,
     const char ** _arg_server)
{
     return sbus_method_in_s_out_s(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Domains.Domain", "ActiveServer", arg_service,
          _arg_server);
}

errno_t
sbus_call_ifp_domain_IsOnline
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     bool* _arg_status)
{
     return sbus_method_in__out_b(conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Domains.Domain", "IsOnline",
          _arg_status);
}

errno_t
sbus_call_ifp_domain_ListServers
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_service_name,
     const char *** _arg_servers)
{
     return sbus_method_in_s_out_as(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Domains.Domain", "ListServers", arg_service_name,
          _arg_servers);
}

errno_t
sbus_call_ifp_domain_ListServices
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _arg_services)
{
     return sbus_method_in__out_as(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Domains.Domain", "ListServices",
          _arg_services);
}

errno_t
sbus_call_ifp_domain_RefreshAccessRules
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path)
{
     return sbus_method_in__out_(conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Domains.Domain", "RefreshAccessRules");
}

errno_t
sbus_call_ifp_groups_FindByID
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_id,
     const char ** _arg_result)
{
     return sbus_method_in_u_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Groups", "FindByID", arg_id,
          _arg_result);
}

errno_t
sbus_call_ifp_groups_FindByName
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name,
     const char ** _arg_result)
{
     return sbus_method_in_s_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Groups", "FindByName", arg_name,
          _arg_result);
}

errno_t
sbus_call_ifp_groups_ListByDomainAndName
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_domain_name,
     const char * arg_name_filter,
     uint32_t arg_limit,
     const char *** _arg_result)
{
     return sbus_method_in_ssu_out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Groups", "ListByDomainAndName", arg_domain_name, arg_name_filter, arg_limit,
          _arg_result);
}

errno_t
sbus_call_ifp_groups_ListByName
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name_filter,
     uint32_t arg_limit,
     const char *** _arg_result)
{
     return sbus_method_in_su_out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Groups", "ListByName", arg_name_filter, arg_limit,
          _arg_result);
}

errno_t
sbus_call_ifp_group_UpdateMemberList
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path)
{
     return sbus_method_in__out_(conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Groups.Group", "UpdateMemberList");
}

errno_t
sbus_call_ifp_users_FindByCertificate
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_pem_cert,
     const char ** _arg_result)
{
     return sbus_method_in_s_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Users", "FindByCertificate", arg_pem_cert,
          _arg_result);
}

errno_t
sbus_call_ifp_users_FindByID
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t arg_id,
     const char ** _arg_result)
{
     return sbus_method_in_u_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Users", "FindByID", arg_id,
          _arg_result);
}

errno_t
sbus_call_ifp_users_FindByName
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name,
     const char ** _arg_result)
{
     return sbus_method_in_s_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Users", "FindByName", arg_name,
          _arg_result);
}

errno_t
sbus_call_ifp_users_FindByNameAndCertificate
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name,
     const char * arg_pem_cert,
     const char ** _arg_result)
{
     return sbus_method_in_ss_out_o(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Users", "FindByNameAndCertificate", arg_name, arg_pem_cert,
          _arg_result);
}

errno_t
sbus_call_ifp_users_ListByCertificate
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_pem_cert,
     uint32_t arg_limit,
     const char *** _arg_result)
{
     return sbus_method_in_su_out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Users", "ListByCertificate", arg_pem_cert, arg_limit,
          _arg_result);
}

errno_t
sbus_call_ifp_users_ListByDomainAndName
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_domain_name,
     const char * arg_name_filter,
     uint32_t arg_limit,
     const char *** _arg_result)
{
     return sbus_method_in_ssu_out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Users", "ListByDomainAndName", arg_domain_name, arg_name_filter, arg_limit,
          _arg_result);
}

errno_t
sbus_call_ifp_users_ListByName
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char * arg_name_filter,
     uint32_t arg_limit,
     const char *** _arg_result)
{
     return sbus_method_in_su_out_ao(mem_ctx, conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Users", "ListByName", arg_name_filter, arg_limit,
          _arg_result);
}

errno_t
sbus_call_ifp_user_UpdateGroupsList
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path)
{
     return sbus_method_in__out_(conn,
          busname, object_path, "org.freedesktop.sssd.infopipe.Users.User", "UpdateGroupsList");
}

static errno_t
sbus_get_ao
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *property,
     const char *** _value)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_ao *out;
    sbus_value_reader_fn reader;
    sbus_value_reader_talloc_fn reader_talloc;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_ao);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    ret = sbus_call_DBusProperties_Get(tmp_ctx, conn,
              bus, path, iface, property, &reply);
    if (ret != EOK) {
        goto done;
    }

    reader = NULL;
    reader_talloc = (sbus_value_reader_talloc_fn)sbus_iterator_read_ao;
    ret = sbus_parse_get_message(out, reader, reader_talloc, reply, &out->arg0);
    if (ret != EOK) {
        goto done;
    }

    *_value = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_get_as
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *property,
     const char *** _value)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_as *out;
    sbus_value_reader_fn reader;
    sbus_value_reader_talloc_fn reader_talloc;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_as);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    ret = sbus_call_DBusProperties_Get(tmp_ctx, conn,
              bus, path, iface, property, &reply);
    if (ret != EOK) {
        goto done;
    }

    reader = NULL;
    reader_talloc = (sbus_value_reader_talloc_fn)sbus_iterator_read_as;
    ret = sbus_parse_get_message(out, reader, reader_talloc, reply, &out->arg0);
    if (ret != EOK) {
        goto done;
    }

    *_value = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_get_b
    (struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *property,
     bool* _value)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_b *out;
    sbus_value_reader_fn reader;
    sbus_value_reader_talloc_fn reader_talloc;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_b);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    ret = sbus_call_DBusProperties_Get(tmp_ctx, conn,
              bus, path, iface, property, &reply);
    if (ret != EOK) {
        goto done;
    }

    reader = (sbus_value_reader_fn)sbus_iterator_read_b;
    reader_talloc = NULL;
    ret = sbus_parse_get_message(out, reader, reader_talloc, reply, &out->arg0);
    if (ret != EOK) {
        goto done;
    }

    *_value = out->arg0;

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_get_ifp_extra
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *property,
     hash_table_t ** _value)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_ifp_extra *out;
    sbus_value_reader_fn reader;
    sbus_value_reader_talloc_fn reader_talloc;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_ifp_extra);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    ret = sbus_call_DBusProperties_Get(tmp_ctx, conn,
              bus, path, iface, property, &reply);
    if (ret != EOK) {
        goto done;
    }

    reader = NULL;
    reader_talloc = (sbus_value_reader_talloc_fn)sbus_iterator_read_ifp_extra;
    ret = sbus_parse_get_message(out, reader, reader_talloc, reply, &out->arg0);
    if (ret != EOK) {
        goto done;
    }

    *_value = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_get_o
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *property,
     const char ** _value)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_o *out;
    sbus_value_reader_fn reader;
    sbus_value_reader_talloc_fn reader_talloc;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_o);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    ret = sbus_call_DBusProperties_Get(tmp_ctx, conn,
              bus, path, iface, property, &reply);
    if (ret != EOK) {
        goto done;
    }

    reader = NULL;
    reader_talloc = (sbus_value_reader_talloc_fn)sbus_iterator_read_o;
    ret = sbus_parse_get_message(out, reader, reader_talloc, reply, &out->arg0);
    if (ret != EOK) {
        goto done;
    }

    *_value = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_get_s
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *property,
     const char ** _value)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_s *out;
    sbus_value_reader_fn reader;
    sbus_value_reader_talloc_fn reader_talloc;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_s);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    ret = sbus_call_DBusProperties_Get(tmp_ctx, conn,
              bus, path, iface, property, &reply);
    if (ret != EOK) {
        goto done;
    }

    reader = NULL;
    reader_talloc = (sbus_value_reader_talloc_fn)sbus_iterator_read_s;
    ret = sbus_parse_get_message(out, reader, reader_talloc, reply, &out->arg0);
    if (ret != EOK) {
        goto done;
    }

    *_value = talloc_steal(mem_ctx, out->arg0);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

static errno_t
sbus_get_u
    (struct sbus_sync_connection *conn,
     const char *bus,
     const char *path,
     const char *iface,
     const char *property,
     uint32_t* _value)
{
    TALLOC_CTX *tmp_ctx;
    struct _sbus_ifp_invoker_args_u *out;
    sbus_value_reader_fn reader;
    sbus_value_reader_talloc_fn reader_talloc;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    out = talloc_zero(tmp_ctx, struct _sbus_ifp_invoker_args_u);
    if (out == NULL) {
        DEBUG(SSSDBG_CRIT_FAILURE,
              "Unable to allocate space for output parameters!\n");
        ret = ENOMEM;
        goto done;
    }

    ret = sbus_call_DBusProperties_Get(tmp_ctx, conn,
              bus, path, iface, property, &reply);
    if (ret != EOK) {
        goto done;
    }

    reader = (sbus_value_reader_fn)sbus_iterator_read_u;
    reader_talloc = NULL;
    ret = sbus_parse_get_message(out, reader, reader_talloc, reply, &out->arg0);
    if (ret != EOK) {
        goto done;
    }

    *_value = out->arg0;

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

errno_t
sbus_get_ifp_components_debug_level
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t* _value)
{
    return sbus_get_u(conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Components", "debug_level", _value);
}

errno_t
sbus_get_ifp_components_enabled
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     bool* _value)
{
    return sbus_get_b(conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Components", "enabled", _value);
}

errno_t
sbus_get_ifp_components_name
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Components", "name", _value);
}

errno_t
sbus_get_ifp_components_providers
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _value)
{
    return sbus_get_as(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Components", "providers", _value);
}

errno_t
sbus_get_ifp_components_type
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Components", "type", _value);
}

errno_t
sbus_get_ifp_domains_backup_servers
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _value)
{
    return sbus_get_as(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "backup_servers", _value);
}

errno_t
sbus_get_ifp_domains_enumerable
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     bool* _value)
{
    return sbus_get_b(conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "enumerable", _value);
}

errno_t
sbus_get_ifp_domains_forest
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "forest", _value);
}

errno_t
sbus_get_ifp_domains_fully_qualified_name_format
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "fully_qualified_name_format", _value);
}

errno_t
sbus_get_ifp_domains_login_format
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "login_format", _value);
}

errno_t
sbus_get_ifp_domains_max_id
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t* _value)
{
    return sbus_get_u(conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "max_id", _value);
}

errno_t
sbus_get_ifp_domains_min_id
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t* _value)
{
    return sbus_get_u(conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "min_id", _value);
}

errno_t
sbus_get_ifp_domains_name
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "name", _value);
}

errno_t
sbus_get_ifp_domains_parent_domain
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_o(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "parent_domain", _value);
}

errno_t
sbus_get_ifp_domains_primary_servers
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _value)
{
    return sbus_get_as(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "primary_servers", _value);
}

errno_t
sbus_get_ifp_domains_provider
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "provider", _value);
}

errno_t
sbus_get_ifp_domains_realm
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "realm", _value);
}

errno_t
sbus_get_ifp_domains_subdomain
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     bool* _value)
{
    return sbus_get_b(conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "subdomain", _value);
}

errno_t
sbus_get_ifp_domains_use_fully_qualified_names
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     bool* _value)
{
    return sbus_get_b(conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Domains", "use_fully_qualified_names", _value);
}

errno_t
sbus_get_ifp_group_gidNumber
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t* _value)
{
    return sbus_get_u(conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Groups.Group", "gidNumber", _value);
}

errno_t
sbus_get_ifp_group_groups
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _value)
{
    return sbus_get_ao(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Groups.Group", "groups", _value);
}

errno_t
sbus_get_ifp_group_name
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Groups.Group", "name", _value);
}

errno_t
sbus_get_ifp_group_uniqueID
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Groups.Group", "uniqueID", _value);
}

errno_t
sbus_get_ifp_group_users
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _value)
{
    return sbus_get_ao(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Groups.Group", "users", _value);
}

errno_t
sbus_get_ifp_user_domain
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_o(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "domain", _value);
}

errno_t
sbus_get_ifp_user_domainname
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "domainname", _value);
}

errno_t
sbus_get_ifp_user_extraAttributes
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     hash_table_t ** _value)
{
    return sbus_get_ifp_extra(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "extraAttributes", _value);
}

errno_t
sbus_get_ifp_user_gecos
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "gecos", _value);
}

errno_t
sbus_get_ifp_user_gidNumber
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t* _value)
{
    return sbus_get_u(conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "gidNumber", _value);
}

errno_t
sbus_get_ifp_user_groups
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char *** _value)
{
    return sbus_get_ao(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "groups", _value);
}

errno_t
sbus_get_ifp_user_homeDirectory
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "homeDirectory", _value);
}

errno_t
sbus_get_ifp_user_loginShell
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "loginShell", _value);
}

errno_t
sbus_get_ifp_user_name
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "name", _value);
}

errno_t
sbus_get_ifp_user_uidNumber
    (struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     uint32_t* _value)
{
    return sbus_get_u(conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "uidNumber", _value);
}

errno_t
sbus_get_ifp_user_uniqueID
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     const char ** _value)
{
    return sbus_get_s(mem_ctx, conn, busname, object_path,
                "org.freedesktop.sssd.infopipe.Users.User", "uniqueID", _value);
}

errno_t
sbus_getall_ifp_components
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     struct sbus_all_ifp_components **_properties)
{
    TALLOC_CTX *tmp_ctx;
    struct sbus_all_ifp_components *properties;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    properties = talloc_zero(tmp_ctx, struct sbus_all_ifp_components);
    if (properties == NULL) {
        ret = ENOMEM;
        goto done;
    }

    struct sbus_parse_getall_table table[] = {
        {"debug_level", (sbus_value_reader_fn)sbus_iterator_read_u, NULL,
         &properties->debug_level.value, &properties->debug_level.is_set},
        {"enabled", (sbus_value_reader_fn)sbus_iterator_read_b, NULL,
         &properties->enabled.value, &properties->enabled.is_set},
        {"name", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->name.value, &properties->name.is_set},
        {"providers", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_as,
         &properties->providers.value, &properties->providers.is_set},
        {"type", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->type.value, &properties->type.is_set},
        {NULL, NULL, NULL, NULL, NULL}
    };

    ret = sbus_call_DBusProperties_GetAll(tmp_ctx, conn,
              busname, object_path, "org.freedesktop.sssd.infopipe.Components", &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_parse_getall_message(properties, table, reply);
    if (ret != EOK) {
        goto done;
    }

    *_properties = talloc_steal(mem_ctx, properties);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

errno_t
sbus_getall_ifp_domains
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     struct sbus_all_ifp_domains **_properties)
{
    TALLOC_CTX *tmp_ctx;
    struct sbus_all_ifp_domains *properties;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    properties = talloc_zero(tmp_ctx, struct sbus_all_ifp_domains);
    if (properties == NULL) {
        ret = ENOMEM;
        goto done;
    }

    struct sbus_parse_getall_table table[] = {
        {"enumerable", (sbus_value_reader_fn)sbus_iterator_read_b, NULL,
         &properties->enumerable.value, &properties->enumerable.is_set},
        {"max_id", (sbus_value_reader_fn)sbus_iterator_read_u, NULL,
         &properties->max_id.value, &properties->max_id.is_set},
        {"min_id", (sbus_value_reader_fn)sbus_iterator_read_u, NULL,
         &properties->min_id.value, &properties->min_id.is_set},
        {"subdomain", (sbus_value_reader_fn)sbus_iterator_read_b, NULL,
         &properties->subdomain.value, &properties->subdomain.is_set},
        {"use_fully_qualified_names", (sbus_value_reader_fn)sbus_iterator_read_b, NULL,
         &properties->use_fully_qualified_names.value, &properties->use_fully_qualified_names.is_set},
        {"backup_servers", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_as,
         &properties->backup_servers.value, &properties->backup_servers.is_set},
        {"forest", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->forest.value, &properties->forest.is_set},
        {"fully_qualified_name_format", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->fully_qualified_name_format.value, &properties->fully_qualified_name_format.is_set},
        {"login_format", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->login_format.value, &properties->login_format.is_set},
        {"name", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->name.value, &properties->name.is_set},
        {"parent_domain", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_o,
         &properties->parent_domain.value, &properties->parent_domain.is_set},
        {"primary_servers", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_as,
         &properties->primary_servers.value, &properties->primary_servers.is_set},
        {"provider", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->provider.value, &properties->provider.is_set},
        {"realm", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->realm.value, &properties->realm.is_set},
        {NULL, NULL, NULL, NULL, NULL}
    };

    ret = sbus_call_DBusProperties_GetAll(tmp_ctx, conn,
              busname, object_path, "org.freedesktop.sssd.infopipe.Domains", &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_parse_getall_message(properties, table, reply);
    if (ret != EOK) {
        goto done;
    }

    *_properties = talloc_steal(mem_ctx, properties);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

errno_t
sbus_getall_ifp_group
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     struct sbus_all_ifp_group **_properties)
{
    TALLOC_CTX *tmp_ctx;
    struct sbus_all_ifp_group *properties;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    properties = talloc_zero(tmp_ctx, struct sbus_all_ifp_group);
    if (properties == NULL) {
        ret = ENOMEM;
        goto done;
    }

    struct sbus_parse_getall_table table[] = {
        {"gidNumber", (sbus_value_reader_fn)sbus_iterator_read_u, NULL,
         &properties->gidNumber.value, &properties->gidNumber.is_set},
        {"groups", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_ao,
         &properties->groups.value, &properties->groups.is_set},
        {"name", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->name.value, &properties->name.is_set},
        {"uniqueID", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->uniqueID.value, &properties->uniqueID.is_set},
        {"users", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_ao,
         &properties->users.value, &properties->users.is_set},
        {NULL, NULL, NULL, NULL, NULL}
    };

    ret = sbus_call_DBusProperties_GetAll(tmp_ctx, conn,
              busname, object_path, "org.freedesktop.sssd.infopipe.Groups.Group", &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_parse_getall_message(properties, table, reply);
    if (ret != EOK) {
        goto done;
    }

    *_properties = talloc_steal(mem_ctx, properties);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

errno_t
sbus_getall_ifp_user
    (TALLOC_CTX *mem_ctx,
     struct sbus_sync_connection *conn,
     const char *busname,
     const char *object_path,
     struct sbus_all_ifp_user **_properties)
{
    TALLOC_CTX *tmp_ctx;
    struct sbus_all_ifp_user *properties;
    DBusMessage *reply;
    errno_t ret;

    tmp_ctx = talloc_new(NULL);
    if (tmp_ctx == NULL) {
        DEBUG(SSSDBG_FATAL_FAILURE, "Out of memory!\n");
        return ENOMEM;
    }

    properties = talloc_zero(tmp_ctx, struct sbus_all_ifp_user);
    if (properties == NULL) {
        ret = ENOMEM;
        goto done;
    }

    struct sbus_parse_getall_table table[] = {
        {"gidNumber", (sbus_value_reader_fn)sbus_iterator_read_u, NULL,
         &properties->gidNumber.value, &properties->gidNumber.is_set},
        {"uidNumber", (sbus_value_reader_fn)sbus_iterator_read_u, NULL,
         &properties->uidNumber.value, &properties->uidNumber.is_set},
        {"domain", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_o,
         &properties->domain.value, &properties->domain.is_set},
        {"domainname", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->domainname.value, &properties->domainname.is_set},
        {"extraAttributes", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_ifp_extra,
         &properties->extraAttributes.value, &properties->extraAttributes.is_set},
        {"gecos", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->gecos.value, &properties->gecos.is_set},
        {"groups", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_ao,
         &properties->groups.value, &properties->groups.is_set},
        {"homeDirectory", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->homeDirectory.value, &properties->homeDirectory.is_set},
        {"loginShell", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->loginShell.value, &properties->loginShell.is_set},
        {"name", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->name.value, &properties->name.is_set},
        {"uniqueID", NULL, (sbus_value_reader_talloc_fn)sbus_iterator_read_s,
         &properties->uniqueID.value, &properties->uniqueID.is_set},
        {NULL, NULL, NULL, NULL, NULL}
    };

    ret = sbus_call_DBusProperties_GetAll(tmp_ctx, conn,
              busname, object_path, "org.freedesktop.sssd.infopipe.Users.User", &reply);
    if (ret != EOK) {
        goto done;
    }

    ret = sbus_parse_getall_message(properties, table, reply);
    if (ret != EOK) {
        goto done;
    }

    *_properties = talloc_steal(mem_ctx, properties);

    ret = EOK;

done:
    talloc_free(tmp_ctx);

    return ret;
}

