/*
    Authors:
        Jakub Hrozek <jhrozek@redhat.com>

    Copyright (C) 2013 Red Hat

    SSSD tests: Common utilities for tests that exercise domains

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "util/util.h"
#include "tests/cmocka/common_mock_resp.h"

/* Mock a responder context */
struct resp_ctx *
mock_rctx(TALLOC_CTX *mem_ctx,
          struct tevent_context *ev,
          struct sss_domain_info *domains,
          void *pvt_ctx)
{
    struct resp_ctx *rctx;
    errno_t ret;

    rctx = talloc_zero(mem_ctx, struct resp_ctx);
    if (!rctx) return NULL;

    ret = sss_hash_create(rctx, 30, &rctx->dp_request_table);
    if (ret != EOK) {
        talloc_free(rctx);
        return NULL;
    }

    rctx->ev = ev;
    rctx->domains = domains;
    rctx->pvt_ctx = pvt_ctx;
    return rctx;
}

/* Mock a client context */
struct cli_ctx *
mock_cctx(TALLOC_CTX *mem_ctx, struct resp_ctx *rctx)
{
    struct cli_ctx *cctx;

    cctx = talloc_zero(mem_ctx, struct cli_ctx);
    if (!cctx) return NULL;

    cctx->creq = talloc_zero(cctx, struct cli_request);
    if (cctx->creq == NULL) {
        talloc_free(cctx);
        return NULL;
    }

    cctx->rctx = rctx;
    return cctx;
}
