/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.WarnStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppenderBase<E>
extends ContextAwareBase
implements Appender<E>,
FilterAttachable {
    protected boolean started = false;
    private boolean guard = false;
    protected String name;
    private FilterAttachableImpl fai = new FilterAttachableImpl();
    private int statusRepeatCount = 0;
    private int exceptionCount = 0;
    static final int ALLOWED_REPEATS = 5;

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void doAppend(E eventObject) {
        if (this.guard) {
            return;
        }
        try {
            this.guard = true;
            if (!this.started) {
                if (this.statusRepeatCount++ >= 5) return;
                this.addStatus(new WarnStatus("Attempted to append to non started appender [" + this.name + "].", this));
                return;
            }
        }
        catch (Exception e) {
            if (this.exceptionCount++ >= 5) return;
            this.addError("Appender [" + this.name + "] failed to append.", e);
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            if (this.getFilterChainDecision(eventObject) == FilterReply.DENY) {
                return;
            }
            this.append(eventObject);
            return;
        }
    }

    protected abstract void append(E var1);

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.name + "]";
    }

    @Override
    public void addFilter(Filter newFilter) {
        this.fai.addFilter(newFilter);
    }

    @Override
    public Filter getFirstFilter() {
        return this.fai.getFirstFilter();
    }

    @Override
    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    @Override
    public FilterReply getFilterChainDecision(Object event) {
        return this.fai.getFilterChainDecision(event);
    }

    @Override
    public Layout<E> getLayout() {
        return null;
    }

    @Override
    public void setLayout(Layout<E> layout) {
    }
}

