/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import org.apache.log4j.ULogger;
import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class ThrowableInformationPatternConverter
extends LoggingEventPatternConverter {
    private final String option;

    private ThrowableInformationPatternConverter(String[] options, ULogger logger) {
        super("Throwable", "throwable");
        this.option = options != null && options.length > 0 ? options[0] : null;
    }

    public static ThrowableInformationPatternConverter newInstance(String[] options, ULogger logger) {
        return new ThrowableInformationPatternConverter(options, logger);
    }

    public void format(LoggingEvent event, StringBuffer toAppendTo) {
        ThrowableInformation information = event.getThrowableInformation();
        if (information != null) {
            String[] stringRep = information.getThrowableStrRep();
            int length = 0;
            length = this.option == null ? stringRep.length : (this.option.equals("full") ? stringRep.length : (this.option.equals("short") ? 1 : stringRep.length));
            int i = 0;
            while (i < length) {
                String string = stringRep[i];
                toAppendTo.append(string).append("\n");
                ++i;
            }
        }
    }

    public boolean handlesThrowable() {
        return true;
    }
}

