/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.Attributes;

public class IncludeFileAction
extends Action {
    private static final String INCLUDED_TAG = "included";
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private SaxEventRecorder recorder = new SaxEventRecorder();

    public void begin(InterpretationContext ec, String name, Attributes attributes) throws ActionException {
        SaxEvent last;
        String attFile = attributes.getValue(FILE_ATTR);
        String attUrl = attributes.getValue(URL_ATTR);
        if (attFile == null && attUrl == null) {
            this.addError("One of path and URL attribute must be set.");
            return;
        }
        String pathToFile = null;
        if (attFile != null) {
            pathToFile = attFile.startsWith("$") ? ec.subst(attFile) : attFile;
        }
        URL urlToFile = null;
        if (attUrl != null) {
            String tmpUrl = attUrl.startsWith("$") ? ec.subst(attUrl) : attUrl;
            try {
                urlToFile = new URL(tmpUrl);
            }
            catch (MalformedURLException mue) {
                String errMsg = "URL [" + tmpUrl + "] is not well formed.";
                this.addError(errMsg, mue);
                return;
            }
        }
        try {
            InputStream in = this.getInputStream(pathToFile, urlToFile);
            if (in != null) {
                this.parseAndRecord(in);
                in.close();
            }
        }
        catch (JoranException e) {
            this.addError("Error while parsing file " + pathToFile + (Object)((Object)e));
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.recorder.saxEventList.size() == 0) {
            return;
        }
        SaxEvent first = (SaxEvent)this.recorder.saxEventList.get(0);
        if (first != null && first.qName.equalsIgnoreCase(INCLUDED_TAG)) {
            this.recorder.saxEventList.remove(0);
        }
        if ((last = (SaxEvent)this.recorder.saxEventList.get(this.recorder.saxEventList.size() - 1)) != null && last.qName.equalsIgnoreCase(INCLUDED_TAG)) {
            this.recorder.saxEventList.remove(this.recorder.saxEventList.size() - 1);
        }
        ec.getJoranInterpreter().addEvents(this.recorder.saxEventList);
    }

    private InputStream getInputStream(String pathToFile, URL urlToFile) {
        if (pathToFile != null) {
            try {
                return new FileInputStream(pathToFile);
            }
            catch (IOException ioe) {
                String errMsg = "File [" + pathToFile + "] does not exist.";
                this.addError(errMsg, ioe);
                return null;
            }
        }
        try {
            return urlToFile.openStream();
        }
        catch (IOException e) {
            String errMsg = "URL [" + urlToFile.toString() + "] does not exist.";
            this.addError(errMsg, e);
            return null;
        }
    }

    private void parseAndRecord(InputStream inputSource) throws JoranException {
        this.recorder.setContext(this.context);
        this.recorder.recordEvents(inputSource);
    }

    public void end(InterpretationContext ec, String name) throws ActionException {
    }
}

