/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.db;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DBHelper;
import ch.qos.logback.core.db.dialect.DBUtil;
import ch.qos.logback.core.db.dialect.SQLDialect;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBAppenderBase<E>
extends AppenderBase<E> {
    protected ConnectionSource connectionSource;
    protected boolean cnxSupportsGetGeneratedKeys = false;
    protected boolean cnxSupportsBatchUpdates = false;
    protected SQLDialect sqlDialect;

    protected abstract Method getGeneratedKeysMethod();

    protected abstract String getInsertSQL();

    @Override
    public void start() {
        if (this.connectionSource == null) {
            throw new IllegalStateException("DBAppender cannot function without a connection source");
        }
        this.sqlDialect = DBUtil.getDialectFromCode(this.connectionSource.getSQLDialectCode());
        this.cnxSupportsGetGeneratedKeys = this.getGeneratedKeysMethod() != null ? this.connectionSource.supportsGetGeneratedKeys() : false;
        this.cnxSupportsBatchUpdates = this.connectionSource.supportsBatchUpdates();
        if (!this.cnxSupportsGetGeneratedKeys && this.sqlDialect == null) {
            throw new IllegalStateException("DBAppender cannot function if the JDBC driver does not support getGeneratedKeys method *and* without a specific SQL dialect");
        }
        super.start();
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    @Override
    public void append(E eventObject) {
        Connection connection = null;
        try {
            try {
                connection = this.connectionSource.getConnection();
                connection.setAutoCommit(false);
                PreparedStatement insertStatement = connection.prepareStatement(this.getInsertSQL());
                this.subAppend(eventObject, connection, insertStatement);
                if (insertStatement != null) {
                    insertStatement.close();
                    insertStatement = null;
                }
                connection.commit();
            }
            catch (Throwable sqle) {
                this.addError("problem appending event", sqle);
            }
        }
        catch (Throwable throwable) {
            DBHelper.closeConnection(connection);
            throw throwable;
        }
        DBHelper.closeConnection(connection);
    }

    protected abstract void subAppend(Object var1, Connection var2, PreparedStatement var3) throws Throwable;

    protected int getEventId(PreparedStatement insertStatement, Connection connection) throws SQLException, InvocationTargetException {
        ResultSet rs = null;
        Statement idStatement = null;
        boolean gotGeneratedKeys = false;
        if (this.cnxSupportsGetGeneratedKeys) {
            try {
                rs = (ResultSet)this.getGeneratedKeysMethod().invoke((Object)insertStatement, null);
                gotGeneratedKeys = true;
            }
            catch (InvocationTargetException ex) {
                Throwable target = ex.getTargetException();
                if (target instanceof SQLException) {
                    throw (SQLException)target;
                }
                throw ex;
            }
            catch (IllegalAccessException ex) {
                this.addWarn("IllegalAccessException invoking PreparedStatement.getGeneratedKeys", ex);
            }
        }
        if (!gotGeneratedKeys) {
            insertStatement.close();
            insertStatement = null;
            idStatement = connection.createStatement();
            idStatement.setMaxRows(1);
            rs = idStatement.executeQuery(this.sqlDialect.getSelectInsertId());
        }
        rs.next();
        int eventId = rs.getInt(1);
        rs.close();
        if (idStatement != null) {
            idStatement.close();
            idStatement = null;
        }
        return eventId;
    }

    @Override
    public void stop() {
        super.stop();
    }
}

