/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.core.CoreGlobal;
import java.io.Serializable;

public class CallerData
implements Serializable {
    private static final long serialVersionUID = 2473626903716082403L;
    public static final String NA = "?";
    public static final int LINE_NA = -1;
    public static String CALLER_DATA_NA = "?#?:?" + CoreGlobal.LINE_SEPARATOR;
    int lineNumber;
    String fileName;
    String className;
    String methodName;
    boolean nativeMethod = false;

    public CallerData(String fileName, String className, String methodName, int lineNumber) {
        this.fileName = fileName;
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public CallerData(StackTraceElement ste) {
        this.className = ste.getClassName();
        this.fileName = ste.getFileName();
        this.methodName = ste.getMethodName();
        this.lineNumber = ste.getLineNumber();
        this.nativeMethod = ste.isNativeMethod();
    }

    public static CallerData[] extract(Throwable t, String fqnOfInvokingClass) {
        if (t == null) {
            return null;
        }
        StackTraceElement[] steArray = t.getStackTrace();
        int found = -1;
        int i = 0;
        while (i < steArray.length) {
            if (steArray[i].getClassName().equals(fqnOfInvokingClass)) {
                found = i + 1;
            } else if (found != -1) break;
            ++i;
        }
        CallerData[] callerDataArray = new CallerData[steArray.length - found];
        i = found;
        while (i < steArray.length) {
            callerDataArray[i - found] = new CallerData(steArray[i]);
            ++i;
        }
        return callerDataArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallerData)) {
            return false;
        }
        CallerData r = (CallerData)o;
        if (!this.getClassName().equals(r.getClassName())) {
            return false;
        }
        if (!this.getFileName().equals(r.getFileName())) {
            return false;
        }
        if (!this.getMethodName().equals(r.getMethodName())) {
            return false;
        }
        return this.lineNumber == r.lineNumber;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClassName());
        buf.append('.');
        buf.append(this.getMethodName());
        buf.append('(');
        if (this.isNativeMethod()) {
            buf.append("Native Method");
        } else if (this.getFileName() == null) {
            buf.append("Unknown Source");
        } else {
            buf.append(this.getFileName());
            buf.append(':');
            buf.append(this.getLineNumber());
        }
        buf.append(')');
        return buf.toString();
    }

    public boolean isNativeMethod() {
        return this.nativeMethod;
    }
}

