/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import org.apache.log4j.Layout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.helpers.OptionConverter;

public class FileAppender
extends WriterAppender {
    protected boolean fileAppend = true;
    protected String fileName = null;
    protected boolean bufferedIO = false;
    protected int bufferSize = 8192;

    public FileAppender() {
    }

    public FileAppender(Layout layout, String filename, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        this.layout = layout;
        this.setFile(filename, append, bufferedIO, bufferSize);
        this.activateOptions();
    }

    public FileAppender(Layout layout, String filename, boolean append) throws IOException {
        this.layout = layout;
        this.setFile(filename, append, false, this.bufferSize);
        this.activateOptions();
    }

    public FileAppender(Layout layout, String filename) throws IOException {
        this(layout, filename, true);
        this.activateOptions();
    }

    public void setFile(String file) {
        String val = file.trim();
        this.fileName = OptionConverter.stripDuplicateBackslashes(val);
    }

    public boolean getAppend() {
        return this.fileAppend;
    }

    public String getFile() {
        return this.fileName;
    }

    public void activateOptions() {
        if (this.fileName != null) {
            try {
                this.setFile(this.fileName, this.fileAppend, this.bufferedIO, this.bufferSize);
                super.activateOptions();
            }
            catch (IOException e) {
                this.getLogger().error((Object)("setFile(" + this.fileName + "," + this.fileAppend + ") call failed."), e);
            }
        } else {
            this.getLogger().error((Object)"File option not set for appender [{}].", this.name);
            this.getLogger().warn("Are you using FileAppender instead of ConsoleAppender?");
        }
    }

    protected void closeFile() {
        this.closeWriter();
    }

    public boolean getBufferedIO() {
        return this.bufferedIO;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setAppend(boolean flag) {
        this.fileAppend = flag;
    }

    public void setBufferedIO(boolean bufferedIO) {
        this.bufferedIO = bufferedIO;
        if (bufferedIO) {
            this.immediateFlush = false;
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public synchronized void setFile(String filename, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        this.getLogger().debug("setFile called: {}, {}", this.fileName, append ? "true" : "false");
        if (bufferedIO) {
            this.setImmediateFlush(false);
        }
        this.closeWriter();
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(filename, append);
        }
        catch (FileNotFoundException ex) {
            File parentDir = new File(new File(filename).getParent());
            if (!parentDir.exists() && parentDir.mkdirs()) {
                ostream = new FileOutputStream(filename, append);
            }
            throw ex;
        }
        Writer fw = this.createWriter(ostream);
        if (bufferedIO) {
            fw = new BufferedWriter(this.qw, bufferSize);
        }
        this.setQWForFiles(fw);
        this.fileAppend = append;
        this.bufferedIO = bufferedIO;
        this.fileName = filename;
        this.bufferSize = bufferSize;
        this.writeHeader();
        this.getLogger().debug("setFile ended");
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = this.createQuietWriter(writer);
    }

    protected void reset() {
        this.closeFile();
        this.fileName = null;
        super.reset();
    }
}

