/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.rolling.RollingFileAppender;
import org.apache.log4j.rolling.TimeBasedRollingPolicy;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public final class DailyRollingFileAppender
implements Appender,
OptionHandler {
    private final ErrorHandler errorHandler = new OnlyOnceErrorHandler();
    private String datePattern = "'.'yyyy-MM-dd";
    private final RollingFileAppender rfa = new RollingFileAppender();

    public DailyRollingFileAppender() {
    }

    public DailyRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        this.rfa.setLayout(layout);
        this.rfa.setFile(filename);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        TimeBasedRollingPolicy policy = new TimeBasedRollingPolicy();
        StringBuffer pattern = new StringBuffer(this.rfa.getFile());
        boolean inLiteral = false;
        boolean inPattern = false;
        int i = 0;
        while (i < this.datePattern.length()) {
            if (this.datePattern.charAt(i) == '\'') {
                boolean bl = inLiteral = !inLiteral;
                if (inLiteral && inPattern) {
                    pattern.append("}");
                    inPattern = false;
                }
            } else {
                if (!inLiteral && !inPattern) {
                    pattern.append("%d{");
                    inPattern = true;
                }
                pattern.append(this.datePattern.charAt(i));
            }
            ++i;
        }
        if (inPattern) {
            pattern.append("}");
        }
        policy.setFileNamePattern(pattern.toString());
        policy.activateOptions();
        this.rfa.setTriggeringPolicy(policy);
        this.rfa.setRollingPolicy(policy);
        this.rfa.activateOptions();
    }

    public void addFilter(Filter newFilter) {
        this.rfa.addFilter(newFilter);
    }

    public Filter getFilter() {
        return this.rfa.getFilter();
    }

    public void clearFilters() {
        this.rfa.clearFilters();
    }

    public void close() {
        this.rfa.close();
    }

    public boolean isClosed() {
        return this.rfa.isClosed();
    }

    public boolean isActive() {
        return this.rfa.isActive();
    }

    public void doAppend(LoggingEvent event) {
        this.rfa.doAppend(event);
    }

    public String getName() {
        return this.rfa.getName();
    }

    public void setLayout(Layout layout) {
        this.rfa.setLayout(layout);
    }

    public Layout getLayout() {
        return this.rfa.getLayout();
    }

    public void setName(String name) {
        this.rfa.setName(name);
    }

    public void setLoggerRepository(LoggerRepository repository) throws IllegalStateException {
        this.rfa.setLoggerRepository(repository);
    }

    public void setFile(String file) {
        this.rfa.setFile(file);
    }

    public boolean getAppend() {
        return this.rfa.getAppend();
    }

    public String getFile() {
        return this.rfa.getFile();
    }

    public boolean getBufferedIO() {
        return this.rfa.getBufferedIO();
    }

    public int getBufferSize() {
        return this.rfa.getBufferSize();
    }

    public void setAppend(boolean flag) {
        this.rfa.setAppend(flag);
    }

    public void setBufferedIO(boolean bufferedIO) {
        this.rfa.setBufferedIO(bufferedIO);
    }

    public void setBufferSize(int bufferSize) {
        this.rfa.setBufferSize(bufferSize);
    }

    public final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(ErrorHandler eh) {
    }

    public boolean requiresLayout() {
        return true;
    }
}

