/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.helpers.Option;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.spi.ActionException;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.OptionHandler;
import org.xml.sax.Attributes;

public class AppenderAction
extends Action {
    Appender appender;
    private boolean inError = false;
    static /* synthetic */ Class class$org$apache$log4j$Appender;

    public void begin(ExecutionContext ec, String localName, Attributes attributes) throws ActionException {
        String className = attributes.getValue("class");
        this.appender = null;
        this.inError = false;
        try {
            this.getLogger().debug((Object)"About to instantiate appender of type [{}]", className);
            this.appender = (Appender)OptionConverter.instantiateByClassName(className, class$org$apache$log4j$Appender == null ? (class$org$apache$log4j$Appender = AppenderAction.class$("org.apache.log4j.Appender")) : class$org$apache$log4j$Appender, null);
            LoggerRepository repo = (LoggerRepository)ec.getObjectStack().get(0);
            this.appender.setLoggerRepository(repo);
            String appenderName = attributes.getValue("name");
            if (Option.isEmpty(appenderName)) {
                this.getLogger().warn("No appender name given for appender of type " + className + "].");
            } else {
                this.appender.setName(appenderName);
                this.getLogger().debug("Appender named as [" + appenderName + "]");
            }
            HashMap appenderBag = (HashMap)ec.getObjectMap().get("APPENDER_BAG");
            appenderBag.put(appenderName, this.appender);
            this.getLogger().debug("Pushing appender on to the object stack.");
            ec.pushObject(this.appender);
        }
        catch (Exception oops) {
            this.inError = true;
            this.getLogger().error((Object)"Could not create an Appender. Reported error follows.", oops);
            ec.addError(new ErrorItem("Could not create appender of type " + className + "]."));
            throw new ActionException(1, (Throwable)oops);
        }
    }

    public void end(ExecutionContext ec, String name) {
        Object o;
        if (this.inError) {
            return;
        }
        if (this.appender instanceof OptionHandler) {
            ((OptionHandler)((Object)this.appender)).activateOptions();
        }
        if ((o = ec.peekObject()) != this.appender) {
            this.getLogger().warn("The object at the of the stack is not the appender named [" + this.appender.getName() + "] pushed earlier.");
        } else {
            this.getLogger().debug("Popping appender named [" + this.appender.getName() + "] from the object stack");
            ec.popObject();
        }
    }

    public void finish(ExecutionContext ec) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

